/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.modules.properties.render;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import smartin.miapi.Miapi;
import smartin.miapi.client.model.MiapiItemModel;
import smartin.miapi.client.model.module.BlockRenderModel;
import smartin.miapi.item.modular.Transform;
import smartin.miapi.material.MaterialIcons;
import smartin.miapi.modules.properties.util.CodecProperty;
import smartin.miapi.modules.properties.util.MergeAble;
import smartin.miapi.modules.properties.util.MergeType;

public class BlockModelProperty
extends CodecProperty<List<BlockModelData>> {
    public static final ResourceLocation KEY = Miapi.id("block_model");
    public static BlockModelProperty property;
    public static final Codec<BlockModelData> BLOCK_MODEL_DATA_CODEC;
    public static final Codec<List<BlockModelData>> CODEC;

    public BlockModelProperty() {
        super(CODEC);
        property = this;
        MiapiItemModel.modelSuppliers.add((key, mode, model, stack) -> {
            ArrayList models = new ArrayList();
            this.getData(model).ifPresent(modelDataList -> modelDataList.forEach(blockModelData -> {
                DataResult result;
                Block block = (Block)BuiltInRegistries.BLOCK.get(blockModelData.id());
                BlockState blockState = block.defaultBlockState();
                if (blockModelData.nbt.isPresent() && (result = BlockState.CODEC.parse(Miapi.BOOL_CORRECTED_OPS, (Object)((Tag)blockModelData.nbt.get()))).isSuccess()) {
                    blockState = (BlockState)result.result().get();
                }
                BlockRenderModel blockRenderModel = new BlockRenderModel(blockState, blockModelData.transform());
                blockModelData.spin().ifPresent(spin -> {
                    blockRenderModel.spinSettings = spin;
                });
                models.add(blockRenderModel);
            }));
            return models;
        });
    }

    @Override
    public List<BlockModelData> merge(List<BlockModelData> left, List<BlockModelData> right, MergeType mergeType) {
        return MergeAble.mergeList(left, right, mergeType);
    }

    static {
        BLOCK_MODEL_DATA_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ResourceLocation.CODEC.fieldOf("id").forGetter(BlockModelData::id), (App)CompoundTag.CODEC.optionalFieldOf("nbt").forGetter(BlockModelData::nbt), (App)Transform.CODEC.optionalFieldOf("transform", (Object)Transform.IDENTITY).forGetter(BlockModelData::transform), (App)MaterialIcons.SpinSettings.CODEC.optionalFieldOf("spin").forGetter(BlockModelData::spin)).apply((Applicative)instance, BlockModelData::new));
        CODEC = Codec.list(BLOCK_MODEL_DATA_CODEC);
    }

    public record BlockModelData(ResourceLocation id, Optional<CompoundTag> nbt, Transform transform, Optional<MaterialIcons.SpinSettings> spin) {
    }
}

