/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.modules.properties.render;

import com.redpxnda.nucleus.codec.auto.AutoCodec;
import com.redpxnda.nucleus.codec.behavior.CodecBehavior;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector4f;
import smartin.miapi.Miapi;
import smartin.miapi.client.model.MiapiItemModel;
import smartin.miapi.item.modular.Transform;
import smartin.miapi.modules.ItemModule;
import smartin.miapi.modules.ModuleInstance;
import smartin.miapi.modules.properties.slot.SlotProperty;
import smartin.miapi.modules.properties.util.CodecProperty;
import smartin.miapi.modules.properties.util.MergeAble;
import smartin.miapi.modules.properties.util.MergeType;
import smartin.miapi.modules.properties.util.ModuleProperty;

@OnlyIn(value=Dist.CLIENT)
public class GuiOffsetProperty
extends CodecProperty<GuiOffsetData> {
    public static final ResourceLocation KEY = Miapi.id("gui_offset");
    public static ModuleProperty property;

    public GuiOffsetProperty() {
        super(AutoCodec.of(GuiOffsetData.class).codec());
        property = this;
        MiapiItemModel.modelTransformersSuppler.add((itemStack, modelType, mode) -> {
            if (ItemDisplayContext.GUI.equals((Object)mode)) {
                float[] data = this.getGuiOffsets(itemStack, modelType);
                return (matrices, tickDelta) -> {
                    matrices.translate(data[0], data[1], 0.0f);
                    matrices.scale(data[2], data[3], data[4]);
                    return matrices;
                };
            }
            return null;
        });
    }

    public float[] getGuiOffsets(ItemStack itemStack, String modelType) {
        GuiOffsetData guiOffsetJson = new GuiOffsetData();
        for (ModuleInstance instance : ItemModule.createFlatList(ItemModule.getModules(itemStack))) {
            Optional optional = this.getData(instance);
            if (!optional.isPresent()) continue;
            GuiOffsetData add = (GuiOffsetData)optional.get();
            Transform transform = SlotProperty.getLocalTransformStack(instance).get(modelType);
            Matrix4f matrix4f = transform.toMatrix();
            Vector4f offsetPos = new Vector4f(add.x, add.y, 0.0f, 0.0f);
            offsetPos = offsetPos.mul((Matrix4fc)matrix4f);
            guiOffsetJson.x += offsetPos.x();
            guiOffsetJson.y += offsetPos.y();
            Vector4f sizeVec = new Vector4f(add.sizeX, add.sizeY, 0.0f, 0.0f);
            sizeVec = sizeVec.mul((Matrix4fc)matrix4f);
            guiOffsetJson.sizeX += sizeVec.x();
            guiOffsetJson.sizeY += sizeVec.y();
        }
        float baseSize = 16.0f;
        guiOffsetJson.x /= baseSize;
        guiOffsetJson.y /= baseSize;
        guiOffsetJson.sizeX = baseSize / (baseSize + guiOffsetJson.sizeX);
        guiOffsetJson.sizeY = baseSize / (baseSize + guiOffsetJson.sizeY);
        float zScale = (guiOffsetJson.sizeX + guiOffsetJson.sizeY) / 2.0f;
        return new float[]{guiOffsetJson.x, guiOffsetJson.y, guiOffsetJson.sizeX, guiOffsetJson.sizeY, zScale};
    }

    @Override
    public GuiOffsetData merge(GuiOffsetData left, GuiOffsetData right, MergeType mergeType) {
        return MergeAble.decideLeftRight(left, right, mergeType);
    }

    public static class GuiOffsetData {
        @CodecBehavior.Optional
        public float x = 0.0f;
        @CodecBehavior.Optional
        public float y = 0.0f;
        @CodecBehavior.Optional
        public float sizeX = 0.0f;
        @CodecBehavior.Optional
        public float sizeY = 0.0f;
    }
}

