/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.modules.properties.render;

import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ChargedProjectiles;
import net.minecraft.world.level.ItemLike;
import smartin.miapi.Environment;
import smartin.miapi.Miapi;
import smartin.miapi.client.model.MiapiItemModel;
import smartin.miapi.client.model.module.ItemInModuleMiapiModel;
import smartin.miapi.material.MaterialInscribeDataProperty;
import smartin.miapi.modules.properties.render.ModelJson;
import smartin.miapi.modules.properties.render.ModelProperty;
import smartin.miapi.modules.properties.util.CodecProperty;
import smartin.miapi.modules.properties.util.MergeAble;
import smartin.miapi.modules.properties.util.MergeType;

public class ItemModelProperty
extends CodecProperty<List<ModelJson>> {
    public static final ResourceLocation KEY = Miapi.id("item_model");
    public static ItemModelProperty property;
    public static Codec<ModelJson> CODEC;
    public static DataComponentType<ItemStack> ITEM_MODEL_COMPONENT;

    public ItemModelProperty() {
        super(Codec.list(CODEC));
        property = this;
        if (Environment.isClient()) {
            this.clientSetup();
        }
    }

    public void clientSetup() {
        MiapiItemModel.modelSuppliers.add((key, mode, model, stack) -> {
            List modelJsons = this.getData(stack).orElse(new ArrayList());
            ArrayList models = new ArrayList();
            modelJsons.forEach(modelJson -> {
                Supplier<ItemStack> stackSupplier = switch (modelJson.type) {
                    case "item_nbt" -> () -> (ItemStack)stack.getOrDefault(ITEM_MODEL_COMPONENT, (Object)ItemStack.EMPTY);
                    case "module_data" -> {
                        if (ModelProperty.isAllowedKey(modelJson.modelType, key)) {
                            yield () -> MaterialInscribeDataProperty.readStackFromModuleInstance(model, modelJson.model);
                        }
                        yield () -> ItemStack.EMPTY;
                    }
                    case "item" -> {
                        if (ModelProperty.isAllowedKey(modelJson.modelType, key)) {
                            yield () -> new ItemStack((ItemLike)BuiltInRegistries.ITEM.get(ResourceLocation.parse((String)modelJson.model)));
                        }
                        yield () -> ItemStack.EMPTY;
                    }
                    case "projectile" -> new Supplier<ItemStack>(){
                        int hash = 0;
                        ItemStack cache = null;

                        @Override
                        public ItemStack get() {
                            Minecraft.getInstance().getProfiler().push("projectile");
                            Minecraft.getInstance().getProfiler().push("getProjectile");
                            ChargedProjectiles component = (ChargedProjectiles)stack.get(DataComponents.CHARGED_PROJECTILES);
                            Minecraft.getInstance().getProfiler().pop();
                            if (ModelProperty.isAllowedKey(modelJson.modelType, key) && component != null) {
                                if (this.hash == component.hashCode() && this.cache != null) {
                                    return this.cache;
                                }
                                assert (component != null);
                                Minecraft.getInstance().getProfiler().push("getItem");
                                List items = component.getItems();
                                Optional optional = items.stream().findFirst();
                                Minecraft.getInstance().getProfiler().pop();
                                if (optional.isPresent()) {
                                    if (this.cache != null && ItemStack.isSameItem((ItemStack)((ItemStack)optional.get()), (ItemStack)this.cache)) {
                                        Minecraft.getInstance().getProfiler().pop();
                                        return this.cache;
                                    }
                                    this.cache = (ItemStack)optional.get();
                                    this.hash = component.hashCode();
                                }
                                Minecraft.getInstance().getProfiler().pop();
                                return ((ChargedProjectiles)stack.get(DataComponents.CHARGED_PROJECTILES)).getItems().stream().findFirst().orElse(ItemStack.EMPTY);
                            }
                            Minecraft.getInstance().getProfiler().pop();
                            return ItemStack.EMPTY;
                        }
                    };
                    default -> throw new IllegalStateException("Unexpected value: " + modelJson.type);
                };
                ItemInModuleMiapiModel miapiModel = new ItemInModuleMiapiModel(stackSupplier, modelJson.transform.toMatrix());
                models.add(miapiModel);
            });
            return models;
        });
    }

    @Override
    public List<ModelJson> merge(List<ModelJson> left, List<ModelJson> right, MergeType mergeType) {
        return MergeAble.mergeList(left, right, mergeType);
    }

    static {
        CODEC = ModelJson.CODEC;
        ITEM_MODEL_COMPONENT = DataComponentType.builder().persistent(ItemStack.CODEC).networkSynchronized(ByteBufCodecs.fromCodec((Codec)ItemStack.CODEC)).build();
    }
}

