/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.modules.properties.render;

import com.google.gson.JsonElement;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.redpxnda.nucleus.codec.auto.AutoCodec;
import com.redpxnda.nucleus.codec.behavior.CodecBehavior;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Pattern;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.Material;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import smartin.miapi.Miapi;
import smartin.miapi.client.model.MiapiItemModel;
import smartin.miapi.client.model.MiapiModel;
import smartin.miapi.client.model.ModelHolder;
import smartin.miapi.client.model.module.BakedMiapiModel;
import smartin.miapi.material.MaterialProperty;
import smartin.miapi.modules.ItemModule;
import smartin.miapi.modules.ModuleInstance;
import smartin.miapi.modules.properties.render.ModelProperty;
import smartin.miapi.modules.properties.render.colorproviders.ColorProvider;
import smartin.miapi.modules.properties.util.CodecProperty;
import smartin.miapi.modules.properties.util.MergeAble;
import smartin.miapi.modules.properties.util.MergeType;

public class OverlayModelProperty
extends CodecProperty<List<OverlayModelData>> {
    public static Codec<List<OverlayModelData>> CODEC = Codec.list((Codec)AutoCodec.of(OverlayModelData.class).codec());
    public static final ResourceLocation KEY = Miapi.id("overlay_texture_model");
    public static OverlayModelProperty property;

    public OverlayModelProperty() {
        super(CODEC);
        property = this;
        MiapiItemModel.modelSuppliers.add(new MiapiItemModel.ModelSupplier(){

            @Override
            public List<MiapiModel> getModels(String key, @Nullable ItemDisplayContext model, ModuleInstance module, ItemStack stack) {
                ArrayList<MiapiModel> models = new ArrayList<MiapiModel>();
                ModuleInstance moduleInstance = module;
                for (ModuleInstance module2 : ItemModule.getModules(stack).allSubModules()) {
                    for (OverlayModelData modelData : (List)OverlayModelProperty.this.getData(module2).orElse(new ArrayList())) {
                        if (modelData.onlyOnSameModule() && !moduleInstance.equals(module2)) continue;
                        List list = ModelProperty.property.getData(moduleInstance).orElse(new ArrayList());
                        list.forEach(modelJson -> {
                            ModelHolder holder;
                            if (modelData.isValid((ModelProperty.ModelData)modelJson) && (holder = ModelProperty.bakedModel(moduleInstance, modelJson, stack, key)) != null) {
                                ColorProvider colorProvider = modelData.getColorProvider(stack, module2, moduleInstance, holder.colorProvider());
                                TextureAtlasSprite overWriteSprite = modelData.resolveSprite();
                                models.add(OverlayModelProperty.this.getBakedMiapiModel(module, stack, modelData, moduleInstance, holder, colorProvider, overWriteSprite));
                            }
                        });
                    }
                }
                return models;
            }

            @Override
            public List<Pair<Matrix4f, MiapiModel>> filter(List<Pair<Matrix4f, MiapiModel>> oldModels, ItemStack stack, ModuleInstance module, String key, ItemDisplayContext context) {
                ArrayList models = new ArrayList();
                return oldModels;
            }

            private static /* synthetic */ boolean lambda$filter$1(AtomicReference matrix4f, Pair a) {
                if (a.getSecond() instanceof BakedMiapiModel) {
                    matrix4f.set((Matrix4f)a.getFirst());
                }
                return !(a.getSecond() instanceof BakedMiapiModel);
            }
        });
    }

    @NotNull
    private BakedMiapiModel getBakedMiapiModel(final ModuleInstance module, ItemStack stack, final OverlayModelData modelData, ModuleInstance moduleInstance, ModelHolder holder, final ColorProvider colorProvider, final @Nullable TextureAtlasSprite overWriteSprite) {
        return new BakedMiapiModel(new ModelHolder(holder.model(), new Matrix4f((Matrix4fc)holder.matrix4f()), new ColorProvider(){

            @Override
            public VertexConsumer getConsumer(MultiBufferSource vertexConsumers, TextureAtlasSprite sprite, ItemStack stack, ModuleInstance moduleInstance, ItemDisplayContext mode) {
                return colorProvider.getConsumer(vertexConsumers, overWriteSprite == null ? sprite : overWriteSprite, stack, modelData.useThisModule() ? module : moduleInstance, mode);
            }

            @Override
            public ColorProvider getInstance(ItemStack stack, ModuleInstance instance) {
                return this;
            }
        }, new int[]{-1, -1}, holder.trimMode(), holder.entityRendering()), modelData.useThisModule() ? module : moduleInstance, stack);
    }

    @Override
    public boolean load(ResourceLocation id, JsonElement element, boolean isClient) throws Exception {
        ((List)this.decode(element)).forEach(OverlayModelData::loadSprite);
        return isClient;
    }

    @Override
    public List<OverlayModelData> merge(List<OverlayModelData> left, List<OverlayModelData> right, MergeType mergeType) {
        return MergeAble.mergeList(left, right, mergeType);
    }

    public static class OverlayModelData {
        @CodecBehavior.Optional
        public String texture;
        public String modelTargetType;
        public String modelTargetInfo;
        public String colorProvider;
        @CodecBehavior.Optional
        public double javaPriority = 0.0;
        @CodecBehavior.Optional
        public boolean allowOtherModules = false;

        @Nullable
        public TextureAtlasSprite resolveSprite() {
            if (this.texture == null) {
                return null;
            }
            return ModelProperty.textureGetter.apply(new Material(TextureAtlas.LOCATION_BLOCKS, ResourceLocation.parse((String)this.texture)));
        }

        public void loadSprite() {
            if (this.texture != null) {
                ModelProperty.textureGetter.apply(new Material(TextureAtlas.LOCATION_BLOCKS, ResourceLocation.parse((String)this.texture)));
            }
        }

        public ColorProvider getColorProvider(ItemStack itemStack, ModuleInstance current, ModuleInstance other, ColorProvider otherColor) {
            switch (this.colorProvider) {
                case "this": {
                    return ColorProvider.getProvider("material", itemStack, current);
                }
                case "other": {
                    return otherColor;
                }
            }
            if (ColorProvider.colorProviders.containsKey(this.colorProvider)) {
                return ColorProvider.getProvider(this.colorProvider, itemStack, current);
            }
            if (this.colorProvider.startsWith("material:")) {
                ResourceLocation materialId = ResourceLocation.parse((String)this.colorProvider.split(":", 2)[1]);
                smartin.miapi.material.base.Material material = MaterialProperty.MATERIAL_REGISTRY.get(materialId);
                if (material != null) {
                    return new ColorProvider.MaterialColorProvider(material);
                }
                Miapi.LOGGER.error("Could not find Material " + String.valueOf(materialId) + " for Color Provider ");
            }
            return otherColor;
        }

        public boolean useThisModule() {
            return !this.colorProvider.equals("other");
        }

        public boolean onlyOnSameModule() {
            return !this.allowOtherModules;
        }

        public boolean isValid(ModelProperty.ModelData modelJson) {
            Pattern pattern = Pattern.compile(this.modelTargetInfo);
            switch (this.modelTargetType) {
                case "id": {
                    return pattern.matcher(modelJson.id).find();
                }
                case "path": {
                    return pattern.matcher(modelJson.path).find();
                }
            }
            return false;
        }
    }
}

