/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.modules.properties.slot;

import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.resources.ResourceLocation;
import smartin.miapi.Miapi;
import smartin.miapi.datapack.ReloadEvents;
import smartin.miapi.modules.ItemModule;
import smartin.miapi.modules.ModuleInstance;
import smartin.miapi.modules.properties.slot.SlotProperty;
import smartin.miapi.modules.properties.util.CodecProperty;
import smartin.miapi.modules.properties.util.MergeAble;
import smartin.miapi.modules.properties.util.MergeType;
import smartin.miapi.registries.RegistryInventory;

public class AllowedSlots
extends CodecProperty<List<String>> {
    public static final ResourceLocation KEY = Miapi.id("allowed_in_slots");
    public static Codec<List<String>> CODEC = Codec.list((Codec)Codec.STRING);
    static HashMap<String, Set<ItemModule>> allowedInMap = new HashMap();
    public static AllowedSlots property;

    public AllowedSlots() {
        super(CODEC);
        RegistryInventory.ITEM_MODULE_MIAPI_REGISTRY.addCallback(itemModule -> AllowedSlots.getAllowedSlots(itemModule).forEach(slot -> {
            if (allowedInMap.containsKey(slot)) {
                allowedInMap.get(slot).add((ItemModule)itemModule);
            } else {
                HashSet<ItemModule> list = new HashSet<ItemModule>();
                list.add((ItemModule)itemModule);
                allowedInMap.put((String)slot, (Set<ItemModule>)list);
            }
        }));
        ReloadEvents.START.subscribe((isClient, registryAccess) -> allowedInMap.clear());
        property = this;
    }

    public static List<String> getAllowedSlots(ItemModule module) {
        return property.getData(module).orElse(new ArrayList());
    }

    public static List<String> getAllowedSlots(ModuleInstance module) {
        return property.getData(module).orElse(new ArrayList());
    }

    public static List<ItemModule> allowedIn(SlotProperty.ModuleSlot slot) {
        if (slot == null) {
            return new ArrayList<ItemModule>();
        }
        return RegistryInventory.ITEM_MODULE_MIAPI_REGISTRY.getFlatMap().values().stream().filter(m -> AllowedSlots.getAllowedSlots(m).stream().anyMatch(s -> slot.allowed.contains(s))).toList();
    }

    @Override
    public List<String> merge(List<String> left, List<String> right, MergeType mergeType) {
        return MergeAble.mergeList(left, right, mergeType);
    }
}

