/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.modules.properties.slot;

import com.google.gson.JsonElement;
import com.mojang.serialization.Codec;
import com.redpxnda.nucleus.codec.auto.AutoCodec;
import com.redpxnda.nucleus.codec.behavior.CodecBehavior;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Pattern;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;
import smartin.miapi.Miapi;
import smartin.miapi.item.modular.Transform;
import smartin.miapi.item.modular.TransformMap;
import smartin.miapi.modules.ItemModule;
import smartin.miapi.modules.ModuleInstance;
import smartin.miapi.modules.properties.slot.AllowedSlots;
import smartin.miapi.modules.properties.util.CodecProperty;
import smartin.miapi.modules.properties.util.EditorError;
import smartin.miapi.modules.properties.util.MergeAble;
import smartin.miapi.modules.properties.util.MergeType;
import smartin.miapi.registries.RegistryInventory;

public class SlotProperty
extends CodecProperty<Map<String, ModuleSlot>> {
    public static final ResourceLocation KEY = Miapi.id("slots");
    public static Codec<Map<String, ModuleSlot>> CODEC = Codec.unboundedMap((Codec)Codec.STRING, (Codec)AutoCodec.of(ModuleSlot.class).codec());

    public SlotProperty() {
        super(CODEC);
    }

    public static SlotProperty getInstance() {
        return (SlotProperty)RegistryInventory.MODULE_PROPERTY_MIAPI_REGISTRY.get(KEY);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static TransformMap getTransformStack(ModuleInstance instance) {
        ModuleSlot slot = SlotProperty.getSlotIn(instance);
        if (slot == null) {
            return new TransformMap();
        }
        return SlotProperty.getTransformStack(slot);
    }

    @Override
    public List<EditorError> validate(int line, Map<String, ModuleSlot> component, boolean isClient) {
        ArrayList<EditorError> list = new ArrayList<EditorError>();
        component.values().forEach(slot -> {
            String regex = "^[a-z_-]+(?:\\.[a-z._-]+)";
            if (Pattern.matches(regex, slot.translationKey) && Component.translatable((String)slot.translationKey).getString().equals(slot.translationKey)) {
                list.add(new EditorError(line, "translation seems to be missing!", EditorError.ErrorSeverity.WARNING));
            }
        });
        return list;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static TransformMap getTransformStack(ModuleSlot moduleSlot) {
        if (moduleSlot == null) {
            return new TransformMap();
        }
        TransformMap mergedTransform = new TransformMap();
        for (ModuleInstance current = moduleSlot.parent; current != null; current = current.getParent()) {
            TransformMap stack = SlotProperty.getLocalTransformStack(current);
            if (mergedTransform.primary == null && stack.primary != null) {
                mergedTransform.set(stack.primary, mergedTransform.get(null));
                mergedTransform.set(null, Transform.IDENTITY);
            }
            mergedTransform = TransformMap.merge(stack, mergedTransform);
        }
        if (!mergedTransform.isPresent("item")) {
            mergedTransform.set("item", mergedTransform.get(null));
        }
        mergedTransform = TransformMap.merge(moduleSlot.getTransformStack(), mergedTransform);
        return mergedTransform;
    }

    public static Map<String, ModuleSlot> getSlots(ModuleInstance instance) {
        LinkedHashMap<String, ModuleSlot> slots = new LinkedHashMap<String, ModuleSlot>(SlotProperty.getInstance().getData(instance).orElse(new LinkedHashMap()));
        instance.getSubModuleMap().forEach((id, module) -> {
            if (slots.containsKey(id)) {
                ((ModuleSlot)slots.get((Object)id)).parent = instance;
                ((ModuleSlot)slots.get((Object)id)).inSlot = module;
            } else {
                ModuleSlot slot = new ModuleSlot();
                slot.inSlot = module;
                slot.parent = instance;
                slots.put((String)id, slot);
            }
        });
        return slots;
    }

    public static String getSlotID(ModuleInstance instance) {
        if (instance.getParent() != null) {
            AtomicReference<String> id = new AtomicReference<String>("primary");
            instance.getParent().getSubModuleMap().forEach((number, module) -> {
                if (instance == module) {
                    id.set((String)number);
                }
            });
            return id.get();
        }
        return "primary";
    }

    @OnlyIn(value=Dist.CLIENT)
    public static Transform getLocalTransform(ModuleInstance instance) {
        ModuleSlot slot = SlotProperty.getSlotIn(instance);
        if (slot != null) {
            return slot.transform;
        }
        return Transform.IDENTITY;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static TransformMap getLocalTransformStack(ModuleInstance instance) {
        ModuleSlot slot = SlotProperty.getSlotIn(instance);
        if (slot != null) {
            Transform transform = slot.transform;
            TransformMap stack = new TransformMap();
            stack.add(transform);
            stack.primary = transform.origin;
            return stack;
        }
        return new TransformMap();
    }

    public static List<String> getLocationSave(ModuleInstance moduleInstance) {
        ModuleSlot slot = SlotProperty.getSlotIn(moduleInstance);
        if (slot != null) {
            return slot.getAsLocation();
        }
        return List.of();
    }

    @Nullable
    public static ModuleSlot getSlotIn(ModuleInstance instance) {
        if (instance != null && instance.getParent() != null) {
            Map<String, ModuleSlot> slots = SlotProperty.getSlots(instance.getParent());
            ModuleSlot slot = slots.values().stream().filter(moduleSlot -> {
                if (moduleSlot.inSlot == null) {
                    return false;
                }
                return moduleSlot.inSlot.equals(instance);
            }).findFirst().orElse(null);
            if (slot != null && slot.transform.origin != null && slot.transform.origin.isEmpty()) {
                slot.transform.origin = null;
            }
            if (slot != null && slot.translationKey == null) {
                slot.translationKey = "miapi.module.empty.name";
            }
            return slot;
        }
        return null;
    }

    @Override
    public Map<String, ModuleSlot> decode(JsonElement element) {
        Map map = (Map)super.decode(element);
        map.forEach((key, slot) -> {
            slot.id = key;
        });
        return map;
    }

    public static Optional<ModuleSlot> findSlot(ItemStack itemStack, List<String> slotLocation) {
        ModuleInstance moduleInstance = ItemModule.getModules(itemStack);
        if (moduleInstance != null) {
            for (int i = 0; i < slotLocation.size(); ++i) {
                String id = slotLocation.get(slotLocation.size() - i - 1);
                if (moduleInstance.getSubModule(id) != null) {
                    moduleInstance = moduleInstance.getSubModule(id);
                    continue;
                }
                if (slotLocation.size() != i - 1) continue;
                return Optional.ofNullable(SlotProperty.getSlots(moduleInstance).getOrDefault(id, new ModuleSlot(moduleInstance, null, id)));
            }
            if (moduleInstance != null) {
                return Optional.ofNullable(SlotProperty.getSlotIn(moduleInstance));
            }
        }
        return Optional.empty();
    }

    public static List<ModuleSlot> asSortedList(Map<String, ModuleSlot> map) {
        return map.entrySet().stream().sorted(Comparator.comparingDouble(a -> ((ModuleSlot)a.getValue()).priority)).map(Map.Entry::getValue).toList();
    }

    @Override
    public Map<String, ModuleSlot> merge(Map<String, ModuleSlot> left, Map<String, ModuleSlot> right, MergeType mergeType) {
        return MergeAble.mergeMap(left, right, mergeType);
    }

    @Override
    public Map<String, ModuleSlot> initialize(Map<String, ModuleSlot> property, ModuleInstance context) {
        property.forEach((id, slot) -> slot.initialize(context));
        List<Map.Entry> slots = property.entrySet().stream().sorted(Comparator.comparingDouble(a -> ((ModuleSlot)a.getValue()).priority)).toList();
        LinkedHashMap<String, ModuleSlot> initializedMap = new LinkedHashMap<String, ModuleSlot>();
        for (Map.Entry value : slots) {
            ((ModuleSlot)value.getValue()).initialize(context);
            initializedMap.put((String)value.getKey(), ((ModuleSlot)value.getValue()).copy(true));
        }
        return initializedMap;
    }

    public static class ModuleSlot {
        @CodecBehavior.Optional
        public Transform transform = Transform.IDENTITY;
        @CodecBehavior.Optional
        public String translationKey = "miapi.module.empty.name";
        @CodecBehavior.Optional
        public String slotType = "default";
        @CodecBehavior.Optional
        public List<String> allowed = new ArrayList<String>();
        @CodecBehavior.Optional
        public List<String> allowedMerge = new ArrayList<String>();
        @CodecBehavior.Optional
        public double priority = 0.0;
        @AutoCodec.Ignored
        public String id;
        @AutoCodec.Ignored
        @Nullable
        public ModuleInstance inSlot;
        @AutoCodec.Ignored
        @Nullable
        public ModuleInstance parent;

        public ModuleSlot(List<String> allowedList) {
            this.allowed = allowedList;
            this.id = "primary";
        }

        public ModuleSlot() {
            this.allowed = new ArrayList<String>();
            this.id = "primary";
        }

        public ModuleSlot(ModuleInstance parent, ModuleInstance insSlot, String id) {
            this.allowed = new ArrayList<String>();
            this.id = id;
            this.parent = parent;
            this.inSlot = insSlot;
        }

        public boolean allowedIn(ModuleInstance instance) {
            List<String> allowedSlots = AllowedSlots.getAllowedSlots(instance.getModule());
            for (String key : this.allowed) {
                if (!allowedSlots.contains(key)) continue;
                return true;
            }
            return false;
        }

        public boolean allowedIn(ItemModule module) {
            List<String> allowedSlots = AllowedSlots.getAllowedSlots(module);
            for (String key : this.allowed) {
                if (!allowedSlots.contains(key)) continue;
                return true;
            }
            return false;
        }

        public void initialize(ModuleInstance moduleInstance) {
            this.inSlot = moduleInstance.getSubModule(this.id);
            this.parent = moduleInstance;
        }

        @OnlyIn(value=Dist.CLIENT)
        public TransformMap getTransformStack() {
            TransformMap stack = new TransformMap();
            stack.add(this.transform);
            return stack;
        }

        public List<String> getAsLocation() {
            ArrayList<String> location = new ArrayList<String>();
            ModuleInstance parsing = this.parent;
            if (parsing != null) {
                location.add(this.id);
                while (parsing.getParent() != null) {
                    String slotNumber = SlotProperty.getSlotID(parsing);
                    location.add(slotNumber);
                    parsing = parsing.getParent();
                }
            }
            return location;
        }

        public ModuleSlot copy(boolean copyModules) {
            ModuleSlot copied = new ModuleSlot();
            if (copyModules) {
                copied.inSlot = this.inSlot;
                copied.parent = this.parent;
            }
            copied.allowed = new ArrayList<String>(this.allowed);
            copied.id = this.id;
            copied.allowedMerge = new ArrayList<String>(this.allowedMerge);
            copied.priority = this.priority;
            copied.slotType = this.slotType;
            copied.transform = this.transform.copy();
            copied.translationKey = this.translationKey;
            return copied;
        }

        public boolean equals(Object object) {
            if (object instanceof ModuleSlot) {
                ModuleSlot slot = (ModuleSlot)object;
                if (this.parent == null && slot.parent != null) {
                    return false;
                }
                if (this.parent != null && !this.parent.equals(slot.parent)) {
                    ModuleSlot thisParent = SlotProperty.getSlotIn(this.parent);
                    ModuleSlot otherParent = SlotProperty.getSlotIn(slot.parent);
                    if (thisParent != null && otherParent == null || thisParent == null && otherParent != null) {
                        return false;
                    }
                    if (thisParent != null && otherParent != null && !thisParent.equals(otherParent)) {
                        return false;
                    }
                    return false;
                }
                if (this.inSlot == null && slot.inSlot != null) {
                    return false;
                }
                if (this.inSlot != null && !this.inSlot.equals(slot.inSlot)) {
                    return false;
                }
                if (this.allowed == null && slot.allowed != null) {
                    return false;
                }
                if (!Objects.equals(this.id, slot.id)) {
                    return false;
                }
                if (this.allowed != null) {
                    ArrayList<String> sortedAllowed = new ArrayList<String>(this.allowed);
                    Collections.sort(sortedAllowed);
                    ArrayList<String> sortedOtherAllowed = new ArrayList<String>(slot.allowed);
                    Collections.sort(sortedOtherAllowed);
                    return sortedAllowed.equals(sortedOtherAllowed);
                }
                return true;
            }
            return false;
        }
    }
}

