/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.modules.synergies;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import smartin.miapi.Miapi;
import smartin.miapi.material.MaterialProperty;
import smartin.miapi.modules.PropertyHolder;
import smartin.miapi.modules.conditions.ConditionManager;
import smartin.miapi.modules.properties.util.EditorError;
import smartin.miapi.modules.properties.util.Validator;
import smartin.miapi.modules.synergies.SynergyManager;

public class MaterialSynergy
extends SynergyManager.Synergy
implements Validator<MaterialSynergy> {
    public static final ResourceLocation TYPE = Miapi.id("material");
    private final ResourceLocation materialId;
    public static final MapCodec<MaterialSynergy> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Miapi.ID_CODEC.fieldOf("material").forGetter(synergy -> synergy.materialId), (App)ConditionManager.CONDITION_CODEC_DIRECT.fieldOf("condition").forGetter(synergy -> synergy.condition), (App)PropertyHolder.MAP_CODEC.fieldOf("properties").forGetter(synergy -> synergy.holder)).apply((Applicative)instance, (materialId, condition, holder) -> {
        MaterialSynergy synergy = new MaterialSynergy((ResourceLocation)materialId);
        synergy.condition = condition;
        synergy.holder = holder;
        return synergy;
    }));

    public MaterialSynergy(ResourceLocation materialId) {
        this.materialId = materialId;
        this.id = materialId;
    }

    @Override
    protected ResourceLocation getType() {
        return TYPE;
    }

    @Override
    public void register() {
        SynergyManager.materialSynergies.computeIfAbsent(this.materialId, k -> new ArrayList()).add(this);
    }

    @Override
    public List<EditorError> validate(int line, MaterialSynergy property, boolean isClient) {
        if (!MaterialProperty.MATERIAL_REGISTRY.containsKey(this.materialId)) {
            return List.of(new EditorError(line, "Material " + String.valueOf(this.materialId) + "was not found ! " + String.valueOf(this.id), EditorError.ErrorSeverity.WARNING));
        }
        return List.of();
    }
}

