/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.network;

import dev.architectury.networking.NetworkManager;
import io.netty.buffer.Unpooled;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import smartin.miapi.Environment;
import smartin.miapi.Miapi;
import smartin.miapi.network.NetworkingImpl;
import smartin.miapi.network.modern.ModernNetworking;
import smartin.miapi.network.modern.payload.CustomPayload;
import smartin.miapi.network.payload.C2SMiapiOLDPayload;
import smartin.miapi.network.payload.S2CMiapiOLDPayload;

public class NetworkingImplCommon
extends NetworkingImpl {
    protected NetworkingImplCommon instance = this;

    public NetworkingImplCommon() {
        try {
            if (Environment.isClient()) {
                NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.S2C, S2CMiapiOLDPayload.TYPE, S2CMiapiOLDPayload.STREAM_CODEC, (packet, context) -> {});
            } else {
                NetworkManager.registerS2CPayloadType(S2CMiapiOLDPayload.TYPE, S2CMiapiOLDPayload.STREAM_CODEC);
            }
            NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.C2S, C2SMiapiOLDPayload.PACKET_TYPE, C2SMiapiOLDPayload.STREAM_CODEC, (packet, context) -> {});
        }
        catch (RuntimeException e) {
            Miapi.LOGGER.error("could not setup networking", (Throwable)e);
        }
        ModernNetworking.setup();
    }

    public void setupServer() {
    }

    @Override
    public void sendPacketToServer(String identifier, FriendlyByteBuf buffer) {
        UUID player = Minecraft.getInstance().player.getUUID();
        NetworkManager.sendToServer((CustomPacketPayload)new C2SMiapiOLDPayload(new CustomPayload(identifier, player, buffer.array())));
    }

    @Override
    public void sendPacketToClient(String identifier, ServerPlayer player, FriendlyByteBuf buffer) {
        NetworkManager.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new S2CMiapiOLDPayload(new CustomPayload(identifier, player.getUUID(), buffer.array())));
    }

    @Override
    public FriendlyByteBuf createBuffer() {
        return new FriendlyByteBuf(Unpooled.buffer());
    }
}

