/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.network.modern;

import dev.architectury.networking.NetworkManager;
import io.netty.buffer.ByteBuf;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import org.apache.commons.lang3.function.TriConsumer;
import smartin.miapi.Environment;
import smartin.miapi.Miapi;
import smartin.miapi.network.Networking;
import smartin.miapi.network.modern.payload.C2SMiapiPayload;
import smartin.miapi.network.modern.payload.CustomPayload;
import smartin.miapi.network.modern.payload.S2CMiapiPayload;

public class ModernNetworking {
    public static final Map<ResourceLocation, Receiver<?>> s2cReceivers = new HashMap();
    public static final Map<ResourceLocation, Receiver<?>> c2sReceivers = new HashMap();

    public static void setup() {
        try {
            if (Environment.isClient()) {
                NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.S2C, S2CMiapiPayload.TYPE, S2CMiapiPayload.STREAM_CODEC, (packet, context) -> s2cReceivers.computeIfPresent(packet.payload().parseId(), (location, receiver) -> {
                    RegistryFriendlyByteBuf buf = new RegistryFriendlyByteBuf((ByteBuf)Networking.createBuffer(), context.registryAccess());
                    buf.writeBytes(packet.payload().data());
                    receiver.receive(buf, context.getPlayer());
                    return receiver;
                }));
            } else {
                NetworkManager.registerS2CPayloadType(S2CMiapiPayload.TYPE, S2CMiapiPayload.STREAM_CODEC);
            }
            NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.C2S, C2SMiapiPayload.PACKET_TYPE, C2SMiapiPayload.STREAM_CODEC, (packet, context) -> c2sReceivers.computeIfPresent(packet.payload().parseId(), (location, receiver) -> {
                RegistryFriendlyByteBuf buf = new RegistryFriendlyByteBuf((ByteBuf)Networking.createBuffer(), context.registryAccess());
                buf.writeBytes(packet.payload().data());
                receiver.receive(buf, context.getPlayer());
                return receiver;
            }));
        }
        catch (RuntimeException e) {
            Miapi.LOGGER.error("could not setup networking", (Throwable)e);
        }
    }

    public static <T> void registerS2CReceiver(ResourceLocation location, StreamCodec<RegistryFriendlyByteBuf, T> codec, TriConsumer<T, Player, RegistryAccess> onReceive) {
        s2cReceivers.put(location, new Receiver<T>(codec, onReceive));
    }

    public static <T> void registerC2SReceiver(ResourceLocation location, StreamCodec<RegistryFriendlyByteBuf, T> codec, TriConsumer<T, Player, RegistryAccess> onReceive) {
        c2sReceivers.put(location, new Receiver<T>(codec, onReceive));
    }

    public static void deregisterS2CReceiver(ResourceLocation location) {
        s2cReceivers.remove(location);
    }

    public static void deregisterC2SReceiver(ResourceLocation location) {
        c2sReceivers.remove(location);
    }

    public static <T> void sendToServer(ResourceLocation location, StreamCodec<RegistryFriendlyByteBuf, T> codec, T data, RegistryAccess access) {
        if (Environment.isClient() && Minecraft.getInstance().getConnection() == null) {
            return;
        }
        RegistryFriendlyByteBuf buf = new RegistryFriendlyByteBuf((ByteBuf)Networking.createBuffer(), access);
        codec.encode((Object)buf, data);
        CustomPayload data1 = new CustomPayload(location.toString(), C2SMiapiPayload.getClientUUID(), buf.array());
        NetworkManager.sendToServer((CustomPacketPayload)new C2SMiapiPayload(data1));
    }

    public static <T> void sendToPlayer(ResourceLocation location, Player player, StreamCodec<RegistryFriendlyByteBuf, T> codec, T data) {
        if (player instanceof ServerPlayer) {
            ServerPlayer player1 = (ServerPlayer)player;
            if (player1.connection == null) {
                return;
            }
        }
        RegistryFriendlyByteBuf buf = new RegistryFriendlyByteBuf((ByteBuf)Networking.createBuffer(), player.registryAccess());
        codec.encode((Object)buf, data);
        CustomPayload data1 = new CustomPayload(location.toString(), player.getUUID(), buf.array());
        S2CMiapiPayload miapiOLDPayload = new S2CMiapiPayload(data1);
        NetworkManager.sendToPlayer((ServerPlayer)((ServerPlayer)player), (CustomPacketPayload)miapiOLDPayload);
    }

    public record Receiver<T>(StreamCodec<RegistryFriendlyByteBuf, T> codec, TriConsumer<T, Player, RegistryAccess> onReceive) {
        public void receive(RegistryFriendlyByteBuf raw, Player player) {
            this.onReceive().accept(this.codec().decode((Object)raw), (Object)player, (Object)raw.registryAccess());
        }
    }
}

