/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.network.modern.payload;

import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import smartin.miapi.Miapi;
import smartin.miapi.network.Networking;
import smartin.miapi.network.modern.payload.CustomPayload;

public record C2SMiapiPayload(CustomPayload payload) implements CustomPacketPayload
{
    public static UUID noPlayerUUID = UUID.fromString("ddfe3f2c-2d4e-4242-8a65-f4641ba9f5f6");
    public static final StreamCodec<FriendlyByteBuf, C2SMiapiPayload> STREAM_CODEC = CustomPacketPayload.codec(C2SMiapiPayload::encode, C2SMiapiPayload::decode);
    public static final CustomPacketPayload.Type<C2SMiapiPayload> PACKET_TYPE = new CustomPacketPayload.Type(Miapi.id("default-c2s-networking"));

    @NotNull
    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return PACKET_TYPE;
    }

    public static C2SMiapiPayload decode(FriendlyByteBuf friendlyByteBuf) {
        CustomPayload payload = CustomPayload.decode(friendlyByteBuf);
        FriendlyByteBuf buf = Networking.createBuffer();
        buf.writeBytes(payload.data());
        return new C2SMiapiPayload(payload);
    }

    @Nullable
    public static ServerPlayer getPlayer(@NotNull UUID uuid) {
        if (Miapi.server != null) {
            return Miapi.server.getPlayerList().getPlayer(uuid);
        }
        return null;
    }

    public void encode(FriendlyByteBuf data) {
        this.payload().encode(data);
    }

    public static UUID getClientUUID() {
        UUID uuid = noPlayerUUID;
        if (Minecraft.getInstance() != null && Minecraft.getInstance().player != null) {
            uuid = Minecraft.getInstance().player.getUUID();
        }
        return uuid;
    }
}

