/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.registries;

import dev.architectury.registry.registries.Registrar;
import dev.architectury.registry.registries.RegistrySupplier;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import smartin.miapi.registries.MiapiRegistry;

public class MiapiRegistrar<T>
extends MiapiRegistry<T>
implements Registrar<T> {
    public final Registrar<T> registrar;

    protected MiapiRegistrar(Registrar<T> registrar) {
        this.registrar = registrar;
    }

    public static <T> MiapiRegistrar<T> of(Registrar<T> r) {
        return new MiapiRegistrar<T>(r);
    }

    public RegistrySupplier<T> delegate(ResourceLocation id) {
        return this.registrar.delegate(id);
    }

    @Override
    public <E extends T> RegistrySupplier<E> register(ResourceLocation id, Supplier<E> supplier) {
        RegistrySupplier sup = this.registrar.register(id, supplier);
        sup.listen(e -> this.register(id, e));
        return sup;
    }

    public <E extends T> void registerWithoutRegistrar(ResourceLocation id, E object) {
        this.register(id, object);
    }

    @Nullable
    public ResourceLocation getId(T obj) {
        return this.registrar.getId(obj);
    }

    public int getRawId(T obj) {
        return this.registrar.getRawId(obj);
    }

    public Optional<ResourceKey<T>> getKey(T obj) {
        return Optional.empty();
    }

    @Override
    @Nullable
    public T get(ResourceLocation id) {
        return super.get(id);
    }

    @Nullable
    public T byRawId(int rawId) {
        return (T)this.registrar.byRawId(rawId);
    }

    public boolean contains(ResourceLocation id) {
        return this.entries.containsKey(id);
    }

    public boolean containsValue(T obj) {
        return this.entries.containsValue(obj);
    }

    public Set<ResourceLocation> getIds() {
        return new HashSet<ResourceLocation>(this.entries.keySet());
    }

    public Set<Map.Entry<ResourceKey<T>, T>> entrySet() {
        return this.registrar.entrySet();
    }

    public ResourceKey<? extends Registry<T>> key() {
        return this.registrar.key();
    }

    @Nullable
    public Holder<T> getHolder(ResourceKey<T> key) {
        return this.registrar.getHolder(key);
    }

    public void listen(ResourceLocation id, Consumer<T> callback) {
        this.registrar.listen(id, callback);
    }

    @NotNull
    public Iterator<T> iterator() {
        return this.registrar.iterator();
    }
}

