/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.registries;

import dev.architectury.event.events.client.ClientLifecycleEvent;
import dev.architectury.event.events.common.LifecycleEvent;
import dev.architectury.platform.Platform;
import java.util.Map;
import java.util.Optional;
import java.util.WeakHashMap;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.RegistryOps;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import smartin.miapi.Miapi;

public class RegistryHelper {
    public static final Map<Level, RegistryAccess> registryLookup = new WeakHashMap<Level, RegistryAccess>();

    public static void setup() {
        LifecycleEvent.SERVER_LEVEL_LOAD.register(world -> registryLookup.put(world, world.registryAccess()));
        if (Platform.getEnv() == Dist.CLIENT) {
            RegistryHelper.setupClient();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void setupClient() {
        ClientLifecycleEvent.CLIENT_LEVEL_LOAD.register(world -> registryLookup.put(world, world.registryAccess()));
    }

    public static RegistryAccess tryFind(RegistryOps.RegistryInfoLookup lookup) {
        return registryLookup.values().stream().filter(a -> {
            Optional enchantmentInfoA = a.lookup(Registries.ENCHANTMENT);
            Optional enchantmentInfoLookup = lookup.lookup(Registries.ENCHANTMENT);
            return enchantmentInfoA.isPresent() && enchantmentInfoLookup.map(info -> ((HolderLookup.RegistryLookup)enchantmentInfoA.get()).canSerializeIn(info.owner())).orElse(false) != false;
        }).findFirst().orElse(Miapi.registryAccess);
    }
}

