/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.upgrade;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import smartin.miapi.client.gui.InteractAbleWidget;
import smartin.miapi.client.gui.ScrollList;
import smartin.miapi.client.gui.SimpleButton;
import smartin.miapi.modules.ItemModule;
import smartin.miapi.modules.ModuleInstance;
import smartin.miapi.modules.conditions.ConditionManager;
import smartin.miapi.modules.edit_options.EditOption;
import smartin.miapi.modules.properties.tag.ModuleTagProperty;
import smartin.miapi.upgrade.Upgrade;
import smartin.miapi.upgrade.UpgradeEditOption;
import smartin.miapi.upgrade.UpgradeSelection;

@OnlyIn(value=Dist.CLIENT)
public class UpgradeEditView
extends InteractAbleWidget {
    private final ScrollList scrollList;
    private final List<InteractAbleWidget> upgradeButtons = new ArrayList<InteractAbleWidget>();
    private final EditOption.EditContext context;
    private final Consumer<UpgradeSelection> onChange;
    private final Consumer<UpgradeSelection> onCraft;
    private UpgradeSelection lastSelected = null;
    private int availableXP = 0;
    private int usedLevels = 0;
    int maxToNextLevel = 0;
    private int availablePoints = 0;
    int currentLVLXp = 0;

    public UpgradeEditView(int x, int y, int width, int height, EditOption.EditContext context, Consumer<UpgradeSelection> onChange, Consumer<UpgradeSelection> onCraft) {
        super(x, y, width, height, (Component)Component.empty());
        int xpToNextPoint;
        this.context = context;
        this.onChange = onChange;
        this.onCraft = onCraft;
        this.scrollList = new ScrollList(x, y, width, height - 24, this.upgradeButtons);
        this.addChild(this.scrollList);
        this.availableXP = this.getItemXP(context.getItemstack());
        this.usedLevels = UpgradeEditOption.getTotalUpgradeLevel(context.getItemstack());
        int xp = this.availableXP;
        int simulatedLevel = this.usedLevels;
        int upgradePoints = 0;
        int upgradeCost = Upgrade.xpCost(simulatedLevel);
        while (xp >= upgradeCost && xp > 0) {
            xp -= upgradeCost;
            ++upgradePoints;
            upgradeCost = Upgrade.xpCost(++simulatedLevel);
        }
        final int points = upgradePoints;
        this.maxToNextLevel = xpToNextPoint = Upgrade.xpCost(simulatedLevel) - xp;
        this.availablePoints = points;
        this.currentLVLXp = xp;
        this.addChild(new InteractAbleWidget(this, x + 4, y + height - 13, 100, 12, (Component)Component.literal((String)"")){

            @Override
            public void renderWidget(GuiGraphics drawContext, int mouseX, int mouseY, float delta) {
                drawContext.drawString(Minecraft.getInstance().font, "Points: " + points, this.getX(), this.getY(), 0xFFFFFF, false);
            }
        });
        final int simulatedFinal = simulatedLevel;
        this.addChild(new InteractAbleWidget(this, x + width - 84, y + height - 15, 30, 12, (Component)Component.literal((String)"")){

            @Override
            public void renderWidget(GuiGraphics drawContext, int mouseX, int mouseY, float delta) {
                int costForNext = Upgrade.xpCost(simulatedFinal);
                int progress = (int)((double)(costForNext - xpToNextPoint) / (double)costForNext * 100.0);
                int barWidth = (int)((double)progress / 100.0 * 30.0);
                drawContext.fill(this.getX(), this.getY(), this.getX() + 30, this.getY() + 10, -11184811);
                drawContext.fill(this.getX(), this.getY(), this.getX() + barWidth, this.getY() + 10, -16711936);
                drawContext.drawString(Minecraft.getInstance().font, progress + "%", this.getX() + 5, this.getY() + 2, -1, false);
            }
        });
        this.populateUpgrades(upgradePoints);
        SimpleButton<Void> applyButton = new SimpleButton<Void>(x + width - 45, y + height - 18, 40, 16, (Component)Component.translatable((String)"miapi.ui.apply"), null, callback -> {
            if (this.lastSelected != null) {
                this.onCraft.accept(this.lastSelected);
            }
        });
        this.addChild(applyButton);
    }

    private void populateUpgrades(final int points) {
        this.upgradeButtons.clear();
        ItemStack itemStack = this.context.getItemstack();
        List<ModuleInstance> modules = ItemModule.getModules(itemStack).allSubModules();
        for (ModuleInstance instance : modules) {
            Object decodeResult;
            ArrayList<3> buttonsForModule = new ArrayList<3>();
            ConditionManager.ConditionContext ctx = ConditionManager.playerContext(instance, this.context.getPlayer(), instance.properties);
            Map upgradeMap = Map.of();
            ArrayList<Upgrade> existingUpgrades = new ArrayList<Upgrade>();
            if (instance.moduleData.containsKey(Upgrade.upgradeId) && ((Optional)(decodeResult = Upgrade.MODULE_UPGRADE_ID_CODEC.decode((DynamicOps)JsonOps.INSTANCE, (Object)instance.moduleData.get(Upgrade.upgradeId)).result())).isPresent()) {
                upgradeMap = (Map)((Pair)((Optional)decodeResult).get()).getFirst();
                for (ResourceLocation existingId : upgradeMap.keySet()) {
                    Upgrade existingUpgrade = Upgrade.UPGRADE_MIAPI_REGISTRY.get(existingId);
                    if (existingUpgrade == null) continue;
                    existingUpgrades.add(existingUpgrade);
                }
            }
            decodeResult = Upgrade.UPGRADE_MIAPI_REGISTRY.getFlatMap().entrySet().iterator();
            while (decodeResult.hasNext()) {
                Map.Entry<ResourceLocation, Upgrade> entry = decodeResult.next();
                ResourceLocation upgradeId = entry.getKey();
                final Upgrade upgrade = entry.getValue();
                int currentLevel = upgradeMap.getOrDefault(upgradeId, 0);
                if (!upgrade.condition().isAllowed(ctx) || currentLevel >= upgrade.max() || !upgrade.isAllowed(existingUpgrades) || !ModuleTagProperty.getTags(instance).contains(upgrade.moduleTag())) continue;
                UpgradeSelection selection = new UpgradeSelection(instance, upgradeId);
                SimpleButton<UpgradeSelection> button = new SimpleButton<UpgradeSelection>(this.getX() + 10, 0, this.getWidth() - 16, 16, (Component)upgrade.name().copy().append(" ").append((Component)Component.translatable((String)"miapi.upgrade.cost", (Object[])new Object[]{upgrade.cost()})), selection, sel -> {
                    this.lastSelected = sel;
                    this.onChange.accept((UpgradeSelection)sel);
                }){

                    @Override
                    public void renderHover(GuiGraphics drawContext, int mouseX, int mouseY, float delta) {
                        super.renderHover(drawContext, mouseX, mouseY, delta);
                        if (this.isMouseOver(mouseX, mouseY) && UpgradeEditView.this.scrollList.isMouseOver(mouseX, mouseY)) {
                            drawContext.renderTooltip(Minecraft.getInstance().font, points >= upgrade.cost() ? List.of(upgrade.description()) : List.of(Component.translatable((String)"miapi.upgrade.cannot.afford"), upgrade.description()), Optional.empty(), mouseX, mouseY);
                        }
                    }
                };
                button.isEnabled = points >= upgrade.cost();
                buttonsForModule.add(button);
            }
            if (buttonsForModule.isEmpty()) continue;
            InteractAbleWidget moduleLabel = new InteractAbleWidget(this, this.getX() + 2, 0, this.getWidth() - 4, 16, (Component)Component.literal((String)instance.getModuleName().getString()).withStyle(style -> style.withBold(Boolean.valueOf(true)))){

                @Override
                public void renderWidget(GuiGraphics drawContext, int mouseX, int mouseY, float delta) {
                    drawContext.drawString(Minecraft.getInstance().font, this.getMessage(), this.getX() + 2, this.getY() + 4, 0xFFFFFF, false);
                }
            };
            this.upgradeButtons.add(moduleLabel);
            this.upgradeButtons.addAll(buttonsForModule);
        }
        this.scrollList.setList(this.upgradeButtons);
    }

    private int getItemXP(ItemStack stack) {
        return (Integer)stack.getOrDefault(Upgrade.COMPONENT, (Object)0);
    }

    @Override
    public void renderWidget(GuiGraphics drawContext, int mouseX, int mouseY, float delta) {
        super.renderWidget(drawContext, mouseX, mouseY, delta);
    }

    @Override
    public void renderHover(GuiGraphics drawContext, int mouseX, int mouseY, float delta) {
        super.renderHover(drawContext, mouseX, mouseY, delta);
        if (this.isMouseOver(mouseX, mouseY) && !this.scrollList.isMouseOver(mouseX, mouseY) && this.getX() + this.getHeight() - 20 > mouseX && this.getY() + this.getWidth() - 35 > mouseY) {
            drawContext.renderTooltip(Minecraft.getInstance().font, List.of(Component.translatable((String)"miapi.upgrade.hover.1", (Object[])new Object[]{this.currentLVLXp, this.currentLVLXp + this.maxToNextLevel}), Component.translatable((String)"miapi.upgrade.hover.2", (Object[])new Object[]{this.availablePoints}), Component.translatable((String)"miapi.upgrade.hover.3", (Object[])new Object[]{this.usedLevels}), Component.translatable((String)"miapi.upgrade.hover.4", (Object[])new Object[]{this.usedLevels}), Component.translatable((String)"miapi.upgrade.hover.5", (Object[])new Object[]{this.usedLevels})), Optional.empty(), mouseX, mouseY);
        }
    }
}

