/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.attributes;

import com.redpxnda.nucleus.facet.Facet;
import com.redpxnda.nucleus.facet.FacetRegistry;
import dev.architectury.event.EventResult;
import dev.architectury.event.events.common.PlayerEvent;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.WeakHashMap;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2596;
import net.minecraft.class_2616;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_6880;
import net.minecraft.class_8103;
import smartin.miapi.Miapi;
import smartin.miapi.entity.ItemProjectileEntity;
import smartin.miapi.entity.ShieldingArmorFacet;
import smartin.miapi.entity.StunHealthFacet;
import smartin.miapi.events.MiapiEvents;
import smartin.miapi.events.MiapiProjectileEvents;
import smartin.miapi.events.ModularAttackEvents;
import smartin.miapi.mixin.LivingEntityAccessor;
import smartin.miapi.modules.abilities.key.KeyBindFacet;
import smartin.miapi.modules.properties.attributes.AttributeUtil;

public class AttributeRegistry {
    public static Map<class_2960, class_6880<class_1320>> entityAttributeMap = new HashMap<class_2960, class_6880<class_1320>>();
    public static Map<class_1657, Boolean> hasCrittedLast = new WeakHashMap<class_1657, Boolean>();
    public static class_6880<class_1320> SWIM_SPEED;
    public static class_6880<class_1320> MINING_SPEED_PICKAXE;
    public static class_6880<class_1320> MINING_SPEED_AXE;
    public static class_6880<class_1320> MINING_SPEED_SHOVEL;
    public static class_6880<class_1320> MINING_SPEED_HOE;
    public static class_6880<class_1320> MAGIC_DAMAGE;
    public static class_6880<class_1320> STUN_DAMAGE;
    public static class_6880<class_1320> STUN_MAX_HEALTH;
    public static class_6880<class_1320> CRITICAL_DAMAGE;
    public static class_6880<class_1320> CRITICAL_CHANCE;
    public static class_6880<class_1320> DAMAGE_RESISTANCE;
    public static class_6880<class_1320> BACK_STAB;
    public static class_6880<class_1320> ARMOR_CRUSHING;
    public static class_6880<class_1320> SHIELD_BREAK;
    public static class_6880<class_1320> PROJECTILE_ARMOR;
    public static class_6880<class_1320> PLAYER_ITEM_USE_MOVEMENT_SPEED;
    public static class_6880<class_1320> PROJECTILE_DAMAGE;
    public static class_6880<class_1320> PROJECTILE_SPEED;
    public static class_6880<class_1320> PROJECTILE_ACCURACY;
    public static class_6880<class_1320> PROJECTILE_PIERCING;
    public static class_6880<class_1320> ELYTRA_TURN_EFFICIENCY;
    public static class_6880<class_1320> ELYTRA_GLIDE_EFFICIENCY;
    public static class_6880<class_1320> ELYTRA_ROCKET_EFFICIENCY;
    public static class_6880<class_1320> SHIELDING_ARMOR;
    private static final class_2960 TEMP_CRIT_DMG_UUID;
    private static final class_2960 TEMP_CRIT_DMG_MULTIPLIER_UUID;
    private static final class_2960 TEMP_BACKSTAB_DMG_UUID;

    public static void setup() {
        FacetRegistry.ENTITY_FACET_ATTACHMENT.register((entity, attacher) -> {
            if (entity instanceof class_1309) {
                class_1309 livingEntity = (class_1309)entity;
                ShieldingArmorFacet facet = new ShieldingArmorFacet(livingEntity);
                attacher.add(ShieldingArmorFacet.KEY, (Facet)facet);
                StunHealthFacet stunHealthFacet = new StunHealthFacet(livingEntity);
                attacher.add(StunHealthFacet.KEY, (Facet)stunHealthFacet);
                KeyBindFacet keyBindFacet = new KeyBindFacet((class_1297)livingEntity);
                attacher.add(KeyBindFacet.KEY, (Facet)keyBindFacet);
            }
        });
        MiapiEvents.LIVING_HURT_AFTER_ARMOR.register(livingHurt -> {
            class_1297 patt0$temp;
            StunHealthFacet facet = (StunHealthFacet)StunHealthFacet.KEY.get((class_1297)livingHurt.defender);
            if (livingHurt.damageSource != null && livingHurt.damageSource.method_5529() != null && (patt0$temp = livingHurt.damageSource.method_5529()) instanceof class_1309) {
                double currentStunDamage;
                class_1309 attacker = (class_1309)patt0$temp;
                if (facet != null && !livingHurt.defender.method_37908().method_8608() && attacker.method_6127().method_45331(STUN_DAMAGE) && (currentStunDamage = attacker.method_45325(STUN_DAMAGE)) > 0.1) {
                    facet.takeStunDamage((float)currentStunDamage, attacker);
                }
            }
            return EventResult.pass();
        });
        MiapiEvents.LIVING_HURT_AFTER_ARMOR.register(livingHurt -> {
            ShieldingArmorFacet facet = (ShieldingArmorFacet)ShieldingArmorFacet.KEY.get((class_1297)livingHurt.defender);
            if (facet != null && !livingHurt.defender.method_37908().method_8608() && livingHurt.damageSource != null && !livingHurt.damageSource.method_48789(class_8103.field_42241)) {
                livingHurt.amount = facet.takeDamage(livingHurt.amount);
                class_1309 patt0$temp = livingHurt.defender;
                if (patt0$temp instanceof class_3222) {
                    class_3222 player = (class_3222)patt0$temp;
                    facet.sendToClient(player);
                }
            }
            return EventResult.pass();
        });
        MiapiEvents.LIVING_ENTITY_TICK_END.register(entity -> {
            ShieldingArmorFacet facet = (ShieldingArmorFacet)ShieldingArmorFacet.KEY.get((class_1297)entity);
            if (facet != null && !entity.method_37908().method_8608()) {
                try {
                    facet.tick();
                }
                catch (RuntimeException e) {
                    Miapi.LOGGER.warn("facet error", (Throwable)e);
                }
            }
            return EventResult.pass();
        });
        PlayerEvent.PLAYER_JOIN.register(player -> ShieldingArmorFacet.KEY.get((class_1297)player));
        MiapiEvents.LIVING_HURT.register(livingHurtEvent -> {
            if (livingHurtEvent.defender.method_6127().method_45331(DAMAGE_RESISTANCE)) {
                livingHurtEvent.amount = Math.max(0.0f, (float)((double)livingHurtEvent.amount * (100.0 - livingHurtEvent.defender.method_45325(DAMAGE_RESISTANCE)) / 100.0));
            }
            return EventResult.pass();
        });
        ModularAttackEvents.HURT_ENEMY.register((stack, defender, attacker) -> {
            double value;
            if (attacker != null && defender != null && attacker.method_6127().method_45331(MAGIC_DAMAGE) && (value = attacker.method_45325(MAGIC_DAMAGE)) > 0.0) {
                defender.method_5643(attacker.method_48923().method_48831(), (float)value);
            }
            return EventResult.pass();
        });
        MiapiEvents.LIVING_HURT.register(livingHurtEvent -> {
            class_1309 attacker;
            class_1297 patt0$temp;
            if (livingHurtEvent.damageSource != null && (patt0$temp = livingHurtEvent.damageSource.method_5529()) instanceof class_1309 && (attacker = (class_1309)patt0$temp).method_6127().method_45331(BACK_STAB) && attacker.method_6127().method_45329(BACK_STAB) != null && livingHurtEvent.damageSource.method_5529().method_5720().method_1026(livingHurtEvent.defender.method_5720()) > 0.0) {
                Objects.requireNonNull(attacker.method_6127().method_45329(BACK_STAB)).method_26835(new class_1322(TEMP_BACKSTAB_DMG_UUID, (double)livingHurtEvent.amount, class_1322.class_1323.field_6328));
                livingHurtEvent.amount = (float)attacker.method_45325(BACK_STAB);
                Objects.requireNonNull(attacker.method_6127().method_45329(BACK_STAB)).method_6200(TEMP_BACKSTAB_DMG_UUID);
            }
            return EventResult.pass();
        });
        MiapiEvents.LIVING_HURT.register(livingHurtEvent -> {
            double projectileArmor;
            if (livingHurtEvent.damageSource != null && livingHurtEvent.damageSource.method_48789(class_8103.field_42247) && livingHurtEvent.defender.method_6127().method_45331(PROJECTILE_ARMOR) && (projectileArmor = livingHurtEvent.defender.method_45325(PROJECTILE_ARMOR)) > 0.0) {
                double totalDamage = (double)livingHurtEvent.amount * (1.0 - Math.max(20.0, projectileArmor) / 25.0);
                livingHurtEvent.amount = (float)totalDamage;
            }
            return EventResult.pass();
        });
        MiapiEvents.LIVING_HURT_AFTER.register(livingHurtEvent -> {
            class_1309 attacker;
            class_1297 patt0$temp;
            if (livingHurtEvent.damageSource != null && (patt0$temp = livingHurtEvent.damageSource.method_5529()) instanceof class_1309 && (attacker = (class_1309)patt0$temp).method_6127().method_45331(SHIELD_BREAK)) {
                double value = attacker.method_45325(SHIELD_BREAK);
                class_1309 patt1$temp = livingHurtEvent.defender;
                if (patt1$temp instanceof class_1657) {
                    class_1657 player = (class_1657)patt1$temp;
                    if (value > 0.0 && player.method_6039()) {
                        player.method_7357().method_7906(class_1802.field_8255, (int)(value * 20.0));
                        player.method_6021();
                        player.method_37908().method_8421((class_1297)player, (byte)30);
                    }
                }
            }
            return EventResult.pass();
        });
        MiapiEvents.LIVING_HURT.register(livingHurtEvent -> {
            class_1309 attacker;
            class_1297 patt0$temp;
            if (livingHurtEvent.damageSource != null && (patt0$temp = livingHurtEvent.damageSource.method_5529()) instanceof class_1309 && (attacker = (class_1309)patt0$temp).method_6127().method_45331(ARMOR_CRUSHING)) {
                double value = attacker.method_45325(ARMOR_CRUSHING);
                ((LivingEntityAccessor)livingHurtEvent.defender).callDamageArmor(livingHurtEvent.damageSource, (float)((double)livingHurtEvent.defender.method_6096() * value));
            }
            return EventResult.pass();
        });
        MiapiProjectileEvents.MODULAR_PROJECTILE_ENTITY_HIT.register(listener -> {
            ItemProjectileEntity projectile = listener.projectile;
            if (projectile.method_7443()) {
                // empty if block
            }
            return EventResult.pass();
        });
        MiapiEvents.LIVING_HURT.register(livingHurtEvent -> {
            class_1297 patt0$temp;
            if (livingHurtEvent.damageSource != null && (patt0$temp = livingHurtEvent.damageSource.method_5529()) instanceof class_1309) {
                class_1309 attacker = (class_1309)patt0$temp;
                if (!livingHurtEvent.defender.method_37908().method_8608()) {
                    if (attacker.method_6127().method_45331(CRITICAL_CHANCE) && !livingHurtEvent.isCritical) {
                        Objects.requireNonNull(attacker.method_6127().method_45329(CRITICAL_CHANCE)).method_26835(new class_1322(TEMP_CRIT_DMG_UUID, 1.0, class_1322.class_1323.field_6328));
                        double value = attacker.method_45325(CRITICAL_CHANCE) - 1.0;
                        Objects.requireNonNull(attacker.method_6127().method_45329(CRITICAL_CHANCE)).method_6200(TEMP_CRIT_DMG_UUID);
                        if (attacker.method_37908().method_8409().method_43058() < value) {
                            livingHurtEvent.isCritical = true;
                            livingHurtEvent.amount *= 1.5f;
                            attacker.method_37908().method_43128(null, attacker.method_23317(), attacker.method_23318(), attacker.method_23321(), class_3417.field_15016, attacker.method_5634(), 1.0f, 1.0f);
                            if (attacker instanceof class_1657) {
                                class_1657 player = (class_1657)attacker;
                                player.method_7277((class_1297)livingHurtEvent.defender);
                            }
                            if (attacker.method_37908().method_8608()) {
                                class_310.method_1551().field_1713.method_3061((class_1297)livingHurtEvent.defender, (class_2394)class_2398.field_11205);
                            } else {
                                class_1937 patt1$temp = attacker.method_37908();
                                if (patt1$temp instanceof class_3218) {
                                    class_3218 serverWorld = (class_3218)patt1$temp;
                                    serverWorld.method_14178().method_18751((class_1297)attacker, (class_2596)new class_2616((class_1297)livingHurtEvent.defender, 4));
                                }
                            }
                        }
                    }
                    if (attacker.method_6127().method_45331(CRITICAL_DAMAGE) && livingHurtEvent.isCritical && attacker.method_6127().method_45329(CRITICAL_DAMAGE) != null) {
                        attacker.method_5996(CRITICAL_DAMAGE);
                        Objects.requireNonNull(attacker.method_6127().method_45329(CRITICAL_DAMAGE)).method_26835(new class_1322(TEMP_CRIT_DMG_UUID, (double)livingHurtEvent.amount / 1.5, class_1322.class_1323.field_6328));
                        Objects.requireNonNull(attacker.method_6127().method_45329(CRITICAL_DAMAGE)).method_26835(new class_1322(TEMP_CRIT_DMG_MULTIPLIER_UUID, 0.5, class_1322.class_1323.field_6330));
                        livingHurtEvent.amount = (float)attacker.method_45325(CRITICAL_DAMAGE);
                        Objects.requireNonNull(attacker.method_6127().method_45329(CRITICAL_DAMAGE)).method_6200(TEMP_CRIT_DMG_UUID);
                        Objects.requireNonNull(attacker.method_6127().method_45329(CRITICAL_DAMAGE)).method_6200(TEMP_CRIT_DMG_MULTIPLIER_UUID);
                    }
                }
            }
            return EventResult.pass();
        }, -1.0f);
        MiapiProjectileEvents.MODULAR_PROJECTILE_ENTITY_HIT.register(event -> {
            double critModifier = AttributeUtil.getActualValue(event.projectile.thrownStack, class_1304.field_6173, (class_1320)CRITICAL_DAMAGE.comp_349(), 1.5);
            if (critModifier != 1.0 && event.projectile.method_7443()) {
                event.damage *= (float)(critModifier / 1.5);
            }
            return EventResult.pass();
        });
    }

    public static double getAttribute(class_1799 stack, class_1320 attribute, class_1304 slot, double defaultValue) {
        return AttributeUtil.getActualValue(stack, slot, attribute, defaultValue);
    }

    static {
        TEMP_CRIT_DMG_UUID = Miapi.id("temp_crit_dmg");
        TEMP_CRIT_DMG_MULTIPLIER_UUID = Miapi.id("temp_crit_dmg_multiplier");
        TEMP_BACKSTAB_DMG_UUID = Miapi.id("temp_backstab_dmg");
    }
}

