/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.blueprint;

import com.google.gson.JsonElement;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_8824;
import net.minecraft.class_9135;
import net.minecraft.class_9331;
import org.jetbrains.annotations.Nullable;
import smartin.miapi.Miapi;
import smartin.miapi.blueprint.BlueprintManager;
import smartin.miapi.blueprint.IngredientWithCount;
import smartin.miapi.client.gui.crafting.CraftingScreenHandler;
import smartin.miapi.client.gui.crafting.crafter.replace.CraftOption;
import smartin.miapi.material.AllowedMaterial;
import smartin.miapi.modules.ModuleInstance;
import smartin.miapi.modules.properties.slot.SlotProperty;

public class BlueprintComponent {
    public static Codec<BlueprintComponent> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ModuleInstance.CODEC.fieldOf("module").forGetter(blueprint -> blueprint.toMerge), (App)Codec.either(Miapi.FIXED_BOOL_CODEC, IngredientWithCount.INGREDIENT_WITH_COUNT).fieldOf("ingredient").forGetter(blueprint -> blueprint.ingredient), (App)class_8824.field_46597.optionalFieldOf("name").forGetter(blueprintComponent -> blueprintComponent.name)).apply((Applicative)instance, BlueprintComponent::new));
    public static class_2960 ID = Miapi.id("blueprint_slot_id");
    public static class_9331<BlueprintComponent> BLUEPRINT_COMPONENT = class_9331.method_57873().method_57881(CODEC).method_57882(class_9135.method_56368(CODEC)).method_57880();
    public ModuleInstance toMerge;
    public Either<Boolean, IngredientWithCount> ingredient;
    public Optional<class_2561> name;

    public BlueprintComponent(ModuleInstance moduleInstance, Either<Boolean, IngredientWithCount> ingredient, Optional<class_2561> name) {
        this.toMerge = moduleInstance;
        this.ingredient = ingredient;
        this.name = name;
        moduleInstance.getProperty(SlotProperty.getInstance());
    }

    public boolean useMaterialCrafting() {
        if (this.ingredient.left().isPresent()) {
            return (Boolean)this.ingredient.left().get() == false;
        }
        return false;
    }

    public int getCost() {
        if (this.ingredient.left().isPresent() && ((Boolean)this.ingredient.left().get()).booleanValue()) {
            return 1;
        }
        if (this.ingredient.right().isPresent()) {
            IngredientWithCount countIngredient = (IngredientWithCount)this.ingredient.right().get();
            return (int)countIngredient.count;
        }
        return 0;
    }

    public boolean isValid(class_1799 itemStack, class_1799 blueprintItem) {
        if (this.ingredient.left().isPresent() && ((Boolean)this.ingredient.left().get()).booleanValue()) {
            return class_1799.method_31577((class_1799)itemStack, (class_1799)blueprintItem);
        }
        if (this.ingredient.right().isPresent()) {
            IngredientWithCount countIngredient = (IngredientWithCount)this.ingredient.right().get();
            return countIngredient.ingredient.method_8093(itemStack) && countIngredient.count <= (double)itemStack.method_7947();
        }
        return false;
    }

    public boolean isValidCorrectType(class_1799 itemStack, class_1799 blueprintItem) {
        if (this.ingredient.left().isPresent() && ((Boolean)this.ingredient.left().get()).booleanValue()) {
            return class_1799.method_31577((class_1799)itemStack, (class_1799)blueprintItem);
        }
        if (this.ingredient.right().isPresent()) {
            IngredientWithCount countIngredient = (IngredientWithCount)this.ingredient.right().get();
            return countIngredient.ingredient.method_8093(itemStack);
        }
        return false;
    }

    public class_1799 retrieve(CraftingScreenHandler screenHandler) {
        Optional<class_1735> optional = screenHandler.field_7761.stream().filter(a -> a.method_7677().method_57826(BLUEPRINT_COMPONENT)).filter(a -> this.equals(a.method_7677().method_57824(BLUEPRINT_COMPONENT))).findAny();
        return optional.map(class_1735::method_7677).orElse(class_1799.field_8037);
    }

    public void apply(ModuleInstance old) {
        old.module = this.toMerge.module;
        old.moduleID = this.toMerge.moduleID;
        old.moduleData = new HashMap<class_2960, JsonElement>(this.toMerge.moduleData);
        this.toMerge.getSubModuleMap().forEach(old::setSubModule);
    }

    public class_1799 adjustCost(class_1799 itemStack) {
        if (this.ingredient.left().isPresent()) {
            if (((Boolean)this.ingredient.left().get()).booleanValue()) {
                int size = itemStack.method_7947() - 1;
                class_1799 adjustedStack = itemStack.method_7972();
                adjustedStack.method_7939(size);
                return adjustedStack;
            }
        } else {
            IngredientWithCount countIngredient = (IngredientWithCount)this.ingredient.right().get();
            if (countIngredient.ingredient.method_8093(itemStack) && countIngredient.count <= (double)itemStack.method_7947()) {
                int size = itemStack.method_7947() - (int)countIngredient.count;
                class_1799 adjustedStack = itemStack.method_7972();
                adjustedStack.method_7939(size);
                return adjustedStack;
            }
        }
        return class_1799.field_8037;
    }

    @Nullable
    public static BlueprintComponent getBlueprint(Map<class_2960, JsonElement> dataMap, CraftingScreenHandler screenHandler) {
        JsonElement json = dataMap.get(ID);
        if (json != null) {
            DataResult decodeResult = Codec.INT.decode((DynamicOps)JsonOps.INSTANCE, (Object)json);
            int id = -1;
            id = decodeResult.isError() ? Integer.decode((String)((Pair)Codec.STRING.decode((DynamicOps)JsonOps.INSTANCE, (Object)json).getOrThrow()).getFirst()).intValue() : ((Integer)((Pair)decodeResult.getOrThrow()).getFirst()).intValue();
            if (id == -1) {
                // empty if block
            }
            if (id >= 0) {
                class_1799 itemStack = ((class_1735)screenHandler.field_7761.get(id)).method_7677();
                if (itemStack.method_57826(BLUEPRINT_COMPONENT)) {
                    return (BlueprintComponent)itemStack.method_57824(BLUEPRINT_COMPONENT);
                }
            } else {
                Miapi.LOGGER.error("could not correctly read blueprint data!");
            }
        }
        return BlueprintManager.getBlueprint(dataMap, screenHandler);
    }

    public class_2561 getName() {
        return this.name.orElse(this.toMerge.getModuleName());
    }

    public CraftOption asCraftOption(CraftingScreenHandler screenHandler) {
        return new CraftOption(this.toMerge.module, () -> {
            int i = -1;
            Optional<class_1735> optional = screenHandler.field_7761.stream().filter(a -> a.method_7677().method_57826(BLUEPRINT_COMPONENT)).filter(a -> this.equals(a.method_7677().method_57824(BLUEPRINT_COMPONENT))).findAny();
            if (optional.isPresent()) {
                i = optional.get().field_7874;
            }
            JsonElement element = (JsonElement)Codec.INT.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)i).getOrThrow();
            JsonElement booleanElement = (JsonElement)Miapi.FIXED_BOOL_CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)this.useMaterialCrafting()).getOrThrow();
            return Map.of(ID, element, AllowedMaterial.KEY, booleanElement);
        }, -200.0, this.getName());
    }

    public boolean equals(Object obj) {
        if (obj instanceof BlueprintComponent) {
            BlueprintComponent blueprintComponent = (BlueprintComponent)obj;
            String first = ((JsonElement)CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)this).getOrThrow()).toString();
            String other = ((JsonElement)CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)blueprintComponent).getOrThrow()).toString();
            return first.equals(other);
        }
        return super.equals(obj);
    }
}

