/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.client.atlas;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_563;
import net.minecraft.class_572;
import net.minecraft.class_583;
import net.minecraft.class_630;
import net.minecraft.class_811;
import net.minecraft.class_897;
import net.minecraft.class_922;
import net.minecraft.class_979;
import smartin.miapi.client.model.MiapiItemModel;
import smartin.miapi.mixin.client.ElytraEntityModelAccessor;
import smartin.miapi.mixin.client.ElytraFeatureRendererAccessor;
import smartin.miapi.mixin.client.LivingEntityRendererAccessor;

@Environment(value=EnvType.CLIENT)
public class ArmorModelManager {
    public static List<ArmorPartProvider> partProviders = new ArrayList<ArmorPartProvider>();

    public static void renderArmorPiece(class_4587 matrices, class_4597 vertexConsumers, int light, class_1304 armorSlot, class_1799 itemStack, class_1309 entity, class_572 outerModel, class_583 entityModel) {
        partProviders.forEach(armorPartProvider -> {
            List<ArmorPart> armorParts = armorPartProvider.getParts(armorSlot, entity, outerModel, entityModel);
            armorParts.forEach(armorPart -> {
                matrices.method_22903();
                String key = armorPart.apply(matrices, armorSlot, entity, outerModel, entityModel);
                MiapiItemModel miapiItemModel = MiapiItemModel.getItemModel(itemStack);
                if (miapiItemModel != null) {
                    miapiItemModel.render(key, matrices, class_811.field_4316, 0.0f, vertexConsumers, light, class_4608.field_21444);
                }
                matrices.method_22909();
            });
        });
    }

    static {
        partProviders.add(new ModelPartProvider());
        partProviders.add(new ElytraPartProvider());
    }

    public static interface ArmorPartProvider {
        public List<ArmorPart> getParts(class_1304 var1, class_1309 var2, class_572<?> var3, class_583 var4);
    }

    public static interface ArmorPart {
        public String apply(class_4587 var1, class_1304 var2, class_1309 var3, class_572<?> var4, class_583 var5);
    }

    public static final class ModelPartProvider
    implements ArmorPartProvider {
        private static final String[] modelParts = new String[]{"head", "hat", "left_arm", "right_arm", "left_leg", "right_leg", "body"};

        @Override
        public List<ArmorPart> getParts(class_1304 equipmentSlot, class_1309 livingEntity, class_572<?> model, class_583 entityModel) {
            ArrayList<ArmorPart> parts = new ArrayList<ArmorPart>();
            for (String key : modelParts) {
                parts.add((matrixStack, equipmentSlot1, livingEntity1, model1, entityModel1) -> {
                    entityModel1.method_17081((class_583)model1);
                    class_630 part = ModelPartProvider.getModelPart(model1, key);
                    part.method_22703(matrixStack);
                    return key;
                });
            }
            return parts;
        }

        private static class_630 getModelPart(class_572<?> model, String name) {
            return switch (name) {
                case "head" -> model.field_3398;
                case "hat" -> model.field_3394;
                case "left_arm" -> model.field_27433;
                case "right_arm" -> model.field_3401;
                case "left_leg" -> model.field_3397;
                case "right_leg" -> model.field_3392;
                default -> model.field_3391;
            };
        }
    }

    public static final class ElytraPartProvider
    implements ArmorPartProvider {
        @Override
        public List<ArmorPart> getParts(class_1304 equipmentSlot, class_1309 livingEntity, class_572<?> model, class_583 entityModel) {
            class_922 livingEntityRenderer;
            Optional<Object> elytraFeatureRenderer;
            ArrayList<ArmorPart> parts = new ArrayList<ArmorPart>();
            class_897 class_8972 = class_310.method_1551().method_1561().method_3953((class_1297)livingEntity);
            if (class_8972 instanceof class_922 && (elytraFeatureRenderer = ((LivingEntityRendererAccessor)(livingEntityRenderer = (class_922)class_8972)).getFeatures().stream().filter(a -> a instanceof class_979).findAny()).isPresent()) {
                class_563 elytraEntityModel = ((ElytraFeatureRendererAccessor)elytraFeatureRenderer.get()).getElytra();
                livingEntity.method_5791();
                livingEntity.method_5695(0.0f);
                livingEntity.method_17825();
                elytraEntityModel.method_17079(livingEntity, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
                parts.add((matrixStack, equipmentSlot1, livingEntity1, model1, entityModel1) -> {
                    entityModel.method_17081((class_583)elytraEntityModel);
                    entityModel1.method_17081((class_583)model1);
                    class_630 part = ((ElytraEntityModelAccessor)elytraEntityModel).getLeftWing();
                    part.method_22703(matrixStack);
                    return "left_wing";
                });
                parts.add((matrixStack, equipmentSlot1, livingEntity1, model1, entityModel1) -> {
                    entityModel.method_17081((class_583)elytraEntityModel);
                    entityModel1.method_17081((class_583)model1);
                    class_630 part = ((ElytraEntityModelAccessor)elytraEntityModel).getRightWing();
                    part.method_22703(matrixStack);
                    return "right_wing";
                });
                return parts;
            }
            return parts;
        }
    }
}

