/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.client.atlas;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.IntUnaryOperator;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1043;
import net.minecraft.class_1058;
import net.minecraft.class_1921;
import net.minecraft.class_2350;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_777;
import net.minecraft.class_918;
import smartin.miapi.client.MiapiClient;
import smartin.miapi.datapack.ReloadEvents;
import smartin.miapi.material.base.Material;
import smartin.miapi.material.palette.SpriteColorer;

@Environment(value=EnvType.CLIENT)
public class MaterialSpriteManager {
    static Map<Holder, class_1043> animated_Textures = new HashMap<Holder, class_1043>();
    public static final long CACHE_SIZE = 10000L;
    public static final long CACHE_LIFETIME = 10L;
    public static final TimeUnit CACHE_LIFETIME_UNIT = TimeUnit.SECONDS;
    protected static Map<class_2960, class_1043> nativeImageBackedTextureMap = new HashMap<class_2960, class_1043>();
    public static Set<class_1058> animated = new HashSet<class_1058>();
    protected static final Cache<Holder, class_2960> materialSpriteCache = CacheBuilder.newBuilder().maximumSize(10000L).expireAfterAccess(10L, CACHE_LIFETIME_UNIT).removalListener(notification -> {
        if (notification.wasEvicted()) {
            Object patt1$temp;
            Object patt0$temp = notification.getValue();
            if (patt0$temp instanceof class_2960) {
                class_2960 removeId = (class_2960)patt0$temp;
                class_1043 texture = nativeImageBackedTextureMap.get(removeId);
                if (texture != null) {
                    texture.close();
                }
                class_310.method_1551().method_1531().method_4615(removeId);
            }
            if ((patt1$temp = notification.getKey()) instanceof Holder) {
                Holder holder = (Holder)patt1$temp;
                animated_Textures.remove(holder);
                try {
                    holder.colorer.close();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }).build((CacheLoader)new CacheLoader<Holder, class_2960>(){

        public class_2960 load(Holder key) {
            return MaterialSpriteManager.getMaterialSprite(key);
        }
    });

    public static class_2960 getMaterialSprite(class_1058 oldSprite, Material material, SpriteColorer materialSpriteColorer) {
        Holder holder = new Holder(oldSprite, material, materialSpriteColorer);
        return MaterialSpriteManager.getMaterialSprite(holder);
    }

    public static class_2960 getMaterialSprite(Holder holder) {
        class_2960 identifier = (class_2960)materialSpriteCache.getIfPresent((Object)holder);
        if (identifier == null) {
            SpriteColorer.MaterialRecoloredSpriteHolder colorer = holder.colorer().createSpriteManager(holder.sprite().method_45851());
            class_1043 nativeImageBackedTexture = new class_1043(colorer.recolor().method_48462(IntUnaryOperator.identity()));
            class_2960 spriteId = class_310.method_1551().method_1531().method_4617("miapi/dynmaterialsprites", nativeImageBackedTexture);
            if (colorer.requireTick()) {
                animated_Textures.put(holder, nativeImageBackedTexture);
            }
            materialSpriteCache.put((Object)holder, (Object)spriteId);
            return spriteId;
        }
        return identifier;
    }

    public static void clear() {
        materialSpriteCache.invalidateAll();
    }

    public static void tick() {
        if (!ReloadEvents.isInReload()) {
            ArrayList toRemove = new ArrayList();
            animated_Textures.forEach((holder, nativeImageBackedTexture) -> {
                try {
                    holder.colorer.tick(nativeImage -> {
                        nativeImageBackedTexture.method_4525().method_4317(nativeImage);
                        nativeImageBackedTexture.method_4524();
                    }, holder.sprite().method_45851());
                }
                catch (Exception e) {
                    toRemove.add(holder);
                }
            });
            toRemove.forEach(arg_0 -> materialSpriteCache.invalidate(arg_0));
        }
    }

    public static void markTextureAsAnimatedInUse(class_1058 sprite) {
        if (MiapiClient.isSodiumLoaded()) {
            animated.add(sprite);
        }
    }

    public static void onHudRender(class_332 drawContext) {
        class_4588 consumer = class_918.method_23181((class_4597)drawContext.method_51450(), (class_1921)class_1921.method_51784(), (boolean)false, (boolean)false);
        int[] quadData = new int[32];
        for (class_1058 sprite : animated) {
            class_777 bakedQuad = new class_777(quadData, 0, class_2350.field_11033, sprite, false);
            consumer.method_22919(drawContext.method_51448().method_23760(), bakedQuad, 0.0f, 0.0f, 0.0f, 0.0f, 0, 0);
        }
        animated.clear();
    }

    public record Holder(class_1058 sprite, Material material, SpriteColorer colorer) {
    }
}

