/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.client.gui;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_5250;
import net.minecraft.class_5253;
import net.minecraft.class_5348;
import smartin.miapi.client.gui.InteractAbleWidget;

@Environment(value=EnvType.CLIENT)
public class MultiLineTextWidget
extends InteractAbleWidget {
    public class_2561 rawText;
    public List<class_2561> lines = new ArrayList<class_2561>();
    private int longestLine;
    public int maxLineLength;
    public class_327 textRenderer;
    public int spacer;
    public boolean hasTextShadow;
    public int textColor;

    public MultiLineTextWidget(int x, int y, int width, int height, class_2561 text) {
        super(x, y, width, height, (class_2561)class_2561.method_43473());
        this.textRenderer = class_310.method_1551().field_1772;
        this.spacer = 1;
        this.hasTextShadow = true;
        this.textColor = class_5253.class_5254.method_27764((int)255, (int)255, (int)255, (int)255);
        this.maxLineLength = width;
        this.setText(text);
    }

    public void setText(class_2561 text) {
        this.rawText = text;
        List rawLines = Arrays.stream(text.getString().split("\n")).collect(Collectors.toList());
        this.lines.clear();
        while (!rawLines.isEmpty()) {
            class_5250 line;
            int size;
            String rawLine = (String)rawLines.remove(0);
            if (this.maxLineLength > 0 && this.textRenderer.method_1727(rawLine) > this.maxLineLength) {
                ArrayList<String> words = new ArrayList<String>(Arrays.stream(rawLine.split(" ")).toList());
                StringBuilder currentLine = new StringBuilder();
                currentLine.append((String)words.remove(0));
                currentLine.append(" ");
                StringBuilder nextLine = new StringBuilder();
                int currentLineLength = 0;
                boolean isLineExceeded = false;
                for (String word : words) {
                    int wordLength = this.textRenderer.method_1727(word);
                    if (!isLineExceeded && currentLineLength + wordLength + 1 <= this.maxLineLength) {
                        currentLine.append(word).append(" ");
                        currentLineLength = this.textRenderer.method_1727(currentLine.toString());
                        continue;
                    }
                    nextLine.append(word).append(" ");
                    isLineExceeded = true;
                }
                if (isLineExceeded) {
                    rawLines.add(0, nextLine.toString());
                }
                rawLine = currentLine.toString().trim();
            }
            if ((size = this.textRenderer.method_27525((class_5348)(line = class_2561.method_43471((String)rawLine)))) > this.longestLine) {
                this.longestLine = size;
            }
            this.lines.add((class_2561)line);
        }
        this.field_22758 = this.longestLine;
        int n = this.lines.size();
        Objects.requireNonNull(this.textRenderer);
        this.field_22759 = n * 9 + Math.max(0, this.lines.size() - 1) * this.spacer;
    }

    @Override
    public void method_48579(class_332 context, int mouseX, int mouseY, float delta) {
        int start = this.method_46427();
        for (class_2561 line : this.lines) {
            context.method_51439(this.textRenderer, line, this.method_46426(), start, this.textColor, this.hasTextShadow);
            Objects.requireNonNull(this.textRenderer);
            start += 9 + this.spacer;
        }
        super.method_48579(context, mouseX, mouseY, delta);
    }
}

