/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.client.gui;

import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_339;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector4f;
import smartin.miapi.client.gui.InteractAbleWidget;
import smartin.miapi.client.gui.TransformableWidget;
import smartin.miapi.client.gui.crafting.CraftingScreen;

@Environment(value=EnvType.CLIENT)
public class ScrollList
extends InteractAbleWidget {
    public List<InteractAbleWidget> widgets = null;
    private int scrollAmount = 0;
    private int maxScrollAmount = 0;
    public boolean saveMode = true;
    boolean needsScrollbar = false;
    public boolean alwaysEnableScrollbar = false;
    int barWidth = 8;
    boolean scrollbarDragged = false;
    public boolean altDesign = false;

    public ScrollList(int x, int y, int width, int height, List<InteractAbleWidget> widgets) {
        super(x, y, width, height, (class_2561)class_2561.method_43473());
        this.setList(widgets);
    }

    public void setList(List<InteractAbleWidget> widgets) {
        this.widgets = widgets;
        this.children().clear();
    }

    public void setScrollAmount(int amount) {
        this.scrollAmount = amount;
    }

    public int getScrollAmount() {
        return this.scrollAmount;
    }

    @Override
    public void method_48579(class_332 drawContext, int mouseX, int mouseY, float delta) {
        super.method_48579(drawContext, mouseX, mouseY, delta);
        int totalHeight = 0;
        for (class_339 class_3392 : this.widgets) {
            totalHeight += class_3392.method_25364();
        }
        this.maxScrollAmount = Math.max(0, totalHeight - this.field_22759);
        if (this.widgets == null) {
            return;
        }
        this.scrollAmount = Math.max(0, Math.min(this.scrollAmount, this.maxScrollAmount));
        this.needsScrollbar = totalHeight > this.field_22759;
        int startY = this.method_46427() - this.scrollAmount;
        for (class_339 class_3393 : this.widgets) {
            if (startY + class_3393.method_25364() >= this.method_46427() && startY <= this.method_46427() + this.field_22759 - 1) {
                class_3393.method_46419(startY);
                class_3393.method_46421(this.method_46426());
                if (this.showScrollbar()) {
                    class_3393.method_25358(this.field_22758 - this.barWidth);
                } else {
                    class_3393.method_25358(this.field_22758);
                }
                Matrix4f matrix4f = new Matrix4f((Matrix4fc)drawContext.method_51448().method_23760().method_23761());
                Vector4f posX = TransformableWidget.transFormMousePos(this.method_46426(), this.method_46427(), matrix4f);
                Vector4f posY = TransformableWidget.transFormMousePos(this.method_46426() + this.field_22758, this.method_46427() + this.field_22759, matrix4f);
                drawContext.method_44379((int)posX.x(), (int)posX.y, (int)posY.x(), (int)posY.y());
                class_3393.method_25394(drawContext, mouseX, mouseY, delta);
                drawContext.method_44380();
            }
            startY += class_3393.method_25364();
        }
        if (this.showScrollbar()) {
            int n = this.method_46426() + this.field_22758 - this.barWidth;
            float f = (float)this.scrollAmount / (float)this.maxScrollAmount;
            this.renderScrollbarBackground(drawContext, mouseX, mouseY, delta, n, this.barWidth);
            this.renderScrollbarClickAble(drawContext, mouseX, mouseY, delta, n, this.barWidth, f);
        }
    }

    public void renderScrollbarBackground(class_332 drawContext, int mouseX, int mouseY, float delta, int barX, int barWidth) {
        int offsetAlt = this.altDesign ? 28 : 0;
        ScrollList.drawTextureWithEdge(drawContext, CraftingScreen.BACKGROUND_TEXTURE, barX, this.method_46427(), 498 - offsetAlt, 96, 14, 15, barWidth, this.method_25364(), 512, 512, 3);
    }

    public void renderScrollbarClickAble(class_332 drawContext, int mouseX, int mouseY, float delta, int barX, int barWidth, float percent) {
        int height = (int)((float)(this.method_25364() - 17) * percent) + (this.altDesign ? (percent >= 1.0f ? 2 : 0) : 1) + this.method_46427();
        int offset = this.needsScrollbar ? 0 : 15;
        int offsetAlt = this.altDesign ? 28 : 0;
        ScrollList.drawTextureWithEdge(drawContext, CraftingScreen.BACKGROUND_TEXTURE, barX, height, 484 - offsetAlt, 96 + offset, 14, 15, barWidth, 15, 512, 512, 3);
    }

    private boolean showScrollbar() {
        return this.needsScrollbar || this.alwaysEnableScrollbar;
    }

    @Override
    public void renderHover(class_332 drawContext, int mouseX, int mouseY, float delta) {
        if (this.method_25405(mouseX, mouseY)) {
            int startY = this.method_46427() - this.scrollAmount;
            for (class_339 class_3392 : this.widgets) {
                if (startY + class_3392.method_25364() >= this.method_46427() && startY <= this.method_46427() + this.field_22759 - 1 && class_3392 instanceof InteractAbleWidget) {
                    InteractAbleWidget interactAbleWidget = (InteractAbleWidget)class_3392;
                    class_3392.method_46419(startY);
                    class_3392.method_46421(this.method_46426());
                    if (this.showScrollbar()) {
                        class_3392.method_25358(this.field_22758 - this.barWidth);
                    } else {
                        class_3392.method_25358(this.field_22758);
                    }
                    interactAbleWidget.renderHover(drawContext, mouseX, mouseY, delta);
                }
                startY += class_3392.method_25364();
            }
        }
    }

    @Override
    public boolean method_25401(double mouseX, double mouseY, double scrollX, double scrollY) {
        if (this.widgets == null) {
            return false;
        }
        if (this.method_25405(mouseX, mouseY)) {
            for (class_339 class_3392 : this.widgets) {
                if (!class_3392.method_25401(mouseX, mouseY, scrollX, scrollY)) continue;
                return true;
            }
            int scrollSpeed = 10;
            this.scrollAmount = (int)((double)this.scrollAmount - scrollY * (double)scrollSpeed);
            return true;
        }
        return false;
    }

    @Override
    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (this.widgets != null) {
            for (InteractAbleWidget widget : this.widgets) {
                if (!widget.method_25404(keyCode, scanCode, modifiers)) continue;
                return true;
            }
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    @Override
    public boolean method_16803(int keyCode, int scanCode, int modifiers) {
        if (this.widgets != null) {
            for (InteractAbleWidget widget : this.widgets) {
                if (!widget.method_16803(keyCode, scanCode, modifiers)) continue;
                return true;
            }
        }
        return super.method_16803(keyCode, scanCode, modifiers);
    }

    @Override
    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (this.method_25405(mouseX, mouseY)) {
            if (this.widgets == null) {
                return false;
            }
            boolean clicked = false;
            if (this.showScrollbar() && this.method_25405(mouseX, mouseY) && mouseX > (double)(this.method_46426() + this.field_22758 - this.barWidth) && mouseX < (double)(this.method_46426() + this.field_22758)) {
                this.scrollbarDragged = true;
                return true;
            }
            for (class_339 class_3392 : this.widgets) {
                if (!class_3392.method_25405(mouseX, mouseY) || !class_3392.method_25402(mouseX, mouseY, button)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean method_25403(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (mouseX > (double)(this.method_46426() + this.field_22758 - this.barWidth) && mouseX < (double)(this.method_46426() + this.field_22758)) {
            if (mouseY < (double)this.method_46427()) {
                this.scrollAmount = 0;
                return true;
            }
            if (mouseY > (double)(this.method_46427() + this.field_22759)) {
                this.scrollAmount = this.maxScrollAmount;
                return true;
            }
            double i = Math.min(1.0, Math.max(0.0, (mouseY - (double)this.method_46427()) / (double)(this.method_25364() - 10)));
            this.scrollAmount = (int)(i * (double)this.maxScrollAmount);
            return true;
        }
        for (InteractAbleWidget child : this.widgets) {
            if (!child.method_25405(mouseX, mouseY) || !child.method_25403(mouseX, mouseY, button, deltaX, deltaY)) continue;
            return true;
        }
        return super.method_25403(mouseX, mouseY, button, deltaX, deltaY);
    }

    @Override
    public boolean method_25406(double mouseX, double mouseY, int button) {
        if (this.widgets == null) {
            return false;
        }
        if (this.showScrollbar() && this.method_25405(mouseX, mouseY) && mouseX > (double)(this.method_46426() + this.field_22758 - this.barWidth) && mouseX < (double)(this.method_46426() + this.field_22758)) {
            this.scrollbarDragged = false;
            return true;
        }
        boolean released = false;
        for (class_339 class_3392 : this.widgets) {
            if (!class_3392.method_25406(mouseX, mouseY, button)) continue;
            released = true;
        }
        return released;
    }

    @Override
    public boolean method_25405(double mouseX, double mouseY) {
        if (!this.field_22764) {
            return false;
        }
        double x = this.method_46426();
        double y = this.method_46427();
        double width = this.field_22758;
        double height = this.field_22759;
        return mouseX >= x && mouseY >= y && mouseX < x + width && mouseY < y + height;
    }
}

