/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.client.gui;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4068;
import net.minecraft.class_5348;
import org.joml.Vector4f;
import smartin.miapi.client.gui.InteractAbleWidget;
import smartin.miapi.client.gui.TransformableWidget;

@Environment(value=EnvType.CLIENT)
public class ScrollingTextWidget
extends InteractAbleWidget
implements class_4068,
class_364 {
    private class_2561 text = class_2561.method_43473();
    private float timer = 0.0f;
    private int scrollPosition = 0;
    public int textColor;
    public float scrollDelay = 0.5f;
    public float scrollHoldTime = 2.0f;
    public float firstLetterExtraTime = 1.0f;
    public boolean hasTextShadow = true;
    private Orientation orientation;

    public ScrollingTextWidget(int x, int y, int maxWidth, class_2561 text, int textColor) {
        super(x, y, maxWidth, 9, (class_2561)class_2561.method_43473());
        this.textColor = textColor;
        this.setText(text);
        this.orientation = Orientation.LEFT;
    }

    public ScrollingTextWidget(int x, int y, int maxWidth, class_2561 text) {
        super(x, y, maxWidth, 9, (class_2561)class_2561.method_43473());
        this.textColor = -1;
        this.setText(text);
        this.orientation = Orientation.LEFT;
    }

    public void setText(class_2561 text) {
        this.text = text == null ? class_2561.method_43473() : text;
        this.scrollPosition = 0;
        this.timer = -this.firstLetterExtraTime;
    }

    public class_2561 getText() {
        return this.text == null ? class_2561.method_43470((String)"Missing Text!") : this.text;
    }

    public void setOrientation(Orientation orientation) {
        this.orientation = orientation;
    }

    @Override
    public void method_48579(class_332 context, int mouseX, int mouseY, float delta) {
        int textWidth = class_310.method_1551().field_1772.method_27525((class_5348)this.getText());
        boolean scissorEnabled = false;
        int textStart = this.method_46426();
        switch (this.orientation.ordinal()) {
            case 1: {
                textStart += (this.field_22758 - textWidth) / 2;
                break;
            }
            case 2: {
                textStart += this.field_22758 - textWidth;
            }
        }
        if (textWidth > this.field_22758) {
            String string = this.getText().getString();
            int offsetAmount = 0;
            boolean stallScrollPos = false;
            if (this.scrollPosition < string.length()) {
                String sub = string.substring(0, this.scrollPosition);
                String remaining = string.substring(Math.min(string.length() - 1, this.scrollPosition + 1));
                int subLength = class_310.method_1551().field_1772.method_1727(sub);
                int remainingLength = class_310.method_1551().field_1772.method_1727(remaining);
                offsetAmount = -subLength;
                if (remainingLength <= this.field_22758) {
                    stallScrollPos = true;
                }
            }
            this.timer += delta / 20.0f;
            if (this.timer > this.scrollDelay && !stallScrollPos) {
                ++this.scrollPosition;
                this.timer = 0.0f;
            }
            if (this.timer > this.scrollHoldTime && stallScrollPos) {
                this.scrollPosition = 0;
                this.timer = -this.firstLetterExtraTime;
            }
            textStart += offsetAmount;
            Vector4f corner1 = TransformableWidget.transFormMousePos(this.method_46426(), this.method_46427(), context.method_51448().method_23760().method_23761());
            Vector4f corner2 = TransformableWidget.transFormMousePos(this.method_46426() + this.field_22758, this.method_46427() + this.field_22759, context.method_51448().method_23760().method_23761());
            context.method_44379((int)corner1.x, (int)corner1.y, (int)corner2.x + 1, (int)corner2.y);
            scissorEnabled = true;
        }
        if (this.text != null) {
            context.method_51439(class_310.method_1551().field_1772, this.getText(), textStart, this.method_46427(), this.textColor, this.hasTextShadow);
        }
        if (scissorEnabled) {
            context.method_44380();
        }
        super.method_48579(context, mouseX, mouseY, delta);
    }

    public int getRequiredWidth() {
        return Math.min(this.field_22758, class_310.method_1551().field_1772.method_27525((class_5348)this.getText()));
    }

    public static enum Orientation {
        LEFT,
        CENTERED,
        RIGHT;

    }
}

