/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.client.gui.crafting;

import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1304;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1723;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_1890;
import net.minecraft.class_2338;
import net.minecraft.class_2540;
import net.minecraft.class_2586;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3913;
import net.minecraft.class_3914;
import net.minecraft.class_3919;
import net.minecraft.class_9331;
import net.minecraft.class_9701;
import org.jetbrains.annotations.Nullable;
import smartin.miapi.Miapi;
import smartin.miapi.blocks.ModularWorkBenchEntity;
import smartin.miapi.client.gui.MutableSlot;
import smartin.miapi.craft.CraftAction;
import smartin.miapi.item.ModularItemStackConverter;
import smartin.miapi.modules.ItemModule;
import smartin.miapi.modules.ModuleInstance;
import smartin.miapi.modules.edit_options.EditOption;
import smartin.miapi.modules.properties.slot.AllowedSlots;
import smartin.miapi.modules.properties.slot.SlotProperty;
import smartin.miapi.network.Networking;
import smartin.miapi.registries.RegistryInventory;

public class CraftingScreenHandler
extends class_1703 {
    private final class_3914 context;
    private static final String PACKET_ID = ":crafting_packet_";
    public class_1263 inventory;
    public class_1661 playerInventory;
    @Nullable
    public ModularWorkBenchEntity blockEntity;
    public final class_3913 delegate;
    public final String packetID;
    public final String editPacketID;
    public final String packetIDSlotAdd;
    public final String packetIDSlotRemove;
    public CraftingScreenHandler craftingScreenHandler;
    private final List<class_1735> mutableSlots = new ArrayList<class_1735>();
    static final class_2960[] EMPTY_ARMOR_SLOT_TEXTURES = new class_2960[]{class_1723.field_21672, class_1723.field_21671, class_1723.field_21670, class_1723.field_21669};
    private static final class_1304[] EQUIPMENT_SLOT_ORDER = new class_1304[]{class_1304.field_6169, class_1304.field_6174, class_1304.field_6172, class_1304.field_6166};

    public CraftingScreenHandler(int syncId, class_1661 playerInventory) {
        this(syncId, playerInventory, null, class_3914.field_17304, (class_3913)new class_3919(7));
        this.craftingScreenHandler = this;
    }

    public CraftingScreenHandler(int syncId, class_1661 playerInventory, ModularWorkBenchEntity benchEntity, class_3913 delegate) {
        this(syncId, playerInventory, benchEntity, class_3914.field_17304, delegate);
        this.craftingScreenHandler = this;
    }

    public CraftingScreenHandler(int syncId, final class_1661 playerInventory, @Nullable ModularWorkBenchEntity benchEntity, class_3914 context, class_3913 delegate) {
        super(RegistryInventory.craftingScreenHandler, syncId);
        int j;
        this.craftingScreenHandler = this;
        this.packetID = "miapi:crafting_packet_" + playerInventory.field_7546.method_5845() + "_" + syncId;
        this.editPacketID = "miapi:crafting_packet__edit_" + playerInventory.field_7546.method_5845() + "_" + syncId;
        this.packetIDSlotAdd = "miapi:crafting_packet__" + playerInventory.field_7546.method_5845() + "_" + syncId + "_slot_add";
        this.packetIDSlotRemove = "miapi:crafting_packet__" + playerInventory.field_7546.method_5845() + "_" + syncId + "_slot_remove";
        this.delegate = delegate;
        this.playerInventory = playerInventory;
        this.blockEntity = benchEntity;
        if (playerInventory.field_7546 instanceof class_3222) {
            Networking.registerC2SPacket(this.packetID, (buffer, player) -> {
                CraftAction action = new CraftAction((class_2540)buffer, this.blockEntity, this);
                Miapi.server.execute(() -> {
                    action.setItem(this.inventory.method_5438(0));
                    action.linkInventory(this.inventory, 1);
                    if (action.canPerform()) {
                        class_1799 stack = action.perform();
                        this.inventory.method_5447(0, stack);
                        if (this.blockEntity != null) {
                            this.blockEntity.setItem(stack);
                            this.blockEntity.saveAndSync();
                        }
                        this.method_7609(this.inventory);
                    }
                });
            });
            Networking.registerC2SPacket(this.packetIDSlotAdd, (buffer, player) -> {
                int invId = buffer.readInt();
                int slotId = buffer.readInt();
                Miapi.server.execute(() -> {
                    class_1735 slot = new class_1735(this.inventory, invId, 0, 0);
                    slot.field_7874 = slotId;
                    this.mutableSlots.add(slot);
                    this.method_7621(slot);
                    slot.field_7874 = slotId;
                });
            });
            Networking.registerC2SPacket(this.packetIDSlotRemove, (buffer, player) -> {
                int slotId = buffer.readInt();
                Miapi.server.execute(() -> {
                    class_1735 slot = this.method_7611(slotId);
                    this.mutableSlots.remove(slot);
                    this.method_7601(playerInventory.field_7546, slotId);
                });
            });
            Networking.registerC2SPacket(this.editPacketID, (buffer, player) -> {
                String editOptionKey = buffer.method_19772();
                EditOption option = RegistryInventory.EDIT_OPTION_MIAPI_REGISTRY.get(editOptionKey);
                String[] array = buffer.method_19772().split("\n");
                final class_1799 stack = ModularItemStackConverter.getModularVersion(this.inventory.method_5438(0));
                ModuleInstance root = ItemModule.getModules(stack);
                ArrayList<String> position = new ArrayList<String>();
                Collections.addAll(position, array);
                final ModuleInstance current = root.getPosition(position).copy();
                SlotProperty.ModuleSlot slot = SlotProperty.getSlotIn(current);
                if (slot == null && current != null && current.module != null) {
                    slot = new SlotProperty.ModuleSlot(AllowedSlots.getAllowedSlots(current.module));
                }
                assert (option != null);
                final SlotProperty.ModuleSlot finalSlot = slot;
                EditOption.EditContext editContext = new EditOption.EditContext(){
                    final /* synthetic */ class_3222 val$player;
                    {
                        this.val$player = class_32222;
                    }

                    @Override
                    public void craft(class_2540 craftBuffer) {
                    }

                    @Override
                    public void preview(class_2540 preview) {
                    }

                    @Override
                    public SlotProperty.ModuleSlot getSlot() {
                        return finalSlot;
                    }

                    @Override
                    public class_1799 getItemstack() {
                        return stack;
                    }

                    @Override
                    @Nullable
                    public ModuleInstance getInstance() {
                        return current;
                    }

                    @Override
                    @Nullable
                    public class_1657 getPlayer() {
                        return this.val$player;
                    }

                    @Override
                    @Nullable
                    public ModularWorkBenchEntity getWorkbench() {
                        return CraftingScreenHandler.this.blockEntity;
                    }

                    @Override
                    public class_1263 getLinkedInventory() {
                        return CraftingScreenHandler.this.inventory;
                    }

                    @Override
                    public CraftingScreenHandler getScreenHandler() {
                        return CraftingScreenHandler.this.craftingScreenHandler;
                    }
                };
                if (option.isVisible(editContext)) {
                    class_1799 editedStack = option.execute((class_2540)buffer, editContext);
                    Miapi.server.execute(() -> {
                        this.inventory.method_5447(0, editedStack);
                        if (this.blockEntity != null) {
                            this.blockEntity.setItem(editedStack);
                            this.blockEntity.saveAndSync();
                        }
                        this.inventory.method_5431();
                        this.method_7609(this.inventory);
                    });
                } else {
                    Miapi.LOGGER.warn("ERROR - Couldn`t verify craft action of type" + editOptionKey + " from client " + player.method_5845() + " " + player.method_5476().getString() + " This might be a bug or somebody is trying to exploit");
                    Miapi.LOGGER.warn(String.valueOf(current));
                    Miapi.LOGGER.warn(((Object)position).toString());
                }
            });
        }
        this.context = context;
        this.inventory = new class_1277(54){

            public void method_5431() {
                super.method_5431();
                CraftingScreenHandler.this.method_7609((class_1263)this);
            }
        };
        if (this.blockEntity != null) {
            this.setItem(this.blockEntity.getItem());
        }
        int yOffset = 131;
        int xOffset = 210;
        for (j = 0; j < 3; ++j) {
            for (int k = 0; k < 9; ++k) {
                this.method_7621(new PlayerInventorySlot(playerInventory, k + j * 9 + 9, k * 18 + xOffset - 15, j * 18 + yOffset - 14));
            }
        }
        for (j = 0; j < 9; ++j) {
            this.method_7621(new PlayerInventorySlot(playerInventory, j, j * 18 + xOffset - 15, 58 + yOffset - 14));
        }
        this.method_7621(new ModifyingSlot(this.inventory, 0, 34, 176, this.blockEntity));
        for (int i = 0; i < 4; ++i) {
            final class_1304 equipmentSlot = EQUIPMENT_SLOT_ORDER[i];
            int offset = i < 2 ? 0 : 1;
            this.method_7621(new class_1735(this, (class_1263)playerInventory, 39 - i, 84 + i * 18 - offset - 15, 175){

                public int method_7675() {
                    return 1;
                }

                public boolean method_7680(class_1799 itemStack) {
                    return equipmentSlot == playerInventory.field_7546.method_32326(itemStack);
                }

                public boolean method_7674(class_1657 playerEntity) {
                    class_1799 itemStack = this.method_7677();
                    return (itemStack.method_7960() || playerEntity.method_7337() || !class_1890.method_60142((class_1799)itemStack, (class_9331)class_9701.field_51656)) && super.method_7674(playerEntity);
                }

                public Pair<class_2960, class_2960> method_7679() {
                    return Pair.of((Object)class_1723.field_21668, (Object)EMPTY_ARMOR_SLOT_TEXTURES[equipmentSlot.method_5927()]);
                }
            });
        }
        this.method_7621(new class_1735(this, (class_1263)playerInventory, 40, 140, 175){

            public Pair<class_2960, class_2960> method_7679() {
                return Pair.of((Object)class_1723.field_21668, (Object)class_1723.field_21673);
            }
        });
        this.method_17360(delegate);
    }

    public boolean notClient() {
        return !this.playerInventory.field_7546.method_37908().field_9236;
    }

    public void method_7623() {
        class_1799 inv;
        class_1799 block;
        super.method_7623();
        if (this.notClient() && !class_1799.method_7984((class_1799)(block = this.blockEntity.getItem()), (class_1799)(inv = this.inventory.method_5438(0)))) {
            this.blockEntity.setItem(this.inventory.method_5438(0));
            this.blockEntity.saveAndSync();
            this.updateBE();
        }
        if (this.blockEntity == null && this.delegate.method_17390(0) == 1) {
            short xsh = (short)this.delegate.method_17390(1);
            short xsl = (short)this.delegate.method_17390(2);
            int x = xsh << 16 | xsl & 0xFFFF;
            short ysh = (short)this.delegate.method_17390(3);
            short ysl = (short)this.delegate.method_17390(4);
            int y = ysh << 16 | ysl & 0xFFFF;
            short zsh = (short)this.delegate.method_17390(5);
            short zsl = (short)this.delegate.method_17390(6);
            int z = zsh << 16 | zsl & 0xFFFF;
            class_2586 be = this.playerInventory.field_7546.method_37908().method_8321(new class_2338(x, y, z));
            if (be instanceof ModularWorkBenchEntity) {
                ModularWorkBenchEntity casted;
                this.blockEntity = casted = (ModularWorkBenchEntity)be;
            }
        }
    }

    public void removeSlotByClient(class_1735 slot) {
        if (!this.field_7761.contains((Object)slot)) {
            return;
        }
        this.method_7601(this.playerInventory.field_7546, slot.field_7874);
        slot.method_7668();
        if (slot instanceof MutableSlot) {
            MutableSlot mutableSlot = (MutableSlot)slot;
            mutableSlot.setEnabled(false);
        }
        this.playerInventory.method_5431();
        this.inventory.method_5431();
        class_2540 buf = Networking.createBuffer();
        buf.method_53002(slot.field_7874);
        this.mutableSlots.remove(slot);
        Networking.sendC2S(this.packetIDSlotRemove, buf);
    }

    public void clearSlots() {
        this.field_7761.stream().filter(MutableSlot.class::isInstance).forEach(this::removeSlotByClient);
    }

    public void addSlotByClient(class_1735 slot) {
        if (this.field_7761.contains((Object)slot)) {
            return;
        }
        this.method_7621(slot);
        class_2540 buf = Networking.createBuffer();
        buf.method_53002(slot.method_34266());
        buf.method_53002(slot.field_7874);
        this.mutableSlots.add(slot);
        Networking.sendC2S(this.packetIDSlotAdd, buf);
        slot.method_7668();
    }

    public boolean method_7597(class_1657 player) {
        return true;
    }

    public void method_7595(class_1657 player) {
        super.method_7595(player);
        this.context.method_17393((world, pos) -> this.method_7607(player, this.inventory));
        for (int i = 0; i < this.inventory.method_5439(); ++i) {
            class_1799 stack;
            if (i == 0 || (stack = this.inventory.method_5438(i)).method_7960()) continue;
            if (!player.method_31548().method_7394(stack)) {
                player.method_7328(stack, false);
            }
            this.inventory.method_5447(i, class_1799.field_8037);
        }
        Networking.unRegisterC2SPacket(this.packetID);
        Networking.unRegisterC2SPacket(this.packetIDSlotAdd);
        Networking.unRegisterC2SPacket(this.packetIDSlotRemove);
        Networking.unRegisterC2SPacket(this.editPacketID);
        if (this.notClient() && this.blockEntity != null) {
            this.blockEntity.saveAndSync();
        }
    }

    public void setItem(class_1799 stack) {
        this.inventory.method_5447(0, stack);
        this.inventory.method_5431();
        if (this.blockEntity != null) {
            this.blockEntity.setItem(stack);
            if (this.notClient()) {
                this.blockEntity.saveAndSync();
            }
        }
    }

    private void updateBE() {
        if (this.notClient()) {
            this.blockEntity.setItem(this.inventory.method_5438(0));
            this.blockEntity.saveAndSync();
        }
    }

    public class_1799 method_7601(class_1657 player, int index) {
        this.inventory.method_5431();
        class_1735 slot = (class_1735)this.field_7761.get(index);
        if (slot != null && slot.method_7681()) {
            class_1799 itemStack2 = slot.method_7677();
            if (index >= 36 || index > 41) {
                slot.method_7667(player, itemStack2);
                if (!this.method_7616(itemStack2, 37, 41, true)) {
                    this.method_7616(itemStack2, 0, 36, true);
                }
                if (index == 36 && this.blockEntity != null) {
                    this.blockEntity.setItem(itemStack2);
                    if (this.notClient()) {
                        this.blockEntity.saveAndSync();
                    }
                }
                slot.method_7668();
                return class_1799.field_8037;
            }
            for (class_1735 slot1 : this.mutableSlots) {
                if (slot1.field_7874 < 36 || this.method_7616(itemStack2, slot1.field_7874, slot1.field_7874 + 1, true)) continue;
                return class_1799.field_8037;
            }
            if ((((class_1735)this.field_7761.get(36)).method_7677().method_7960() || ((class_1735)this.field_7761.get(36)).method_7677().method_7909().equals(itemStack2.method_7909())) && !this.method_7616(itemStack2, 36, 37, true)) {
                return class_1799.field_8037;
            }
            slot.method_7668();
        }
        return class_1799.field_8037;
    }

    protected void method_7607(class_1657 player, class_1263 inventory) {
        class_3222 serverPlayerEntity;
        if (!player.method_5805() || player instanceof class_3222 && (serverPlayerEntity = (class_3222)player).method_14239()) {
            for (int i = 0; i < inventory.method_5439(); ++i) {
                if (i == 0) continue;
                player.method_7328(inventory.method_5441(i), false);
            }
            return;
        }
        for (int i = 0; i < inventory.method_5439(); ++i) {
            if (i == 0) continue;
            class_1661 currentPlayerInv = player.method_31548();
            if (!(currentPlayerInv.field_7546 instanceof class_3222)) continue;
            currentPlayerInv.method_7398(inventory.method_5441(i));
        }
    }

    public static class PlayerInventorySlot
    extends class_1735 {
        public PlayerInventorySlot(class_1661 inventory, int index, int x, int y) {
            super((class_1263)inventory, index, x, y);
        }
    }

    public static class ModifyingSlot
    extends class_1735 {
        protected final ModularWorkBenchEntity blockEntity;

        public ModifyingSlot(class_1263 inventory, int index, int x, int y, ModularWorkBenchEntity blockEntity) {
            super(inventory, index, x, y);
            this.blockEntity = blockEntity;
        }

        public boolean notClient() {
            return this.blockEntity != null && this.blockEntity.method_11002() && !this.blockEntity.method_10997().field_9236;
        }

        public boolean method_7680(class_1799 stack) {
            return true;
        }

        public int method_7675() {
            return 64;
        }

        public void method_53512(class_1799 stack) {
            super.method_53512(stack);
            if (this.notClient()) {
                this.blockEntity.setItem(stack);
                this.blockEntity.saveAndSync();
            }
            this.method_7668();
        }
    }
}

