/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.client.gui.crafting.crafter;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.function.Consumer;
import net.minecraft.class_156;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_5253;
import smartin.miapi.client.gui.InteractAbleWidget;
import smartin.miapi.client.gui.ScrollList;
import smartin.miapi.client.gui.ScrollingTextWidget;
import smartin.miapi.client.gui.StatBar;
import smartin.miapi.client.gui.TransformableWidget;
import smartin.miapi.material.MaterialProperty;
import smartin.miapi.material.base.Material;
import smartin.miapi.modules.ItemModule;
import smartin.miapi.modules.ModuleInstance;

public class MaterialDetailView
extends InteractAbleWidget {
    private final class_1799 itemStack;
    private final Consumer<Object> back;
    private final ScrollingTextWidget header;
    private final Material material;
    private final class_2960 texture = class_2960.method_60655((String)"miapi", (String)"textures/gui/crafter/material_detail_background.png");
    private final float scale = 1.5f;
    public static List<Builder> infoBarBuilders = new ArrayList<Builder>();

    public MaterialDetailView(int x, int y, int width, int height, class_1799 stack, Consumer<Object> back) {
        super(x, y, width, height, (class_2561)class_2561.method_43473());
        this.itemStack = stack;
        this.back = back;
        this.material = MaterialProperty.getMaterialFromIngredient(stack);
        TransformableWidget headerScaler = new TransformableWidget(this.method_46426(), this.method_46427(), this.method_25368(), this.method_25364(), 1.5f);
        this.header = new ScrollingTextWidget((int)((float)(x + 5) * 0.6666667f), (int)((float)(y + 5) * 0.6666667f), width, this.material.getTranslation(), class_5253.class_5254.method_27764((int)255, (int)255, (int)255, (int)255));
        headerScaler.addChild(this.header);
        this.addChild(headerScaler);
        int spacer = 13;
        ArrayList<InteractAbleWidget> widgets = new ArrayList<InteractAbleWidget>();
        widgets.add(new ColorWidget(this.method_46426(), this.method_46427(), this.method_25368(), spacer, this.material.getColor(new ModuleInstance(ItemModule.empty))));
        for (Builder builder : infoBarBuilders) {
            widgets.add(builder.build(x, y, width, spacer, this.material));
        }
        ScrollList list = new ScrollList(x + 10, y + 27, width - 10, this.method_25364() - 27, widgets);
        this.addChild(list);
    }

    public static void registerBuilder(Builder builder) {
        infoBarBuilders.add(builder);
    }

    @Override
    public void method_48579(class_332 drawContext, int mouseX, int mouseY, float delta) {
        if (this.material != null && this.material.hasIcon()) {
            this.material.renderIcon(drawContext, (int)((float)(this.method_46426() + 5) + (float)this.header.getRequiredWidth() * 1.5f), this.method_46427() + 5);
        }
        super.method_48579(drawContext, mouseX, mouseY, delta);
    }

    static {
        MaterialDetailView.registerBuilder(new Builder("hardness"));
        MaterialDetailView.registerBuilder(new Builder("flexibility"));
        MaterialDetailView.registerBuilder(new Builder("density"));
        MaterialDetailView.registerBuilder(new Builder("durability").setMax(2000).setFormat("##"));
        MaterialDetailView.registerBuilder(new Builder("enchantability"));
        MaterialDetailView.registerBuilder(new Builder("mining_speed"));
        MaterialDetailView.registerBuilder(new Builder("mining_level").setMax(4).setFormat("##"));
    }

    private static class ColorWidget
    extends InteractAbleWidget {
        ScrollingTextWidget textWidget;
        public static int textWidth = 70;
        int color;

        public ColorWidget(int x, int y, int width, int height, int color) {
            super(x, y, width, height, (class_2561)class_2561.method_43473());
            this.textWidget = new ScrollingTextWidget(x, y, textWidth, (class_2561)class_2561.method_43471((String)"miapi.material_stat.color"), class_5253.class_5254.method_27764((int)255, (int)255, (int)255, (int)255));
            this.addChild(this.textWidget);
            this.color = color;
        }

        @Override
        public void method_48579(class_332 drawContext, int mouseX, int mouseY, float delta) {
            this.textWidget.method_46421(this.method_46426());
            this.textWidget.method_46419(this.method_46427());
            super.method_48579(drawContext, mouseX, mouseY, delta);
            this.color |= 0xFF000000;
            drawContext.method_25294(this.method_46426() + textWidth, this.method_46427(), this.method_46426() + textWidth + 10, this.method_46427() + 10, this.color);
        }
    }

    public static class Builder {
        public String key;
        public int min = 0;
        public int max = 10;
        public String format = "##.##";

        public Builder(String key) {
            this.key = key;
        }

        public Builder setMax(int max) {
            this.max = max;
            return this;
        }

        public Builder setMin(int min) {
            this.min = min;
            return this;
        }

        public Builder setFormat(String format) {
            this.format = format;
            return this;
        }

        public InteractAbleWidget build(int x, int y, int width, int spacer, Material material) {
            return new InfoBar(x + 10, y, width - 10, spacer, (class_2561)class_2561.method_43471((String)("miapi.material_stat." + this.key)), (float)material.getDouble(this.key), this.min, this.max, this.format);
        }
    }

    public static class InfoBar
    extends InteractAbleWidget {
        public StatBar statBar;
        public ScrollingTextWidget textWidget;
        public static int textWidth = 69;
        public static int barWitdh = 34;
        public static int spacer = 1;
        public ScrollingTextWidget valueHolder;

        public InfoBar(int x, int y, int width, int height, class_2561 text, float value, float min, float max) {
            this(x, y, width, height, text, value, min, max, "##.##");
        }

        public InfoBar(int x, int y, int width, int height, class_2561 text, float value, float min, float max, String format) {
            super(x, y, width, height, (class_2561)class_2561.method_43473());
            max = Math.max(value, max);
            min = Math.min(value, min);
            this.textWidget = new ScrollingTextWidget(x, y, textWidth, text, class_5253.class_5254.method_27764((int)255, (int)255, (int)255, (int)255));
            this.statBar = new StatBar(x + textWidth + spacer, y + 3, barWitdh, 2, class_5253.class_5254.method_27764((int)255, (int)0, (int)0, (int)0));
            DecimalFormat modifierFormat = (DecimalFormat)class_156.method_654((Object)new DecimalFormat(format), decimalFormat -> decimalFormat.setDecimalFormatSymbols(DecimalFormatSymbols.getInstance(Locale.ROOT)));
            float primaryPercent = (value - min) / (max - min);
            this.statBar.setPrimary(primaryPercent, class_5253.class_5254.method_27764((int)255, (int)255, (int)255, (int)255));
            this.statBar.setSecondary(primaryPercent, class_5253.class_5254.method_27764((int)255, (int)255, (int)255, (int)255));
            this.valueHolder = new ScrollingTextWidget(x + textWidth + barWitdh + spacer * 2, y, width - textWidth + barWitdh, (class_2561)class_2561.method_43470((String)modifierFormat.format(value)), class_5253.class_5254.method_27764((int)255, (int)255, (int)255, (int)255));
            this.addChild(this.textWidget);
            this.addChild(this.statBar);
            this.addChild(this.valueHolder);
        }

        @Override
        public void method_48579(class_332 drawContext, int mouseX, int mouseY, float delta) {
            this.textWidget.method_46421(this.method_46426());
            this.textWidget.method_46419(this.method_46427());
            this.statBar.method_46421(this.method_46426() + textWidth);
            this.statBar.method_46419(this.method_46427() + 3);
            this.valueHolder.method_46421(this.method_46426() + textWidth + barWitdh + spacer * 2);
            this.valueHolder.method_46419(this.method_46427());
            super.method_48579(drawContext, mouseX, mouseY, delta);
        }
    }
}

