/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.client.gui.crafting.crafter.glint;

import com.redpxnda.nucleus.math.MathUtil;
import com.redpxnda.nucleus.util.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_437;
import smartin.miapi.client.gui.InteractAbleWidget;
import smartin.miapi.client.gui.ScrollList;
import smartin.miapi.client.gui.SimpleButton;
import smartin.miapi.client.gui.crafting.CraftingScreen;
import smartin.miapi.client.gui.crafting.crafter.glint.AlphaSlider;
import smartin.miapi.client.gui.crafting.crafter.glint.ColorPickerWidget;
import smartin.miapi.client.gui.crafting.crafter.glint.FloatWidgetField;
import smartin.miapi.client.gui.crafting.crafter.glint.HueSlider;
import smartin.miapi.config.MiapiConfig;
import smartin.miapi.modules.edit_options.EditOption;
import smartin.miapi.modules.properties.GlintProperty;

@Environment(value=EnvType.CLIENT)
public class GlintEditView
extends InteractAbleWidget {
    public static final class_2960 TEXTURE = CraftingScreen.BACKGROUND_TEXTURE;
    private final ScrollList scrollList;
    List<InteractAbleWidget> colorButtons = new ArrayList<InteractAbleWidget>();
    Consumer<List<Color>> preview;
    AlphaSlider speedSlider;
    float rainbowSpeed;
    EditOption.EditContext option;
    FloatWidgetField floatWidgetField;
    static float maxSpeed = 4.0f;

    public GlintEditView(int x, int y, int width, int height, EditOption.EditContext editContext, Consumer<GlintProperty.RainbowGlintSettings> onChange, Consumer<GlintProperty.RainbowGlintSettings> onCraft) {
        super(x, y, width, height, (class_2561)class_2561.method_43473());
        this.option = editContext;
        GlintProperty.RainbowGlintSettings oldSettings = GlintProperty.property.getData(editContext.getItemstack()).orElse(GlintProperty.defaultSettings);
        this.preview = list -> onChange.accept(this.glintSettings(oldSettings, (List<Color>)list));
        ArrayList<Color> colors = new ArrayList<Color>(Arrays.stream(oldSettings.colors).toList());
        if (colors.isEmpty()) {
            colors.add(Color.RED);
        }
        ArrayList<InteractAbleWidget> widgets = new ArrayList<InteractAbleWidget>();
        this.scrollList = new ScrollList(this.method_46426(), this.method_46427(), this.method_25368(), this.method_25364() - 20, widgets);
        this.addChild(this.scrollList);
        this.scrollList.alwaysEnableScrollbar = true;
        this.floatWidgetField = new FloatWidgetField(class_310.method_1551().field_1772, this.method_46426() + 60, this.method_46427() + this.method_25364() - 13, 30, 10, 0.0f, 128.0f, (class_2561)class_2561.method_43473(), f -> {
            this.updateSpeed(onChange, (Float)f, oldSettings);
            this.speedSlider.value = Math.clamp(f.floatValue() / maxSpeed, 0.0f, 1.0f);
        }, "");
        this.addChild(this.floatWidgetField);
        SimpleButton<Void> plusButton2 = new SimpleButton<Void>(0, 0, 50, 10, (class_2561)class_2561.method_43470((String)"+"), null, callback -> {
            Color newColor = Color.RED;
            this.addColorToScrollList(newColor);
            this.preview.accept(this.getColors());
        });
        this.colorButtons.add(plusButton2);
        for (Color color : colors) {
            this.addColorToScrollList(color);
        }
        this.scrollList.setList(this.colorButtons);
        this.speedSlider = new AlphaSlider(this.method_46426() + 3, this.method_46427() + this.method_25364() - 12, 50, 6, f -> {
            this.updateSpeed(onChange, Float.valueOf(f.floatValue() * maxSpeed), oldSettings);
            this.floatWidgetField.setValue(f.floatValue() * maxSpeed);
        });
        this.floatWidgetField.setValue(oldSettings.rainbowSpeed);
        this.speedSlider.value = Math.clamp(oldSettings.rainbowSpeed / maxSpeed, 0.0f, 1.0f);
        this.addChild((class_364)this.speedSlider);
        SimpleButton<Void> applyButton = new SimpleButton<Void>(this.method_46426() + this.method_25368() - 50, this.method_46427() + this.method_25364() - 18, 40, 16, (class_2561)class_2561.method_43470((String)"Apply"), null, callback -> onCraft.accept(this.glintSettings(oldSettings, this.getColors())));
        this.addChild(applyButton);
    }

    private void updateSpeed(Consumer<GlintProperty.RainbowGlintSettings> onChange, Float f, GlintProperty.RainbowGlintSettings oldSettings) {
        GlintProperty.RainbowGlintSettings settings = this.glintSettings(oldSettings, this.getColors());
        this.rainbowSpeed = settings.rainbowSpeed = f.floatValue();
        onChange.accept(settings);
    }

    public List<Color> getColors() {
        return this.colorButtons.stream().filter(SingleColorEdit.class::isInstance).map(a -> ((SingleColorEdit)a).currentColor).toList();
    }

    private void addColorToScrollList(Color color) {
        SingleColorEdit singleColorEdit = new SingleColorEdit(0, 0, this.method_25368() - 20, (class_2561)class_2561.method_43470((String)"Color"), color, (button, updatedColor) -> {
            int index = this.colorButtons.indexOf(button);
            if (index != -1) {
                this.preview.accept(this.getColors());
            }
        });
        this.colorButtons.add(Math.max(0, this.scrollList.widgets.size() - 1), singleColorEdit);
        this.scrollList.setList(this.colorButtons);
    }

    @Override
    public boolean method_25403(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        return super.method_25403(mouseX, mouseY, button, deltaX, deltaY);
    }

    public GlintProperty.RainbowGlintSettings glintSettings(GlintProperty.RainbowGlintSettings oldSettings, List<Color> list) {
        oldSettings = oldSettings.copyWithColor(list);
        oldSettings.rainbowSpeed = this.rainbowSpeed;
        oldSettings.isItem = this.option.getInstance() == null;
        return oldSettings;
    }

    @Override
    public void method_48579(class_332 drawContext, int mouseX, int mouseY, float delta) {
        drawContext.method_25291(TEXTURE, this.method_46426(), this.method_46427() + this.method_25364() - 18, 0, 0.0f, 387.0f, 92, 16, 512, 512);
        super.method_48579(drawContext, mouseX, mouseY, delta);
        if ((this.debug || MiapiConfig.getServerConfig().other.developmentMode) && class_437.method_25443()) {
            GlintEditView.drawSquareBorder(drawContext, this.method_46426(), this.method_46427(), this.method_25368(), this.method_25364(), 1, this.randomColor);
        }
    }

    protected class SingleColorEdit
    extends InteractAbleWidget {
        private final ColorPickerWidget colorPicker;
        private final HueSlider hueSlider;
        private final SimpleButton<Void> removeButton;
        private final SimpleButton<Void> toggleButton;
        private boolean isExpanded;
        public Color currentColor;

        public SingleColorEdit(int x, int y, int width, class_2561 title, Color initialColor, BiConsumer<SingleColorEdit, Color> onColorChange) {
            super(x, y, width, 13, title);
            this.isExpanded = false;
            initialColor.setAlpha(255);
            this.currentColor = initialColor;
            this.colorPicker = new ColorPickerWidget(class_310.method_1551().field_1772, x + 10, y + 25, selectedColor -> {
                this.currentColor = selectedColor;
                onColorChange.accept(this, (Color)selectedColor);
            });
            this.colorPicker.setColor(initialColor);
            this.colorPicker.field_22764 = false;
            this.removeButton = new SimpleButton<Void>(x + width - 3, y + 1, 11, 11, (class_2561)class_2561.method_43470((String)"X"), null, callback -> {
                GlintEditView.this.colorButtons.remove((Object)this);
                GlintEditView.this.scrollList.setList(GlintEditView.this.colorButtons);
            });
            this.addChild(this.removeButton);
            this.toggleButton = new SimpleButton<Void>(x + width - 16, y + 1, 11, 11, (class_2561)class_2561.method_43470((String)"..."), null, callback -> {
                this.colorPicker.field_22764 = this.isExpanded = !this.isExpanded;
                this.method_53533(this.isExpanded ? 13 + this.colorPicker.method_25364() : 13);
                if (this.isExpanded) {
                    this.addChild(this.colorPicker);
                } else {
                    this.removeChild(this.colorPicker);
                }
            });
            this.hueSlider = new HueSlider(x + 16, y + 3, x + this.method_25368() - 30, 8, a -> this.colorPicker.setColorAndUpdate(a.floatValue(), this.colorPicker.colorGrid.saturation, this.colorPicker.colorGrid.lightness));
            float[] hsl = MathUtil.rgbToHsv((int)this.currentColor.r(), (int)this.currentColor.g(), (int)this.currentColor.b());
            this.hueSlider.value = MathUtil.method_15363((float)(hsl[0] / 360.0f), (float)0.0f, (float)1.0f);
            this.addChild((class_364)this.hueSlider);
            this.addChild(this.toggleButton);
        }

        public void method_46421(int x) {
            this.removeButton.method_46421(x + this.field_22758 - 3 - 8);
            this.toggleButton.method_46421(x + this.field_22758 - 16 - 8);
            this.colorPicker.method_46421(x + 5);
            this.hueSlider.method_46421(x + 16);
            super.method_46421(x);
        }

        public void method_46419(int y) {
            this.removeButton.method_46419(y);
            this.toggleButton.method_46419(y);
            this.colorPicker.method_46419(y + 12);
            this.hueSlider.method_46419(y + 3);
            super.method_46419(y);
        }

        @Override
        public void method_48579(class_332 drawContext, int mouseX, int mouseY, float delta) {
            drawContext.method_25294(this.method_46426() + 1, this.method_46427() + 1, this.method_46426() + 10, this.method_46427() + 10, this.currentColor.argb());
            super.method_48579(drawContext, mouseX, mouseY, delta);
        }

        @Override
        public boolean method_25403(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
            return super.method_25403(mouseX, mouseY, button, deltaX, deltaY);
        }

        @Override
        public boolean method_25402(double mouseX, double mouseY, int button) {
            for (class_364 child : this.children()) {
                if (!child.method_25402(mouseX, mouseY, button)) continue;
                return true;
            }
            return false;
        }
    }
}

