/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.client.gui.crafting.slotdisplay;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1059;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_308;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_6379;
import net.minecraft.class_811;
import net.minecraft.class_918;
import org.joml.Matrix4fStack;
import org.joml.Vector3f;
import smartin.miapi.client.gui.InteractAbleWidget;
import smartin.miapi.modules.properties.slot.SlotProperty;

@Environment(value=EnvType.CLIENT)
public class SlotDisplay
extends InteractAbleWidget {
    private final Map<SlotProperty.ModuleSlot, ModuleButton> buttonMap = new HashMap<SlotProperty.ModuleSlot, ModuleButton>();
    private class_1799 stack;
    private class_4587 slotProjection = new class_4587();
    private double lastMouseX;
    private double lastMouseY;
    private boolean mouseDown0 = false;
    private boolean mouseDown1 = false;
    private SlotProperty.ModuleSlot selected = null;
    private final Consumer<SlotProperty.ModuleSlot> setSelected;
    private SlotProperty.ModuleSlot baseSlot;

    public SlotDisplay(class_1799 stack, int x, int y, int height, int width, Consumer<SlotProperty.ModuleSlot> selected) {
        super(x, y, width, height, (class_2561)class_2561.method_43470((String)"Item Display"));
        this.stack = stack;
        this.field_22759 = height;
        this.field_22758 = width;
        this.slotProjection.method_22905(1.0f, -1.0f, 1.0f);
        this.setSelected = selected;
        this.setBaseSlot(new SlotProperty.ModuleSlot(new ArrayList<String>()));
    }

    @Override
    public void method_16014(double mouseX, double mouseY) {
        if (this.mouseDown0) {
            this.handleLeftClickDrag(mouseX, mouseY, this.lastMouseX - mouseX, this.lastMouseY - mouseY);
        } else if (this.mouseDown1) {
            this.handleRightClickDrag(mouseX, mouseY, this.lastMouseX - mouseX, this.lastMouseY - mouseY);
        }
        this.lastMouseX = mouseX;
        this.lastMouseY = mouseY;
    }

    @Override
    public boolean method_25405(double x, double y) {
        boolean mouseOver;
        boolean bl = mouseOver = x >= (double)this.method_46426() && y >= (double)this.method_46427() && x < (double)(this.method_46426() + this.field_22758) && y < (double)(this.method_46427() + this.field_22759);
        if (mouseOver) {
            return true;
        }
        this.mouseDown0 = false;
        this.mouseDown1 = false;
        return super.method_25405(x, y);
    }

    @Override
    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (button == 0 && this.method_25405(mouseX, mouseY)) {
            this.mouseDown0 = true;
        } else if (button == 1 && this.method_25405(mouseX, mouseY)) {
            this.mouseDown1 = true;
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    @Override
    public boolean method_25406(double mouseX, double mouseY, int button) {
        if (button == 0) {
            this.mouseDown0 = false;
        } else if (button == 1) {
            this.mouseDown1 = false;
        }
        return super.method_25406(mouseX, mouseY, button);
    }

    private void handleLeftClickDrag(double mouseX, double mouseY, double deltaX, double deltaY) {
        class_4587 newStack = new class_4587();
        newStack.method_46416((float)(-deltaX) / 100.0f, -((float)deltaY) / 100.0f, 0.0f);
        newStack.method_34425(this.slotProjection.method_23760().method_23761());
        this.slotProjection = newStack;
    }

    private void handleRightClickDrag(double mouseX, double mouseY, double deltaX, double deltaY) {
        float angleX = (float)(-(deltaY * (double)0.02f));
        float angleY = (float)(-(deltaX * (double)0.02f));
        class_4587 newStack = new class_4587();
        newStack.method_23760().method_23761().rotateAffineXYZ(-angleX, angleY, 0.0f);
        newStack.method_34425(this.slotProjection.method_23760().method_23761());
        this.slotProjection = newStack;
    }

    @Override
    public boolean method_25401(double mouseX, double mouseY, double scrollX, double scrollY) {
        if (this.method_25405(mouseX, mouseY)) {
            double scale = Math.pow(2.0, scrollY / 10.0);
            this.slotProjection.method_22905((float)scale, (float)scale, (float)scale);
            return true;
        }
        return super.method_25401(mouseX, mouseY, scrollX, scrollY);
    }

    public void setBaseSlot(SlotProperty.ModuleSlot baseSlot1) {
        this.baseSlot = baseSlot1;
        this.buttonMap.forEach((slot1, moduleButton) -> this.children().remove(moduleButton));
        this.buttonMap.clear();
        if (this.baseSlot != null && this.baseSlot.inSlot != null) {
            this.baseSlot.inSlot.allSubModules().forEach(moduleInstances -> SlotProperty.getSlots(moduleInstances).forEach((number, slot) -> this.buttonMap.computeIfAbsent((SlotProperty.ModuleSlot)slot, newSlot -> {
                ModuleButton newButton = new ModuleButton(0, 0, 10, 10, (SlotProperty.ModuleSlot)newSlot);
                this.addChild(newButton);
                return newButton;
            })));
            this.buttonMap.computeIfAbsent(this.baseSlot, newSlot -> {
                ModuleButton newButton = new ModuleButton(0, 0, 10, 10, (SlotProperty.ModuleSlot)newSlot);
                this.addChild(newButton);
                return newButton;
            });
        }
    }

    public void setItem(class_1799 itemStack) {
        this.stack = itemStack;
        this.slotProjection = new class_4587();
        this.slotProjection.method_22905(1.0f, -1.0f, 1.0f);
        this.selected = new SlotProperty.ModuleSlot(new ArrayList<String>());
    }

    public int getSize() {
        int size = Math.min(this.field_22758, this.field_22759);
        size = Math.max(5, size - 10);
        return size;
    }

    @Override
    public void method_48579(class_332 drawContext, int mouseX, int mouseY, float delta) {
        drawContext.method_44379(this.method_46426(), this.method_46427(), this.method_46426() + this.field_22758, this.method_46427() + this.field_22759);
        this.renderSlot(this.stack, drawContext, mouseX, mouseY, delta);
        super.method_48579(drawContext, mouseX, mouseY, delta);
        drawContext.method_44380();
    }

    public void select(SlotProperty.ModuleSlot selected) {
        this.selected = selected;
    }

    private Vector3f position() {
        return new Vector3f((float)this.method_46426() + (float)(this.field_22758 - 16) / 2.0f, (float)this.method_46427() + (float)(this.field_22759 - 16) / 2.0f, 150.0f);
    }

    public void renderSlot(class_1799 stack, class_332 context, int mouseX, int mouseY, float delta) {
        class_918 renderer = class_310.method_1551().method_1480();
        class_310.method_1551().method_1531().method_4619(class_1059.field_5275).method_4527(false, false);
        RenderSystem.setShaderTexture((int)0, (class_2960)class_1059.field_5275);
        RenderSystem.enableBlend();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Matrix4fStack matrixStack = RenderSystem.getModelViewStack();
        matrixStack.pushMatrix();
        Vector3f pos = this.position();
        matrixStack.translate(pos.x(), pos.y(), pos.z());
        matrixStack.scale((float)this.getSize(), (float)this.getSize(), 1.0f);
        RenderSystem.applyModelViewMatrix();
        class_4597.class_4598 immediate = class_310.method_1551().method_22940().method_23000();
        boolean bl = true;
        if (bl) {
            class_308.method_24210();
        }
        RenderSystem.enableDepthTest();
        renderer.method_23178(stack, class_811.field_4317, 0xF000F0, class_4608.field_21444, this.slotProjection, (class_4597)immediate, (class_1937)class_310.method_1551().field_1687, 0);
        immediate.method_22993();
        RenderSystem.enableDepthTest();
        if (bl) {
            class_308.method_24211();
        }
        matrixStack.popMatrix();
        RenderSystem.applyModelViewMatrix();
    }

    public class_6379.class_6380 method_37018() {
        return class_6379.class_6380.field_33784;
    }

    public class ModuleButton
    extends InteractAbleWidget {
        private static final class_2960 ButtonTexture = class_2960.method_60655((String)"miapi", (String)"textures/button.png");
        public SlotProperty.ModuleSlot instance;

        public ModuleButton(int x, int y, int width, int height, SlotProperty.ModuleSlot instance) {
            super(x, y, width, height, (class_2561)class_2561.method_43470((String)" "));
            this.instance = instance;
        }

        private void setSelected(SlotProperty.ModuleSlot instance) {
            SlotDisplay.this.selected = instance;
            SlotDisplay.this.setSelected.accept(instance);
        }

        @Override
        public void method_48579(class_332 drawContext, int mouseX, int mouseY, float delta) {
            RenderSystem.depthFunc((int)519);
            RenderSystem.disableDepthTest();
            this.renderButton(drawContext, mouseX, mouseY, delta);
            RenderSystem.enableDepthTest();
            RenderSystem.depthFunc((int)515);
        }

        @Override
        public boolean method_25402(double mouseX, double mouseY, int button) {
            if (this.method_25405(mouseX, mouseY)) {
                this.playClickedSound();
                this.setSelected(this.instance);
                return true;
            }
            return super.method_25402(mouseX, mouseY, button);
        }

        public void renderButton(class_332 drawContext, int mouseX, int mouseY, float delta) {
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)this.field_22765);
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            RenderSystem.enableDepthTest();
            int textureSize = 30;
            int textureOffset = 0;
            if (this.instance.equals(SlotDisplay.this.selected)) {
                textureOffset = 20;
            } else if (this.method_25405(mouseX, mouseY)) {
                textureOffset = 10;
            }
        }
    }
}

