/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.client.gui.crafting.statdisplay;

import com.google.common.collect.Multimap;
import com.mojang.datafixers.util.Either;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Collection;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.WeakHashMap;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1304;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_156;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.class_9274;
import net.minecraft.class_9285;
import net.minecraft.class_9334;
import smartin.miapi.Miapi;
import smartin.miapi.client.gui.crafting.statdisplay.SingleStatDisplayDouble;
import smartin.miapi.client.gui.crafting.statdisplay.StatListWidget;
import smartin.miapi.modules.properties.attributes.AttributeProperty;
import smartin.miapi.modules.properties.attributes.AttributeUtil;
import smartin.miapi.modules.properties.util.DoubleOperationResolvable;

@Environment(value=EnvType.CLIENT)
public class AttributeSingleDisplay
extends SingleStatDisplayDouble {
    public static Set<class_1320> attributesWithDisplay = new HashSet<class_1320>();
    public static Map<class_1304, Multimap<class_1320, class_1322>> oldItemCache = new WeakHashMap<class_1304, Multimap<class_1320, class_1322>>();
    public static Map<class_1304, Multimap<class_1320, class_1322>> compareItemCache = new WeakHashMap<class_1304, Multimap<class_1320, class_1322>>();
    public class_1322.class_1323 operation = class_1322.class_1323.field_6328;
    final class_1320 attribute;
    final class_1304 slot;
    double defaultValue;
    public SingleStatDisplayDouble.StatReaderHelper valueReader = new SingleStatDisplayDouble.StatReaderHelper(){

        @Override
        public double getValue(class_1799 itemStack) {
            return AttributeSingleDisplay.this.getValueFunction(itemStack);
        }

        @Override
        public boolean hasValue(class_1799 itemStack) {
            return AttributeSingleDisplay.this.hasAttribute(itemStack);
        }
    };

    private AttributeSingleDisplay(class_1320 attribute, class_1304 slot, StatListWidget.TextGetter text, StatListWidget.TextGetter hover, double defaultValue, DecimalFormat modifierFormat) {
        super(0, 0, 51, 19, text, hover);
        attributesWithDisplay.add(attribute);
        this.slot = slot;
        this.attribute = attribute;
        this.defaultValue = defaultValue;
        this.modifierFormat = modifierFormat;
    }

    @Override
    public double getValue(class_1799 stack) {
        double value = this.valueReader.getValue(stack);
        if (!this.valueReader.hasValue(stack) || Double.isNaN(value)) {
            return this.attribute.method_6169();
        }
        return value;
    }

    public double getValueFunction(class_1799 stack) {
        Map<class_1304, Multimap<class_1320, class_1322>> attributeCache = compareItemCache;
        if (stack.equals(this.original)) {
            attributeCache = oldItemCache;
        }
        if (this.slot == null) {
            Double value = null;
            for (class_1304 equipmentSlot : class_1304.values()) {
                Multimap<class_1320, class_1322> currentSlot = attributeCache.get(equipmentSlot);
                if (!attributeCache.get(equipmentSlot).containsKey((Object)this.attribute)) continue;
                switch (this.operation) {
                    case field_6328: {
                        value = this.defaultValue;
                        for (class_1322 modifier : currentSlot.get((Object)this.attribute).stream().filter(a -> a.comp_2450().equals((Object)this.operation)).toList()) {
                            value = value + modifier.comp_2449();
                        }
                        return value;
                    }
                    case field_6330: {
                        value = 0.0;
                        for (class_1322 modifier : currentSlot.get((Object)this.attribute).stream().filter(a -> a.comp_2450().equals((Object)class_1322.class_1323.field_6330)).toList()) {
                            value = value + modifier.comp_2449();
                        }
                        for (class_1322 modifier : currentSlot.get((Object)this.attribute).stream().filter(a -> a.comp_2450().equals((Object)class_1322.class_1323.field_6331)).toList()) {
                            value = (value + 1.0) * (modifier.comp_2449() + 1.0) - 1.0;
                        }
                        return value * 100.0;
                    }
                    case field_6331: {
                        value = 1.0;
                        for (class_1322 modifier : currentSlot.get((Object)this.attribute).stream().filter(a -> a.comp_2450().equals((Object)this.operation)).toList()) {
                            value = value * modifier.comp_2449();
                        }
                        return value * 100.0;
                    }
                }
            }
            return this.defaultValue;
        }
        return AttributeUtil.getActualValue(attributeCache.get(this.slot), this.attribute, this.defaultValue);
    }

    @Override
    public boolean shouldRender(class_1799 original, class_1799 compareTo) {
        super.shouldRender(original, compareTo);
        if (this.valueReader.hasValue(original)) {
            return true;
        }
        return this.valueReader.hasValue(compareTo);
    }

    public boolean hasAttribute(class_1799 itemStack) {
        return ((class_9285)itemStack.method_57825(class_9334.field_49636, (Object)class_9285.field_49326)).comp_2393().stream().anyMatch(a -> ((class_1320)a.comp_2395().comp_349()).equals(this.attribute) && a.comp_2396().comp_2449() != 0.0 && (a.comp_2396().comp_2450().equals((Object)this.operation) || this.operation.equals((Object)class_1322.class_1323.field_6330) && a.comp_2396().comp_2450().equals((Object)class_1322.class_1323.field_6331)));
    }

    public boolean hasValue(Collection<class_1322> list) {
        list = list.stream().filter(attribute -> attribute.comp_2450().equals((Object)this.operation)).toList();
        if (this.operation.equals((Object)class_1322.class_1323.field_6328)) {
            double value = AttributeUtil.getActualValue(list, this.attribute.method_6169());
            return value != this.attribute.method_6169() && !Double.isNaN(value);
        }
        return !list.isEmpty();
    }

    @Override
    public DoubleOperationResolvable getResolvable(class_1799 stack) {
        Optional optional = AttributeProperty.property.getData(stack);
        if (optional.isPresent()) {
            Map resolvableMap;
            Map operationMap;
            Map attributeMap = (Map)optional.get();
            class_2960 attributeKey = class_7923.field_41190.method_10221((Object)this.attribute);
            if (attributeKey != null && (operationMap = (Map)attributeMap.get(attributeKey)) != null && (resolvableMap = (Map)operationMap.get(this.operation)) != null) {
                for (Map.Entry entry : resolvableMap.entrySet()) {
                    Either either = (Either)entry.getKey();
                    if (!either.left().isPresent()) continue;
                    class_9274 group = (class_9274)either.left().get();
                    if (this.slot != null && !group.method_57286(this.slot)) continue;
                    return (DoubleOperationResolvable)entry.getValue();
                }
            }
        }
        return null;
    }

    public static Builder builder(class_6880<class_1320> attribute) {
        return new Builder(attribute);
    }

    public static class Builder {
        class_6880<class_1320> attribute;
        public class_1304 slot;
        public double defaultValue = 1.0;
        public StatListWidget.TextGetter name;
        public StatListWidget.TextGetter hoverDescription = stack -> class_2561.method_43473();
        public String translationKey = "";
        public Object[] descriptionArgs = new Object[0];
        public DecimalFormat modifierFormat;
        public double min = 0.0;
        public double max = 100.0;
        public boolean inverse = false;
        public ValueGetter valueGetter;

        private Builder(class_6880<class_1320> attribute) {
            this.attribute = attribute;
            if (attribute != null) {
                this.name = itemStack -> class_2561.method_43471((String)((class_1320)attribute.comp_349()).method_26830());
            }
            this.modifierFormat = (DecimalFormat)class_156.method_654((Object)new DecimalFormat("##.##"), decimalFormat -> decimalFormat.setDecimalFormatSymbols(DecimalFormatSymbols.getInstance(Locale.ROOT)));
            this.defaultValue = ((class_1320)attribute.comp_349()).method_6169();
            this.max = Math.min(2048.0, ((class_1320)attribute.comp_349()).method_6165(Double.MAX_VALUE));
            this.min = Math.max(-2048.0, ((class_1320)attribute.comp_349()).method_6165(Double.MIN_VALUE));
        }

        public Builder setMax(double maxValue) {
            this.max = maxValue;
            return this;
        }

        public Builder setMin(double minValue) {
            this.min = minValue;
            return this;
        }

        public Builder setDefault(double defaultValue) {
            this.defaultValue = defaultValue;
            return this;
        }

        public Builder setTranslationKey(String key) {
            this.translationKey = key;
            this.name = stack -> class_2561.method_43471((String)("miapi.stat." + key));
            this.hoverDescription = stack -> class_2561.method_43469((String)("miapi.stat." + key + ".description"), (Object[])this.descriptionArgs);
            return this;
        }

        public Builder setName(class_2561 name) {
            this.name = stack -> name;
            return this;
        }

        public Builder setName(StatListWidget.TextGetter name) {
            this.name = name;
            return this;
        }

        public Builder inverseNumber(boolean inverse) {
            this.inverse = inverse;
            return this;
        }

        public Builder setSlot(class_1304 slot) {
            this.slot = slot;
            return this;
        }

        public Builder setHoverDescription(class_2561 hoverDescription) {
            this.hoverDescription = stack -> hoverDescription;
            return this;
        }

        public Builder setHoverDescription(StatListWidget.TextGetter hoverDescription) {
            this.hoverDescription = hoverDescription;
            return this;
        }

        public Builder setFormat(String format) {
            this.modifierFormat = (DecimalFormat)class_156.method_654((Object)new DecimalFormat(format), decimalFormat -> decimalFormat.setDecimalFormatSymbols(DecimalFormatSymbols.getInstance(Locale.ROOT)));
            return this;
        }

        public Builder setValueGetter(ValueGetter reader) {
            this.valueGetter = reader;
            return this;
        }

        public AttributeSingleDisplay[] build() {
            AttributeSingleDisplay[] displays = new AttributeSingleDisplay[2];
            if (this.name == null) {
                throw new IllegalStateException("Name is required");
            }
            if (this.attribute == null) {
                Miapi.LOGGER.error("Attribute is required for Attribute Stat Display!");
                return new AttributeSingleDisplay[0];
            }
            final AttributeSingleDisplay display = new AttributeSingleDisplay((class_1320)this.attribute.comp_349(), this.slot, this.name, this.hoverDescription, this.defaultValue, this.modifierFormat);
            display.minValue = this.min;
            display.maxValue = this.max;
            display.setInverse(this.inverse);
            if (this.valueGetter != null) {
                display.valueReader = new SingleStatDisplayDouble.StatReaderHelper(){

                    @Override
                    public double getValue(class_1799 itemStack) {
                        return valueGetter.getValue(itemStack);
                    }

                    @Override
                    public boolean hasValue(class_1799 itemStack) {
                        return display.hasAttribute(itemStack);
                    }
                };
            }
            display.operation = class_1322.class_1323.field_6328;
            displays[0] = display;
            final AttributeSingleDisplay displayMulBase = new AttributeSingleDisplay((class_1320)this.attribute.comp_349(), this.slot, this.name, this.hoverDescription, this.defaultValue, this.modifierFormat);
            displayMulBase.minValue = 0.0;
            displayMulBase.maxValue = 100.0;
            displayMulBase.setInverse(this.inverse);
            if (this.valueGetter != null) {
                displayMulBase.valueReader = new SingleStatDisplayDouble.StatReaderHelper(){

                    @Override
                    public double getValue(class_1799 itemStack) {
                        return valueGetter.getValue(itemStack);
                    }

                    @Override
                    public boolean hasValue(class_1799 itemStack) {
                        return displayMulBase.hasAttribute(itemStack);
                    }
                };
            }
            displayMulBase.operation = class_1322.class_1323.field_6330;
            displayMulBase.postfix = class_2561.method_43470((String)"%");
            displays[1] = displayMulBase;
            final AttributeSingleDisplay displayMulTotal = new AttributeSingleDisplay((class_1320)this.attribute.comp_349(), this.slot, this.name, this.hoverDescription, this.defaultValue, this.modifierFormat);
            displayMulTotal.minValue = 0.0;
            displayMulTotal.maxValue = 100.0;
            displayMulTotal.setInverse(this.inverse);
            if (this.valueGetter != null) {
                displayMulTotal.valueReader = new SingleStatDisplayDouble.StatReaderHelper(){

                    @Override
                    public double getValue(class_1799 itemStack) {
                        return valueGetter.getValue(itemStack);
                    }

                    @Override
                    public boolean hasValue(class_1799 itemStack) {
                        return displayMulTotal.hasAttribute(itemStack);
                    }
                };
            }
            displayMulTotal.operation = class_1322.class_1323.field_6331;
            displayMulTotal.postfix = class_2561.method_43470((String)"%");
            return displays;
        }

        static interface ValueGetter {
            public double getValue(class_1799 var1);
        }
    }
}

