/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.client.gui.crafting.statdisplay;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import java.util.function.BiFunction;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1322;
import net.minecraft.class_156;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import smartin.miapi.Miapi;
import smartin.miapi.client.gui.crafting.statdisplay.SingleStatDisplayDouble;
import smartin.miapi.client.gui.crafting.statdisplay.StatListWidget;
import smartin.miapi.modules.properties.util.DoubleOperationResolvable;
import smartin.miapi.modules.properties.util.DoubleProperty;

@Environment(value=EnvType.CLIENT)
public class SinglePropertyStatDisplay
extends SingleStatDisplayDouble {
    protected DoubleProperty property;
    public BiFunction<class_1799, class_1799, Boolean> condition = (old, compare) -> true;

    protected SinglePropertyStatDisplay(StatListWidget.TextGetter title, StatListWidget.TextGetter hover, DoubleProperty property) {
        super(0, 0, 51, 19, title, hover);
        this.property = property;
    }

    @Override
    public boolean shouldRender(class_1799 original, class_1799 compareTo) {
        super.shouldRender(original, compareTo);
        if (!this.condition.apply(original, compareTo).booleanValue()) {
            return false;
        }
        return this.property.getValue(original).isPresent() || this.property.getValue(compareTo).isPresent();
    }

    @Override
    public double getValue(class_1799 stack) {
        return this.property.getValue(stack).orElse(0.0);
    }

    @Override
    public DoubleOperationResolvable getResolvable(class_1799 stack) {
        return this.property.getData(stack).orElse(null);
    }

    public static String stringForOperation(DecimalFormat format, DoubleOperationResolvable.Operation resolvable) {
        String number = format.format(resolvable.solve());
        String operation = SinglePropertyStatDisplay.getStringName(resolvable.attributeOperation);
        if (operation.equals("+") && number.startsWith("-")) {
            return number + " " + resolvable.instance.getModuleName().getString();
        }
        return operation + number + " " + resolvable.instance.getModuleName().getString();
    }

    public static String getStringName(class_1322.class_1323 operation) {
        return switch (operation) {
            default -> throw new MatchException(null, null);
            case class_1322.class_1323.field_6328 -> "+";
            case class_1322.class_1323.field_6330 -> "*";
            case class_1322.class_1323.field_6331 -> "**";
        };
    }

    public static Builder builder(DoubleProperty property) {
        return new Builder(property);
    }

    public static class Builder {
        DoubleProperty property;
        public StatListWidget.TextGetter name;
        public StatListWidget.TextGetter hoverDescription = stack -> class_2561.method_43473();
        public String translationKey = "";
        public Object[] descriptionArgs = new Object[0];
        public DecimalFormat modifierFormat;
        public DecimalFormat hoverFormat;
        public double min = 0.0;
        public double max = 100.0;
        public boolean inverse = false;
        public BiFunction<class_1799, class_1799, Boolean> condition = (old, compare) -> true;

        private Builder(DoubleProperty property) {
            this.property = property;
            this.modifierFormat = (DecimalFormat)class_156.method_654((Object)new DecimalFormat("##.##"), decimalFormat -> decimalFormat.setDecimalFormatSymbols(DecimalFormatSymbols.getInstance(Locale.ROOT)));
        }

        public Builder setInverse(boolean inverse) {
            this.inverse = inverse;
            return this;
        }

        public Builder setCondition(BiFunction<class_1799, class_1799, Boolean> condition) {
            this.condition = condition;
            return this;
        }

        public Builder setMax(double maxValue) {
            this.max = maxValue;
            return this;
        }

        public Builder setMin(double minValue) {
            this.min = minValue;
            return this;
        }

        public Builder setName(class_2561 name) {
            this.name = stack -> name;
            return this;
        }

        public Builder setName(StatListWidget.TextGetter name) {
            this.name = name;
            return this;
        }

        public Builder setTranslationKey(class_2960 key) {
            this.translationKey = Miapi.toLangString(key);
            this.name = stack -> class_2561.method_43469((String)("miapi.stat." + this.translationKey), (Object[])new Object[]{this.modifierFormat.format(this.property.getValue(stack).orElse(0.0))});
            this.hoverDescription = stack -> class_2561.method_43469((String)("miapi.stat." + this.translationKey + ".description"), (Object[])new Object[]{this.modifierFormat.format(this.property.getValue(stack).orElse(0.0))});
            return this;
        }

        public Builder setHoverDescription(class_2561 hoverDescription) {
            this.hoverDescription = stack -> hoverDescription;
            return this;
        }

        public Builder setHoverDescription(StatListWidget.TextGetter hoverDescription) {
            this.hoverDescription = hoverDescription;
            return this;
        }

        public Builder setFormat(String format) {
            this.modifierFormat = (DecimalFormat)class_156.method_654((Object)new DecimalFormat(format), decimalFormat -> decimalFormat.setDecimalFormatSymbols(DecimalFormatSymbols.getInstance(Locale.ROOT)));
            return this;
        }

        public Builder setHoverFormat(String format) {
            this.hoverFormat = (DecimalFormat)class_156.method_654((Object)new DecimalFormat(format), decimalFormat -> decimalFormat.setDecimalFormatSymbols(DecimalFormatSymbols.getInstance(Locale.ROOT)));
            return this;
        }

        public SinglePropertyStatDisplay build() {
            if (this.name == null) {
                throw new IllegalStateException("Name is required");
            }
            if (this.property == null) {
                throw new IllegalStateException("Property is required");
            }
            SinglePropertyStatDisplay display = new SinglePropertyStatDisplay(this.name, this.hoverDescription, this.property);
            display.maxValue = this.max;
            display.minValue = this.min;
            display.modifierFormat = this.modifierFormat;
            display.inverse = this.inverse;
            display.condition = this.condition;
            if (this.hoverFormat == null) {
                this.hoverFormat = this.modifierFormat;
            }
            display.hoverFormat = this.hoverFormat;
            return display;
        }
    }
}

