/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.datapack;

import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.UnboundedMapCodec;
import dev.architectury.event.events.common.PlayerEvent;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3222;
import net.minecraft.class_5455;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import org.jetbrains.annotations.Nullable;
import smartin.miapi.Environment;
import smartin.miapi.Miapi;
import smartin.miapi.network.Networking;
import smartin.miapi.registries.MiapiRegistry;

public class ReloadEvents {
    public static MiapiRegistry<DataSyncer> dataSyncerRegistry = MiapiRegistry.getInstance(DataSyncer.class);
    private static final List<String> receivedSyncer = new ArrayList<String>();
    protected static final String RELOAD_PACKET_ID = "miapi:events_reload_s2c";
    public static final Map<class_2960, String> DATA_PACKS = Collections.synchronizedMap(new LinkedHashMap());
    public static final Map<class_2960, String> RAW_DATA_PACKS = Collections.synchronizedMap(new LinkedHashMap());
    public static Map<String, List<String>> syncedPaths = new HashMap<String, List<String>>();
    public static final ReloadEvent START = new ReloadEvent();
    public static final ReloadEvent MAIN = new ReloadEvent();
    public static final ReloadEvent END = new ReloadEvent();
    public static int reloadCounter = 0;
    private static long clientReloadTimeStart = System.nanoTime();

    public static void registerDataPackPathToSync(String modId, String path) {
        syncedPaths.computeIfAbsent(modId, k -> new ArrayList()).add(path);
    }

    public static void setup() {
        if (Environment.isClient()) {
            ReloadEvents.clientSetup();
        }
        Networking.registerC2SPacket(RELOAD_PACKET_ID, (buf, serverPlayerEntity) -> {
            Miapi.DEBUG_LOGGER.info("Recieved reload request from client!" + String.valueOf(serverPlayerEntity.method_5667()) + "! sending reload! " + Thread.currentThread().getName());
            boolean allowHandshake = buf.readBoolean();
            if (!allowHandshake) {
                Miapi.LOGGER.warn("Client " + String.valueOf(serverPlayerEntity.method_5667()) + " rejected reload? this should never happen!");
                Miapi.server.method_43496((class_2561)class_2561.method_43470((String)("Client " + String.valueOf(serverPlayerEntity.method_5476()) + " failed to reload.")));
            } else {
                ReloadEvents.triggerReloadOnClient(serverPlayerEntity);
            }
        });
        UnboundedMapCodec codec = Codec.unboundedMap((Codec)class_2960.field_25139, Miapi.CHUNKED_STRING_CODEC);
        class_9139 streamCodec = class_9135.method_56368((Codec)codec);
        dataSyncerRegistry.register(Miapi.id("data_packs"), (DataSyncer)new SimpleSyncer<Map<class_2960, String>>(streamCodec){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Map<class_2960, String> getDataServer() {
                LinkedHashMap<class_2960, String> toSend;
                Map<class_2960, String> map = DATA_PACKS;
                synchronized (map) {
                    toSend = new LinkedHashMap<class_2960, String>(DATA_PACKS);
                }
                return toSend;
            }

            @Override
            public void interpretData(Map<class_2960, String> data) {
                class_310.method_1551().execute(() -> {
                    Map<class_2960, String> map = DATA_PACKS;
                    synchronized (map) {
                        DATA_PACKS.clear();
                        DATA_PACKS.putAll(data);
                    }
                    DataPackLoader.trigger(data);
                });
            }
        });
        PlayerEvent.PLAYER_JOIN.register(ReloadEvents::triggerReloadOnClient);
        START.subscribe((isClient, registryAccess) -> ++reloadCounter);
        END.subscribe((isClient, registryAccess) -> --reloadCounter);
        DataPackLoader.subscribe(dataPack -> {
            Map<class_2960, String> map = DATA_PACKS;
            synchronized (map) {
                DATA_PACKS.clear();
                DATA_PACKS.putAll(dataPack);
            }
        });
    }

    public static void triggerReloadOnClient(class_3222 entity) {
        dataSyncerRegistry.getFlatMap().forEach((id, syncer) -> {
            class_2540 buf = Networking.createBuffer();
            buf.method_10814(id.toString());
            try {
                buf.method_10813(syncer.createDataServer().array());
                Networking.sendS2C(RELOAD_PACKET_ID, entity, buf);
            }
            catch (RuntimeException e) {
                Miapi.LOGGER.error("Datasyncer " + String.valueOf(id) + " was not able to create Packet with error ", (Throwable)e);
            }
        });
    }

    public static boolean isInReload() {
        return reloadCounter != 0;
    }

    private static void clientSetup() {
        Networking.registerS2CPacket(RELOAD_PACKET_ID, buffer -> {
            if (receivedSyncer.isEmpty()) {
                clientReloadTimeStart = System.nanoTime();
            }
            String receivedID = buffer.method_19772();
            receivedSyncer.add(receivedID);
            class_2540 dataBuffer = Networking.createBuffer();
            dataBuffer.method_52983(buffer.method_10795());
            try {
                dataSyncerRegistry.get(receivedID).interpretDataClient(dataBuffer);
            }
            catch (RuntimeException exception) {
                Miapi.LOGGER.error("Exception during Reload Networking!", (Throwable)exception);
            }
            if (receivedSyncer.size() == dataSyncerRegistry.getFlatMap().keySet().size()) {
                receivedSyncer.clear();
                class_310.method_1551().execute(() -> {
                    ++reloadCounter;
                    Object access = class_310.method_1551().field_1687 != null ? class_310.method_1551().field_1687.method_30349() : class_310.method_1551().method_1562().method_29091();
                    START.fireEvent(true, (class_5455)access);
                    MAIN.fireEvent(true, (class_5455)access);
                    END.fireEvent(true, (class_5455)access);
                    --reloadCounter;
                    Miapi.LOGGER.info("Client load took " + (double)(System.nanoTime() - clientReloadTimeStart) / 1000.0 / 1000.0 + " ms");
                });
            }
        });
    }

    public static class ReloadEvent {
        private final Map<EventListener, Float> mainListeners = new HashMap<EventListener, Float>();

        public void subscribe(EventListener listener, float priority) {
            this.mainListeners.put(listener, Float.valueOf(priority));
        }

        public void subscribe(EventListener listener) {
            this.subscribe(listener, 0.0f);
        }

        public void unsubscribe(EventListener listener) {
            this.mainListeners.remove(listener);
        }

        public void fireEvent(boolean isClient, @Nullable class_5455 registryAccess) {
            try {
                this.mainListeners.entrySet().stream().sorted(Map.Entry.comparingByValue()).forEach(eventListenerFloatEntry -> {
                    try {
                        ((EventListener)eventListenerFloatEntry.getKey()).onEvent(isClient, registryAccess);
                    }
                    catch (RuntimeException e) {
                        Miapi.LOGGER.error("Exception during reload", (Throwable)e);
                    }
                });
            }
            catch (RuntimeException e) {
                Miapi.LOGGER.error("Exception during Reload!", (Throwable)e);
            }
        }
    }

    @FunctionalInterface
    public static interface EventListener {
        public void onEvent(boolean var1, @Nullable class_5455 var2);
    }

    public static class DataPackLoader {
        protected static final List<EventListener> listeners = new ArrayList<EventListener>();

        public static void subscribe(EventListener listener) {
            listeners.add(listener);
        }

        public static void unsubscribe(EventListener listener) {
            listeners.remove(listener);
        }

        public static void trigger(Map<class_2960, String> dataPack) {
            for (EventListener listener : listeners) {
                try {
                    listener.onEvent(dataPack);
                }
                catch (Exception e) {
                    Miapi.LOGGER.error("Exception during reload", (Throwable)e);
                }
            }
        }

        public static interface EventListener {
            public void onEvent(Map<class_2960, String> var1);
        }
    }

    public static interface DataSyncer<T> {
        public class_2540 createDataServer();

        public void interpretDataClient(class_2540 var1);
    }

    public static abstract class SimpleSyncer<T>
    implements DataSyncer {
        public class_9139<ByteBuf, T> streamCodec;

        public SimpleSyncer(class_9139<ByteBuf, T> streamCodec) {
            this.streamCodec = streamCodec;
        }

        public abstract T getDataServer();

        public abstract void interpretData(T var1);

        @Override
        public class_2540 createDataServer() {
            class_2540 buf = Networking.createBuffer();
            this.streamCodec.encode((Object)buf, this.getDataServer());
            return buf;
        }

        @Override
        public void interpretDataClient(class_2540 buf) {
            this.interpretData(this.streamCodec.decode((Object)buf));
        }
    }
}

