/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.editor;

import com.redpxnda.nucleus.editor.core.ClientLoader;
import imgui.ImGui;
import imgui.type.ImBoolean;
import imgui.type.ImString;
import java.io.File;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_332;
import net.minecraft.class_9779;
import smartin.miapi.editor.FileSystemViewer;
import smartin.miapi.editor.LiveDataPackManager;
import smartin.miapi.editor.MiapiEditor;
import smartin.miapi.modules.cache.CacheCommands;

public class LiveDataPackEditorManager
implements MiapiEditor {
    private final LiveDataPackManager manager;
    private FileSystemViewer fileSystemViewer;
    private final ImBoolean show = new ImBoolean(true);
    private final ImBoolean showCreateWindow = new ImBoolean(false);
    private final ImString newPackName = new ImString(256);
    private final ImString newPackId = new ImString(256);
    private final ImString newPackAuthor = new ImString(256);
    private final ImString newPackDescription = new ImString(1024);
    private final ImBoolean newPackEnabled = new ImBoolean(true);
    private LiveDataPackManager.DataPackContext editingContext;
    private final ImString editName = new ImString(256);
    private final ImString editId = new ImString(256);
    private final ImString editAuthor = new ImString(256);
    private final ImString editDescription = new ImString(256);
    private final ImString editDataPath = new ImString(1024);
    private final ImBoolean editWatchFiles = new ImBoolean(true);

    public LiveDataPackEditorManager() {
        this.manager = LiveDataPackManager.getInstance();
    }

    private void clearNewPackFields() {
        this.newPackName.clear();
        this.newPackId.clear();
        this.newPackAuthor.clear();
        this.newPackDescription.clear();
        this.newPackEnabled.set(true);
    }

    @Override
    public void render(class_332 guiGraphics, class_9779 deltaTracker) {
        if (!this.show.get()) {
            return;
        }
        ImGui.setNextWindowSize((float)400.0f, (float)600.0f, (int)4);
        if (ImGui.begin((String)"LivePack Manager", (ImBoolean)this.show)) {
            if (ImGui.button((String)"Create New Pack")) {
                this.showCreateWindow.set(true);
                this.clearNewPackFields();
            }
            ImGui.sameLine();
            if (ImGui.button((String)"Refresh")) {
                this.manager.scanForDataPacks();
            }
            ImGui.sameLine();
            if (ImGui.button((String)"Reload")) {
                this.reload();
            }
            ImGui.separator();
            List<LiveDataPackManager.DataPackContext> packContexts = this.manager.getLoadedPacks();
            for (LiveDataPackManager.DataPackContext pack : packContexts) {
                if (!ImGui.treeNode((String)(pack.name + " (" + pack.id + ")"))) continue;
                ImGui.text((String)("Directory: " + pack.directory.getName()));
                if (this.editingContext == pack) {
                    if (ImGui.inputText((String)"Name", (ImString)this.editName)) {
                        pack.name = this.editName.get();
                    }
                    if (ImGui.inputText((String)"ID", (ImString)this.editId)) {
                        pack.id = this.editId.get().toLowerCase();
                    }
                    if (ImGui.inputText((String)"Author", (ImString)this.editAuthor)) {
                        pack.author = this.editAuthor.get();
                    }
                    if (ImGui.inputTextMultiline((String)"Description", (ImString)this.editDescription)) {
                        pack.description = this.editDescription.get();
                    }
                    if (ImGui.inputText((String)"Data Path", (ImString)this.editDataPath)) {
                        pack.dataPath = this.editDataPath.get();
                    }
                    if (ImGui.checkbox((String)"Watch Files", (ImBoolean)this.editWatchFiles)) {
                        pack.watchFiles = this.editWatchFiles.get();
                        if (pack.watchFiles) {
                            this.manager.watchDataPack(pack);
                        } else {
                            this.manager.unwatchDataPack(pack);
                        }
                    }
                    if (ImGui.checkbox((String)"Enabled", (boolean)pack.enabled)) {
                        boolean bl = pack.enabled = !pack.enabled;
                    }
                    if (ImGui.button((String)"Save")) {
                        this.manager.saveContext(pack);
                        this.editingContext = null;
                    }
                    ImGui.sameLine();
                    if (ImGui.button((String)"Cancel")) {
                        this.editingContext = null;
                    }
                } else {
                    ImGui.text((String)("ID: " + pack.id));
                    ImGui.text((String)("Author: " + pack.author));
                    ImGui.text((String)("Description: " + pack.description));
                    ImGui.text((String)("Data Path: " + pack.dataPath));
                    ImGui.text((String)("Watch Files: " + (pack.watchFiles ? "Yes" : "No")));
                    ImGui.text((String)("Enabled: " + (pack.enabled ? "Yes" : "No")));
                    if (ImGui.button((String)"Edit")) {
                        this.editingContext = pack;
                        this.editName.set(pack.name);
                        this.editId.set(pack.id);
                        this.editAuthor.set(pack.author);
                        this.editDescription.set(pack.description);
                        this.editDataPath.set(pack.dataPath);
                        this.editWatchFiles.set(pack.watchFiles);
                    }
                }
                ImGui.sameLine();
                if (ImGui.button((String)"Open Files")) {
                    File dataDir;
                    if (this.fileSystemViewer != null) {
                        ClientLoader.RENDER.remove(this.fileSystemViewer);
                    }
                    if (!(dataDir = new File(pack.directory, pack.dataPath)).exists()) {
                        dataDir.mkdirs();
                    }
                    this.fileSystemViewer = new FileSystemViewer(dataDir, file -> this.reload());
                    MiapiEditor.editors.add(this.fileSystemViewer);
                }
                ImGui.sameLine();
                if (ImGui.button((String)"Delete")) {
                    this.manager.deletePack(pack);
                    if (this.fileSystemViewer != null && Objects.equals(this.fileSystemViewer.getRootDirectory(), pack.directory)) {
                        ClientLoader.RENDER.remove(this.fileSystemViewer);
                        this.fileSystemViewer = null;
                    }
                }
                ImGui.treePop();
            }
            ImGui.end();
        }
        if (this.showCreateWindow.get()) {
            ImGui.setNextWindowSize((float)400.0f, (float)300.0f, (int)4);
            if (ImGui.begin((String)"Create New DataPack", (ImBoolean)this.showCreateWindow)) {
                boolean canCreate;
                ImGui.inputText((String)"Pack Name", (ImString)this.newPackName);
                ImGui.inputText((String)"Pack ID (lowercase)", (ImString)this.newPackId);
                if (!this.newPackId.get().toLowerCase().equals(this.newPackId.get())) {
                    this.newPackId.set(this.newPackId.get().toLowerCase());
                }
                ImGui.inputText((String)"Author", (ImString)this.newPackAuthor);
                ImGui.inputTextMultiline((String)"Description", (ImString)this.newPackDescription);
                ImGui.checkbox((String)"Enabled", (ImBoolean)this.newPackEnabled);
                boolean bl = canCreate = !this.newPackName.get().trim().isEmpty() && !this.newPackId.get().trim().isEmpty() && !this.newPackAuthor.get().trim().isEmpty();
                if (!canCreate) {
                    ImGui.textColored((float)1.0f, (float)0.0f, (float)0.0f, (float)1.0f, (String)"Please fill in all required fields");
                }
                if (ImGui.button((String)"Create") && canCreate) {
                    this.manager.createNewPack(this.newPackName.get().trim(), this.newPackId.get().trim(), this.newPackAuthor.get().trim(), this.newPackDescription.get().trim(), this.newPackEnabled.get());
                    this.showCreateWindow.set(false);
                    this.clearNewPackFields();
                }
                ImGui.sameLine();
                if (ImGui.button((String)"Cancel")) {
                    this.showCreateWindow.set(false);
                    this.clearNewPackFields();
                }
            }
            ImGui.end();
        }
    }

    public void reload() {
        CacheCommands.triggerServerReload();
    }
}

