/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.editor;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import dev.architectury.event.EventResult;
import dev.architectury.platform.Platform;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import net.fabricmc.api.EnvType;
import net.minecraft.class_2960;
import smartin.miapi.Miapi;
import smartin.miapi.editor.EditorEvents;
import smartin.miapi.editor.JsonEditor;
import smartin.miapi.editor.MiapiEditor;
import smartin.miapi.editor.syntax.EditorInterface;
import smartin.miapi.events.MiapiEvents;
import smartin.miapi.modules.cache.CacheCommands;
import smartin.miapi.modules.conditions.ConditionManager;
import smartin.miapi.modules.properties.util.EditorError;

public class LiveDataPackManager
implements AutoCloseable {
    private static final String RUNTIME_FOLDER = "miapi_runtime_datapacks";
    private static final String CONTEXT_FILE = "miapi-editor-context.json";
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static LiveDataPackManager INSTANCE;
    private final List<DataPackContext> loadedPacks = new ArrayList<DataPackContext>();
    private final File runtimeFolder;
    private WatchService watchService;
    private final Map<WatchKey, DataPackContext> watchKeys = new HashMap<WatchKey, DataPackContext>();
    public List<MiapiEditor> openedEditors = new ArrayList<MiapiEditor>();

    public static void setup() {
        MiapiEvents.PLAYER_TICK_END.register(player -> {
            if (Platform.getEnv() == EnvType.CLIENT && Miapi.server != null && INSTANCE != null) {
                INSTANCE.checkAndValidateDatapacks();
            }
            return EventResult.pass();
        });
        MiapiEvents.ADJUST_RAW_DATA.register(event -> {
            if (Platform.getEnv() == EnvType.CLIENT && Miapi.server != null) {
                LiveDataPackManager.getInstance().processDataPacks(event);
            }
            return EventResult.pass();
        });
    }

    public static LiveDataPackManager getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new LiveDataPackManager();
        }
        return INSTANCE;
    }

    private LiveDataPackManager() {
        this.runtimeFolder = this.getRuntimeFolder();
        if (!this.runtimeFolder.exists()) {
            this.runtimeFolder.mkdirs();
        }
        this.setupFileWatcher();
        this.scanForDataPacks();
    }

    private File getRuntimeFolder() {
        return Platform.getGameFolder().resolve(RUNTIME_FOLDER).toFile();
    }

    private void setupFileWatcher() {
        try {
            this.watchService = this.runtimeFolder.toPath().getFileSystem().newWatchService();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void watchDataPack(DataPackContext context) {
        this.watchDataPack(context, new File(context.directory, context.dataPath));
    }

    public void watchDataPack(DataPackContext context, File dataDir) {
        if (!context.watchFiles) {
            return;
        }
        try {
            if (dataDir.exists() && dataDir.isDirectory()) {
                WatchKey key = dataDir.toPath().register(this.watchService, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_MODIFY, StandardWatchEventKinds.ENTRY_DELETE);
                this.watchKeys.put(key, context);
                if (dataDir.isDirectory()) {
                    Arrays.stream(dataDir.listFiles(File::isDirectory)).forEach(f -> this.watchDataPack(context, (File)f));
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void unwatchDataPack(DataPackContext context) {
        this.watchKeys.entrySet().removeIf(entry -> {
            if (entry.getValue() == context) {
                ((WatchKey)entry.getKey()).cancel();
                return true;
            }
            return false;
        });
    }

    private boolean checkFileChanges() {
        if (this.watchService == null) {
            return false;
        }
        boolean changeOccured = false;
        try {
            DataPackContext context;
            WatchKey key = this.watchService.poll();
            if (key != null && (context = this.watchKeys.get(key)) != null && context.watchFiles) {
                for (WatchEvent<?> event : key.pollEvents()) {
                    Path changed = (Path)event.context();
                    if (!changed.toString().endsWith(".json")) continue;
                    changeOccured = true;
                }
                key.reset();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return changeOccured;
    }

    public void scanForDataPacks() {
        this.loadedPacks.forEach(this::unwatchDataPack);
        this.watchKeys.clear();
        this.loadedPacks.clear();
        File[] directories = this.runtimeFolder.listFiles(File::isDirectory);
        if (directories != null) {
            for (File dir : directories) {
                DataPackContext context = this.loadOrCreateContext(dir);
                this.loadedPacks.add(context);
                this.watchDataPack(context);
            }
        }
    }

    public DataPackContext createNewPack(String name, String id, String author, String description, boolean enabled) {
        File newDir;
        id = id.toLowerCase();
        if (!(name.isEmpty() || id.isEmpty() || (newDir = new File(this.runtimeFolder, id)).exists())) {
            newDir.mkdirs();
            DataPackContext context = this.createDefaultContext(newDir);
            context.name = name;
            context.id = id;
            context.author = author;
            context.description = description;
            context.enabled = enabled;
            context.dataPath = "data";
            this.saveContext(context);
            this.loadedPacks.add(context);
            this.watchDataPack(context);
            return context;
        }
        return null;
    }

    public void deletePack(DataPackContext context) {
        try {
            this.unwatchDataPack(context);
            this.deleteDirectory(context.directory);
            this.loadedPacks.remove(context);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void deleteDirectory(File directory) throws IOException {
        File[] files = directory.listFiles();
        if (files != null) {
            for (File file : files) {
                if (file.isDirectory()) {
                    this.deleteDirectory(file);
                    continue;
                }
                Files.delete(file.toPath());
            }
        }
        Files.delete(directory.toPath());
    }

    private DataPackContext loadOrCreateContext(File directory) {
        DataPackContext context;
        File contextFile = new File(directory, CONTEXT_FILE);
        if (contextFile.exists()) {
            try {
                String json = Files.readString(contextFile.toPath());
                context = (DataPackContext)GSON.fromJson(json, DataPackContext.class);
                context.directory = directory;
                context.repair();
            }
            catch (IOException e) {
                e.printStackTrace();
                context = this.createDefaultContext(directory);
            }
        } else {
            context = this.createDefaultContext(directory);
        }
        this.saveContext(context);
        return context;
    }

    private DataPackContext createDefaultContext(File directory) {
        DataPackContext context = new DataPackContext();
        context.name = directory.getName();
        context.id = directory.getName().toLowerCase();
        context.author = "Unknown";
        context.description = "A MIAPI runtime datapack";
        context.enabled = true;
        context.dataPath = "data";
        context.directory = directory;
        return context;
    }

    public void saveContext(DataPackContext context) {
        try {
            File contextFile = new File(context.directory, CONTEXT_FILE);
            String json = GSON.toJson((Object)context);
            Files.writeString(contextFile.toPath(), (CharSequence)json, new OpenOption[0]);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void processDataPacks(MiapiEvents.ReloadEventData event) {
        for (DataPackContext context : this.loadedPacks) {
            File dataDir;
            if (!context.enabled || !context.passedValidation || !(dataDir = new File(context.directory, context.dataPath)).exists() || !dataDir.isDirectory()) continue;
            try {
                Stream<Path> paths = Files.walk(dataDir.toPath(), new FileVisitOption[0]);
                try {
                    paths.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(path -> path.toString().endsWith(".json")).forEach(path -> {
                        try {
                            class_2960 location = this.getResourceLocation(dataDir.toPath(), (Path)path);
                            String content = Files.readString(path);
                            if (this.shouldLoadJson(Files.readString(path))) {
                                event.data.put(location, content);
                            }
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    });
                }
                finally {
                    if (paths == null) continue;
                    paths.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private boolean shouldLoadJson(String content) {
        try {
            JsonObject element = (JsonObject)Miapi.gson.fromJson(content, JsonObject.class);
            if (!element.has("load_condition")) {
                return true;
            }
            boolean allowed = ConditionManager.get(element.get("load_condition")).isAllowed(new ConditionManager.ConditionContext(this){

                @Override
                public ConditionManager.ConditionContext copy() {
                    return this;
                }
            });
            if (allowed) {
                element.remove("load_condition");
                return true;
            }
            return false;
        }
        catch (Exception e) {
            return true;
        }
    }

    private void checkAndValidateDatapacks() {
        if (!this.checkFileChanges()) {
            return;
        }
        this.openedEditors.forEach(miapiEditor -> {
            if (miapiEditor instanceof Closeable) {
                Closeable closeable = (Closeable)((Object)miapiEditor);
                try {
                    closeable.close();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            MiapiEditor.editors.remove(miapiEditor);
        });
        for (DataPackContext context : this.loadedPacks) {
            if (!context.enabled) continue;
            context.passedValidation = true;
            File dataDir = new File(context.directory, context.dataPath);
            if (!dataDir.exists() || !dataDir.isDirectory()) {
                dataDir.mkdirs();
                continue;
            }
            try {
                Stream<Path> paths = Files.walk(dataDir.toPath(), new FileVisitOption[0]);
                try {
                    paths.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(path -> path.toString().endsWith(".json")).forEach(path -> {
                        File file = path.toFile();
                        String relativePath = dataDir.toPath().relativize((Path)path).toString();
                        if (!context.isFileValid(relativePath, file)) {
                            try {
                                String pathWithoutExt = relativePath.replace(".json", "").replace("\\", "/");
                                pathWithoutExt = pathWithoutExt.replaceFirst("/", ":");
                                class_2960 resourceLocation = Miapi.id(pathWithoutExt);
                                String data = Files.readString(file.toPath());
                                if (this.shouldLoadJson(data)) {
                                    JsonEditor editor = new JsonEditor(Files.readString(file.toPath()), f -> {}, (Path)path, resourceLocation);
                                    editor.resourceLocation = resourceLocation;
                                    editor.closeOnNoError = true;
                                    MiapiEditor.editors.add(editor);
                                    this.openedEditors.add(editor);
                                }
                            }
                            catch (RuntimeException e) {
                                Miapi.LOGGER.warn("", (Throwable)e);
                            }
                            catch (IOException e) {
                                Miapi.LOGGER.warn("", (Throwable)e);
                            }
                            context.passedValidation = false;
                        }
                    });
                }
                finally {
                    if (paths == null) continue;
                    paths.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        CacheCommands.triggerServerReload();
    }

    private class_2960 getResourceLocation(Path dataDir, Path filePath) {
        Path relativePath = dataDir.relativize(filePath);
        if (relativePath.getNameCount() < 2) {
            return null;
        }
        String namespace = relativePath.getName(0).toString().toLowerCase();
        String path = relativePath.subpath(1, relativePath.getNameCount()).toString().replace('\\', '/').toLowerCase();
        return class_2960.method_43902((String)namespace, (String)path);
    }

    public List<DataPackContext> getLoadedPacks() {
        return new ArrayList<DataPackContext>(this.loadedPacks);
    }

    @Override
    public void close() {
        if (this.watchService != null) {
            try {
                this.watchService.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static class DataPackContext {
        public String name;
        public String id;
        public String author;
        public String description;
        public boolean enabled;
        public String dataPath;
        public boolean watchFiles = true;
        public transient File directory;
        public transient boolean passedValidation = true;
        public transient Map<String, ValidationCache> validatedFiles = new HashMap<String, ValidationCache>();

        public void repair() {
            if (this.dataPath == null) {
                this.dataPath = "data";
            }
            if (this.validatedFiles == null) {
                this.validatedFiles = new HashMap<String, ValidationCache>();
            }
        }

        public boolean isFileValid(String relativePath, File file) {
            ValidationCache cache = this.validatedFiles.get(relativePath);
            if (cache == null || cache.lastModified != file.lastModified()) {
                try {
                    String pathWithoutExt = relativePath.replace(".json", "").replace("\\", "/");
                    pathWithoutExt = pathWithoutExt.replaceFirst("/", ":");
                    class_2960 resourceLocation = Miapi.id(pathWithoutExt);
                    ArrayList<EditorInterface> interfaces = new ArrayList<EditorInterface>();
                    ((EditorEvents.EditorInterfaceEvent)EditorEvents.EDITOR_INTERFACES.invoker()).onGetInterfaces(new EditorEvents.EditorInterfaceData(resourceLocation, file.getPath(), interfaces));
                    String content = Files.readString(file.toPath());
                    JsonElement json = JsonParser.parseString((String)content);
                    boolean isValid = true;
                    for (EditorInterface iface : interfaces) {
                        List<EditorError> errors = iface.validateContent(json, content);
                        if (errors.stream().anyMatch(error -> error.severity() == EditorError.ErrorSeverity.ERROR)) {
                            isValid = false;
                            break;
                        }
                        if (!errors.stream().anyMatch(error -> error.severity() == EditorError.ErrorSeverity.WARNING)) continue;
                        isValid = false;
                        break;
                    }
                    long lastModified = Files.getLastModifiedTime(file.toPath(), new LinkOption[0]).toMillis();
                    cache = new ValidationCache(lastModified, isValid);
                    this.validatedFiles.put(relativePath, cache);
                }
                catch (Exception e) {
                    long lastModified = 0L;
                    try {
                        lastModified = Files.getLastModifiedTime(file.toPath(), new LinkOption[0]).toMillis();
                    }
                    catch (IOException ex) {
                        Miapi.LOGGER.warn("", (Throwable)ex);
                    }
                    cache = new ValidationCache(lastModified, false);
                    this.validatedFiles.put(relativePath, cache);
                }
            }
            return cache != null && cache.isValid;
        }

        private boolean validateFile(String relativePath, File file) {
            try {
                String content = Files.readString(file.toPath());
                JsonParser.parseString((String)content);
                return true;
            }
            catch (Exception e) {
                return false;
            }
        }
    }

    private record ValidationCache(long lastModified, boolean isValid) {
    }
}

