/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.editor.material;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.mojang.datafixers.util.Pair;
import imgui.ImGui;
import java.util.ArrayList;
import smartin.miapi.blueprint.IngredientWithCount;
import smartin.miapi.editor.util.JsonEditor;
import smartin.miapi.material.CodecMaterial;
import smartin.miapi.modules.properties.util.CodecProperty;

public class IngredientEditor {
    private final CodecMaterial material;
    private final JsonEditor jsonEditor;

    public IngredientEditor(CodecMaterial material) {
        this.material = material;
        JsonArray ingredients = new JsonArray();
        material.items.forEach(item -> ingredients.add((JsonElement)IngredientWithCount.CODEC.encodeStart(CodecProperty.getOps(), item).getOrThrow()));
        this.jsonEditor = new JsonEditor("Ingredients", (JsonElement)ingredients);
    }

    public void render() {
        this.jsonEditor.render();
        ArrayList<IngredientWithCount> ingredient = new ArrayList<IngredientWithCount>(this.material.items);
        try {
            JsonArray array = this.jsonEditor.getValue().getAsJsonArray();
            ingredient.clear();
            array.forEach(element -> ingredient.add((IngredientWithCount)((Pair)IngredientWithCount.CODEC.decode(CodecProperty.getOps(), element).getOrThrow()).getFirst()));
            this.material.items = ingredient;
        }
        catch (Exception e) {
            ImGui.text((String)("Failed to parse ingredients: " + e.getMessage()));
        }
    }
}

