/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.editor.material;

import imgui.ImGui;
import imgui.type.ImDouble;
import imgui.type.ImString;
import java.util.ArrayList;
import java.util.List;
import smartin.miapi.material.CodecMaterial;

public class StatsEditor {
    private final CodecMaterial material;
    private final List<StatEntry> stats = new ArrayList<StatEntry>();

    public StatsEditor(CodecMaterial material) {
        this.material = material;
        this.initializeStats();
    }

    private void initializeStats() {
        this.material.doubleMap.forEach((key, value) -> {
            try {
                double doubleValue = value;
                this.stats.add(new StatEntry((String)key, doubleValue));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        });
    }

    public void render() {
        if (ImGui.collapsingHeader((String)"Stats", (int)32)) {
            new ArrayList<StatEntry>(this.stats).forEach(entry -> {
                ImGui.pushID((String)entry.toString());
                ImGui.pushItemWidth((float)150.0f);
                if (ImGui.inputText((String)" Stat ", (ImString)entry.name, (int)0)) {
                    try {
                        double oldValue = this.material.getDouble(entry.name.get());
                        this.material.doubleMap.remove(entry.name.get());
                        this.material.doubleMap.put(entry.name.get(), oldValue);
                    }
                    catch (Exception e) {
                        ImGui.text((String)"Invalid stat name!");
                    }
                }
                ImGui.popItemWidth();
                ImGui.sameLine();
                ImGui.pushItemWidth((float)50.0f);
                if (ImGui.inputDouble((String)" Value ", (ImDouble)entry.value)) {
                    this.material.doubleMap.put(entry.name.get(), entry.value.get());
                }
                ImGui.popItemWidth();
                ImGui.sameLine();
                if (ImGui.button((String)"Remove")) {
                    this.stats.remove(entry);
                    this.material.doubleMap.remove(entry.name.get());
                }
                ImGui.popID();
            });
            if (ImGui.button((String)"Add Stat")) {
                String newStatName = "new_stat";
                this.material.doubleMap.put(newStatName, 0.0);
                this.stats.add(new StatEntry(newStatName, 0.0));
            }
        }
    }

    private static class StatEntry {
        final ImString name = new ImString(128);
        final ImDouble value;

        StatEntry(String name, double value) {
            this.name.set(name);
            this.value = new ImDouble(value);
        }
    }
}

