/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.editor.registry;

import imgui.ImGui;
import imgui.type.ImBoolean;
import imgui.type.ImString;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_9779;
import smartin.miapi.editor.DocPage;
import smartin.miapi.editor.MiapiEditor;
import smartin.miapi.registries.MiapiRegistry;

public class RegistryViewer<T>
implements MiapiEditor {
    protected final ImBoolean show = new ImBoolean(true);
    protected final MiapiRegistry<T> registry;
    protected final ImString searchText = new ImString(256);
    protected final ImString selectedEntry = new ImString(256);
    protected final List<Map.Entry<class_2960, T>> filteredEntries = new ArrayList<Map.Entry<class_2960, T>>();
    protected final ImBoolean showDetails = new ImBoolean(false);
    protected T selectedValue;
    protected Consumer<T> onSelect;

    public RegistryViewer(MiapiRegistry<T> registry) {
        this.registry = registry;
        this.updateFilteredEntries();
    }

    protected void updateFilteredEntries() {
        this.filteredEntries.clear();
        String search = this.searchText.get().toLowerCase();
        this.registry.getFlatMap().entrySet().stream().filter(entry -> ((class_2960)entry.getKey()).toString().toLowerCase().contains(search)).forEach(this.filteredEntries::add);
    }

    @Override
    public void render(class_332 guiGraphics, class_9779 deltaTracker) {
        if (!this.show.get()) {
            return;
        }
        ImGui.setNextWindowSize((float)800.0f, (float)600.0f, (int)4);
        if (ImGui.begin((String)this.getWindowTitle(), (ImBoolean)this.show)) {
            if (ImGui.inputText((String)"Search", (ImString)this.searchText)) {
                this.updateFilteredEntries();
            }
            ImGui.separator();
            if (ImGui.beginChild((String)"RegistryContent", (float)0.0f, (float)(-ImGui.getFrameHeightWithSpacing()), (boolean)true)) {
                for (Map.Entry<class_2960, T> entry : this.filteredEntries) {
                    if (!ImGui.treeNodeEx((String)entry.getKey().toString(), (int)0)) continue;
                    this.renderEntry(entry);
                    ImGui.treePop();
                }
            }
            ImGui.endChild();
            if (this.showDetails.get() && this.selectedValue != null) {
                ImGui.sameLine();
                if (ImGui.beginChild((String)"DetailsPanel", (float)300.0f, (float)0.0f, (boolean)true)) {
                    this.renderDetails(this.selectedValue);
                }
                ImGui.endChild();
            }
        }
        ImGui.end();
    }

    protected String getWindowTitle() {
        return "Registry " + this.registry.getName();
    }

    protected void renderEntry(Map.Entry<class_2960, T> entry) {
        this.selectedValue = entry.getValue();
        this.selectedEntry.set(entry.getKey().toString());
        if (this.onSelect != null) {
            this.onSelect.accept(this.selectedValue);
        }
        if (DocPage.PAGE_LOOKUP.containsKey(entry.getValue().getClass())) {
            DocPage page = DocPage.PAGE_LOOKUP.get(entry.getValue().getClass());
            ImGui.textColored((float)1.0f, (float)1.0f, (float)0.0f, (float)1.0f, (String)page.header);
            ImGui.separator();
            if (page.description != null && !page.description.isEmpty()) {
                for (String line : page.description.split("\n")) {
                    ImGui.textWrapped((String)line);
                }
            }
            ImGui.spacing();
            ImGui.separator();
            ImGui.text((String)"Details:");
            for (Map.Entry entry2 : page.data.entrySet()) {
                ImGui.bulletText((String)"%s: %s".formatted(entry2.getKey(), entry2.getValue()));
            }
        }
        this.showDetails.set(true);
    }

    protected void renderDetails(T value) {
    }

    public void setOnSelect(Consumer<T> onSelect) {
        this.onSelect = onSelect;
    }

    public T getSelectedValue() {
        return this.selectedValue;
    }

    public void setSelectedValue(T value) {
        class_2960 key;
        this.selectedValue = value;
        if (value != null && (key = this.registry.findKey(value)) != null) {
            this.selectedEntry.set(key.toString());
            this.showDetails.set(true);
        }
    }

    public static interface DetailSupplier<T> {
        public T details(class_2960 var1, T var2);
    }
}

