/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.editor.syntax;

import com.google.gson.JsonElement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Nullable;
import smartin.miapi.Miapi;
import smartin.miapi.editor.syntax.EditorInterface;
import smartin.miapi.modules.properties.util.EditorError;

public class JsonSyntaxHighlighter
implements EditorInterface {
    private static final class_2960 ID = Miapi.id("miapi", "json_syntax");
    private static final int STRING_COLOR = JsonSyntaxHighlighter.pack(0.0f, 0.8f, 0.0f, 1.0f);
    private static final int NUMBER_COLOR = JsonSyntaxHighlighter.pack(0.4f, 0.4f, 1.0f, 1.0f);
    private static final int KEYWORD_COLOR = JsonSyntaxHighlighter.pack(0.8f, 0.2f, 0.8f, 1.0f);
    private static final int PROPERTY_COLOR = JsonSyntaxHighlighter.pack(0.9f, 0.6f, 0.3f, 1.0f);
    private static final int BRACKET_COLOR = JsonSyntaxHighlighter.pack(0.7f, 0.7f, 0.7f, 1.0f);
    private static final Pattern STRING_PATTERN = Pattern.compile("\"(\\\\.|[^\"])*\"");
    private static final Pattern NUMBER_PATTERN = Pattern.compile("\\b-?\\d+(\\.\\d+)?([eE][+-]?\\d+)?\\b");
    private static final Pattern KEYWORD_PATTERN = Pattern.compile("\\b(true|false|null)\\b");
    private static final Pattern PROPERTY_PATTERN = Pattern.compile("\"(\\\\.|[^\"])*\"(?=\\s*:)");
    private static final Pattern BRACKET_PATTERN = Pattern.compile("[\\[\\]{}]");

    @Override
    public List<EditorError> validateContent(@Nullable JsonElement json, String rawContent) {
        ArrayList<EditorError> errors = new ArrayList<EditorError>();
        this.checkBracketMatching(rawContent, errors);
        this.checkTrailingCommas(rawContent, errors);
        this.checkPropertyColons(rawContent, errors);
        return errors;
    }

    @Override
    public Map<EditorInterface.TextRange, Integer> getSyntaxHighlighting(String content) {
        HashMap<EditorInterface.TextRange, Integer> highlighting = new HashMap<EditorInterface.TextRange, Integer>();
        this.addHighlighting(content, STRING_PATTERN, STRING_COLOR, highlighting);
        this.addHighlighting(content, NUMBER_PATTERN, NUMBER_COLOR, highlighting);
        this.addHighlighting(content, KEYWORD_PATTERN, KEYWORD_COLOR, highlighting);
        this.addHighlighting(content, PROPERTY_PATTERN, PROPERTY_COLOR, highlighting);
        this.addHighlighting(content, BRACKET_PATTERN, BRACKET_COLOR, highlighting);
        return highlighting;
    }

    @Override
    public class_2960 getId() {
        return ID;
    }

    private void addHighlighting(String content, Pattern pattern, int color, Map<EditorInterface.TextRange, Integer> highlighting) {
        Matcher matcher = pattern.matcher(content);
        while (matcher.find()) {
            highlighting.put(new EditorInterface.TextRange(matcher.start(), matcher.end()), color);
        }
    }

    private void checkBracketMatching(String content, List<EditorError> errors) {
        Stack<BracketInfo> stack = new Stack<BracketInfo>();
        int line = 1;
        for (int i = 0; i < content.length(); ++i) {
            char expected;
            char c = content.charAt(i);
            if (c == '\n') {
                ++line;
                continue;
            }
            if (c == '{' || c == '[') {
                stack.push(new BracketInfo(c, line));
                continue;
            }
            if (c != '}' && c != ']') continue;
            if (stack.isEmpty()) {
                errors.add(new EditorError(line, "Unexpected closing bracket: " + c, EditorError.ErrorSeverity.ERROR));
                continue;
            }
            BracketInfo opening = (BracketInfo)stack.pop();
            char c2 = expected = opening.bracket == '{' ? (char)'}' : ']';
            if (c == expected) continue;
            errors.add(new EditorError(line, "Mismatched brackets: Expected " + expected + " but found " + c, EditorError.ErrorSeverity.ERROR));
        }
        while (!stack.isEmpty()) {
            BracketInfo bracket = (BracketInfo)stack.pop();
            errors.add(new EditorError(bracket.line, "Unclosed bracket: " + bracket.bracket, EditorError.ErrorSeverity.ERROR));
        }
    }

    private void checkTrailingCommas(String content, List<EditorError> errors) {
        Pattern trailingComma = Pattern.compile(",\\s*[}\\]]");
        Matcher matcher = trailingComma.matcher(content);
        int line = 1;
        int lastNewline = 0;
        while (matcher.find()) {
            for (int i = lastNewline; i < matcher.start(); ++i) {
                if (content.charAt(i) != '\n') continue;
                ++line;
            }
            lastNewline = matcher.start();
            errors.add(new EditorError(line, "Trailing comma before closing bracket", EditorError.ErrorSeverity.ERROR));
        }
    }

    private void checkPropertyColons(String content, List<EditorError> errors) {
        Pattern propertyPattern = Pattern.compile("\"(\\\\.|[^\"])*\"\\s*[^:]");
        Matcher matcher = propertyPattern.matcher(content);
        int line = 1;
        int lastNewline = 0;
        while (matcher.find()) {
            int pos;
            for (pos = matcher.start(); pos > 0 && Character.isWhitespace(content.charAt(pos - 1)); --pos) {
            }
            if (pos <= 0 || content.charAt(pos - 1) != ',') continue;
            for (int i = lastNewline; i < matcher.start(); ++i) {
                if (content.charAt(i) != '\n') continue;
                ++line;
            }
            lastNewline = matcher.start();
            errors.add(new EditorError(line, "Missing colon after property name", EditorError.ErrorSeverity.ERROR));
        }
    }

    private static int pack(float r, float g, float b, float a) {
        return (int)(r * 255.0f) << 24 | (int)(g * 255.0f) << 16 | (int)(b * 255.0f) << 8 | (int)(a * 255.0f);
    }

    private record BracketInfo(char bracket, int line) {
    }
}

