/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.loot;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_117;
import net.minecraft.class_1799;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import net.minecraft.class_3481;
import net.minecraft.class_47;
import net.minecraft.class_5339;
import net.minecraft.class_5819;
import net.minecraft.class_6862;
import net.minecraft.class_7923;
import org.jetbrains.annotations.NotNull;
import smartin.miapi.Miapi;
import smartin.miapi.item.ModularItemStackConverter;
import smartin.miapi.item.modular.ModularItem;
import smartin.miapi.item.modular.items.ModularVisualOnlyItem;
import smartin.miapi.material.AllowedMaterial;
import smartin.miapi.material.CopyParentMaterialProperty;
import smartin.miapi.material.MaterialProperty;
import smartin.miapi.material.base.Material;
import smartin.miapi.modules.ItemModule;
import smartin.miapi.modules.ModuleInstance;
import smartin.miapi.modules.properties.ItemIdProperty;
import smartin.miapi.registries.RegistryInventory;

public record MaterialSwapLootFunction(class_2960 material, double lowerBounds, double upperBounds, double miningLevelFactor, double tierFactor, double hardnessFactor, double flexibilityFactor, double chance, Optional<List<class_2960>> blacklist, Optional<List<class_2960>> whitelist, boolean allowStackable) implements class_117
{
    public static MapCodec<MaterialSwapLootFunction> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)class_2960.field_25139.optionalFieldOf("material", (Object)Miapi.id("empty")).forGetter(c -> c.material), (App)Codec.DOUBLE.fieldOf("lower_bounds").orElse((Object)-3.0).forGetter(c -> c.lowerBounds), (App)Codec.DOUBLE.fieldOf("upper_bounds").orElse((Object)0.5).forGetter(c -> c.upperBounds), (App)Codec.DOUBLE.fieldOf("mining_level_factor").orElse((Object)1.0).forGetter(c -> c.miningLevelFactor), (App)Codec.DOUBLE.fieldOf("tier_factor").orElse((Object)1.0).forGetter(c -> c.tierFactor), (App)Codec.DOUBLE.fieldOf("hardness_factor").orElse((Object)1.0).forGetter(c -> c.hardnessFactor), (App)Codec.DOUBLE.fieldOf("flexibility_factor").orElse((Object)1.0).forGetter(c -> c.flexibilityFactor), (App)Codec.DOUBLE.fieldOf("chance").orElse((Object)1.0).forGetter(c -> c.chance), (App)Codec.list((Codec)class_2960.field_25139).optionalFieldOf("blacklist").forGetter(c -> c.blacklist), (App)Codec.list((Codec)class_2960.field_25139).optionalFieldOf("whitelist").forGetter(c -> c.whitelist), (App)Codec.BOOL.optionalFieldOf("allow_stackable", (Object)false).forGetter(c -> c.allowStackable())).apply((Applicative)instance, MaterialSwapLootFunction::new));

    @NotNull
    public class_5339<? extends class_117> method_29321() {
        return RegistryInventory.materialSwapLootFunctionLootItemFunctionType;
    }

    public class_1799 apply(class_1799 stack, class_47 lootContext) {
        class_1799 modular = ModularItemStackConverter.getModularVersion(stack);
        if (ModularItem.isModularItem(modular)) {
            if (modular.method_7946() && !this.allowStackable()) {
                return stack;
            }
            try {
                ModuleInstance root = ItemModule.getModules(modular);
                if (stack.method_7909() instanceof ModularVisualOnlyItem) {
                    return stack;
                }
                Material highestMaterial = MaterialProperty.getMaterial(root);
                for (ModuleInstance module : root.allSubModules()) {
                    Material otherMaterial = MaterialProperty.getMaterial(module);
                    if (highestMaterial == null) {
                        highestMaterial = otherMaterial;
                        continue;
                    }
                    if (otherMaterial == null || !(this.isHigher(highestMaterial, otherMaterial) > 0.0)) continue;
                    highestMaterial = otherMaterial;
                }
                if (this.material != null) {
                    Material fromJson = MaterialProperty.MATERIAL_REGISTRY.get(this.material);
                    if (highestMaterial == null || fromJson != null && this.isHigher(highestMaterial, fromJson) > 0.0) {
                        highestMaterial = fromJson;
                    }
                }
                try {
                    root = this.randomizeMaterialAndChildren(root, highestMaterial, lootContext.method_294());
                }
                catch (RuntimeException e) {
                    Miapi.LOGGER.error("error during material swap function", (Throwable)e);
                }
                root.writeToItem(modular);
                modular = ItemIdProperty.changeId(modular);
            }
            catch (RuntimeException e) {
                Miapi.LOGGER.error("Issue during Material Swap", (Throwable)e);
            }
        }
        return modular;
    }

    ModuleInstance randomizeMaterialAndChildren(ModuleInstance moduleInstance, Material fallBackMaterial, class_5819 randomSource) {
        if ((double)randomSource.method_43057() <= this.chance()) {
            try {
                if (CopyParentMaterialProperty.property.getData(moduleInstance).isEmpty()) {
                    moduleInstance = this.attemptRandomizeMaterial(moduleInstance, fallBackMaterial, randomSource);
                }
            }
            catch (RuntimeException runtimeException) {
                Miapi.LOGGER.error("Issue during Material Swap", (Throwable)runtimeException);
            }
        }
        LinkedHashMap<String, ModuleInstance> submodules = new LinkedHashMap<String, ModuleInstance>(moduleInstance.getSubModuleMap());
        for (Map.Entry entry : submodules.entrySet()) {
            moduleInstance.setSubModule((String)entry.getKey(), this.randomizeMaterialAndChildren((ModuleInstance)entry.getValue(), fallBackMaterial, randomSource));
            moduleInstance.clearCaches();
        }
        return moduleInstance;
    }

    ModuleInstance attemptRandomizeMaterial(ModuleInstance module, Material fallBackMaterial, class_5819 randomSource) {
        Material currentMaterial = MaterialProperty.getMaterial(module);
        if (currentMaterial == null) {
            return module;
        }
        if (AllowedMaterial.property.getData(module).isPresent() && !((AllowedMaterial.AllowedMaterialData)AllowedMaterial.property.getData(module).get()).isValid(fallBackMaterial)) {
            fallBackMaterial = currentMaterial;
        }
        Material finalFallBackMaterial = fallBackMaterial;
        List<Material> possibleSubstitutes = MaterialProperty.MATERIAL_REGISTRY.getFlatMap().values().stream().filter(m -> {
            if (m.getID().toString().contains("custom")) {
                return false;
            }
            if (this.whitelist().isPresent() && !this.whitelist().get().contains(m.getID())) {
                return false;
            }
            if (this.blacklist().isPresent() && this.blacklist().get().contains(m.getID())) {
                return false;
            }
            if (AllowedMaterial.property.getData(module).isPresent() && !((AllowedMaterial.AllowedMaterialData)AllowedMaterial.property.getData(module).get()).isValid((Material)m)) {
                return false;
            }
            double difToFallback = this.isHigher(finalFallBackMaterial, (Material)m);
            return difToFallback > this.lowerBounds && difToFallback < this.upperBounds;
        }).toList();
        int randomIndex = randomSource.method_43048(possibleSubstitutes.size() + 1);
        if (randomIndex == possibleSubstitutes.size()) {
            MaterialProperty.setMaterial(module, fallBackMaterial);
        } else {
            Material m2 = possibleSubstitutes.get(randomIndex);
            MaterialProperty.setMaterial(module, m2);
        }
        return module;
    }

    public double isHigher(Material material, Material other) {
        int otherMiningLevel;
        double difference = 0.0;
        int worstMiningLevel = MaterialSwapLootFunction.getTagSize((class_6862<class_2248>)class_3481.field_49930);
        int bestMiningLevel = MaterialSwapLootFunction.getTagSize((class_6862<class_2248>)class_3481.field_49925);
        int materialMiningLevel = MaterialSwapLootFunction.getTagSize(material.getIncorrectBlocksForDrops());
        if (materialMiningLevel != (otherMiningLevel = MaterialSwapLootFunction.getTagSize(other.getIncorrectBlocksForDrops()))) {
            double miningLevelDiff = (double)(materialMiningLevel - otherMiningLevel) / (double)(bestMiningLevel - worstMiningLevel);
            difference += miningLevelDiff * 10.0 * this.miningLevelFactor;
        }
        double tierDiff = this.isHigher(material, other, "tier", false);
        difference += tierDiff * 0.5 * this.tierFactor;
        double hardnessDiff = this.isHigher(material, other, "hardness", true);
        difference += hardnessDiff * this.hardnessFactor;
        double flexibilityDiff = this.isHigher(material, other, "flexibility", true);
        return -(difference += flexibilityDiff * 0.3 * this.flexibilityFactor);
    }

    public double isHigher(Material material, Material other, String stat, boolean canBeZero) {
        double materialHardness = material.getDouble(stat);
        double otherMaterialHardness = other.getDouble(stat);
        if (!canBeZero ? materialHardness != otherMaterialHardness && materialHardness != 0.0 && otherMaterialHardness != 0.0 : materialHardness != otherMaterialHardness) {
            return materialHardness - otherMaterialHardness;
        }
        return 0.0;
    }

    public static int getTagSize(class_6862<class_2248> tag) {
        return class_7923.field_41175.method_40266(tag).map(holders -> (int)holders.method_40239().count()).orElse(0);
    }
}

