/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.material;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.List;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import smartin.miapi.material.MaterialProperty;
import smartin.miapi.material.base.Material;
import smartin.miapi.network.Networking;

public class MaterialCommand {
    public static String SEND_MATERIAL_CLIENT = "miapi_material_debug";
    private static final SuggestionProvider<class_2168> MATERIAL_SUGGESTIONS = (context, builder) -> {
        List<String> materialOptions = MaterialCommand.getMaterialOptions();
        materialOptions.forEach(arg_0 -> ((SuggestionsBuilder)builder).suggest(arg_0));
        return builder.buildFuture();
    };

    public static void register(CommandDispatcher<class_2168> dispatcher) {
        LiteralArgumentBuilder literal = (LiteralArgumentBuilder)class_2170.method_9247((String)"miapi").then(class_2170.method_9247((String)"material").then(class_2170.method_9244((String)"material_id", (ArgumentType)StringArgumentType.word()).suggests(MATERIAL_SUGGESTIONS).executes(MaterialCommand::executeMaterialCommand)));
        LiteralArgumentBuilder getHand = (LiteralArgumentBuilder)class_2170.method_9247((String)"miapi").then(class_2170.method_9247((String)"get-hand-material").executes(MaterialCommand::getHandMaterial));
        dispatcher.register(literal);
        dispatcher.register(getHand);
    }

    private static int getHandMaterial(CommandContext<class_2168> context) {
        if (((class_2168)context.getSource()).method_43737()) {
            class_3222 player = ((class_2168)context.getSource()).method_44023();
            Material material = MaterialProperty.getMaterialFromIngredient(player.method_6047());
            if (material != null) {
                player.method_43496((class_2561)class_2561.method_43470((String)("Handheld Material " + String.valueOf(material.getID()))));
                class_2540 buf = Networking.createBuffer();
                buf.method_10814(material.getID().toString());
                Networking.sendS2C(SEND_MATERIAL_CLIENT, ((class_2168)context.getSource()).method_44023(), buf);
            } else {
                player.method_43496((class_2561)class_2561.method_43470((String)"Handheld Item is no Material"));
            }
            return 1;
        }
        ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)"Handheld Item is no Material"));
        return 0;
    }

    private static int executeMaterialCommand(CommandContext<class_2168> context) {
        String materialId = StringArgumentType.getString(context, (String)"material_id");
        List<String> materialOptions = MaterialCommand.getMaterialOptions();
        if (materialOptions.contains(materialId)) {
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)("Material ID is valid: " + materialId)), false);
            if (((class_2168)context.getSource()).method_43737()) {
                class_2540 buf = Networking.createBuffer();
                buf.method_10814(materialId);
                Networking.sendS2C(SEND_MATERIAL_CLIENT, ((class_2168)context.getSource()).method_44023(), buf);
            }
            return 1;
        }
        ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)("Invalid material ID: " + materialId)));
        return 0;
    }

    private static List<String> getMaterialOptions() {
        return MaterialProperty.MATERIAL_REGISTRY.getFlatMap().values().stream().map(Material::getStringID).toList();
    }
}

