/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.material.base;

import com.google.gson.JsonObject;
import com.mojang.serialization.MapCodec;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1799;
import net.minecraft.class_2248;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_6862;
import smartin.miapi.client.gui.crafting.crafter.replace.hover.HoverMaterialList;
import smartin.miapi.material.base.ColorController;
import smartin.miapi.material.base.IngredientController;
import smartin.miapi.material.base.PropertyController;
import smartin.miapi.material.base.StatController;
import smartin.miapi.modules.ModuleInstance;
import smartin.miapi.modules.properties.LoreProperty;

public interface Material
extends PropertyController,
ColorController,
StatController,
IngredientController {
    public static final class_2960 BASE_PALETTE_ID = class_2960.method_60655((String)"miapi", (String)"miapi_materials/base_palette");

    public class_2960 getID();

    default public String getStringID() {
        String id = this.getID().toString();
        id = id.replace(":", ".");
        id = id.replaceAll("/", ".");
        return id;
    }

    public List<String> getGroups();

    default public List<String> getGuiGroups() {
        return this.getGroups();
    }

    @Override
    default public Material getMaterial(ModuleInstance moduleInstance) {
        return this;
    }

    @Override
    default public Material getMaterialFromIngredient(class_1799 ingredient) {
        return this;
    }

    default public boolean canBeDyed() {
        return false;
    }

    public void addSmithingGroup();

    default public class_2561 getTranslation() {
        return class_2561.method_43471((String)("miapi.material." + this.getStringID()));
    }

    default public boolean generateConverters() {
        return false;
    }

    public JsonObject getDebugJson();

    public class_6862<class_2248> getIncorrectBlocksForDrops();

    default public Optional<MapCodec<? extends Material>> codec() {
        return Optional.empty();
    }

    default public List<class_2561> getDescription(boolean extended) {
        ArrayList<class_2561> lines = new ArrayList<class_2561>();
        if (extended) {
            lines.add(LoreProperty.gray((class_2561)class_2561.method_43471((String)"miapi.ui.material_desc_alt_2")));
            for (int i = 1; i < this.getGuiGroups().size(); ++i) {
                String groupId = this.getGuiGroups().get(i);
                lines.add(LoreProperty.gray((class_2561)class_2561.method_43470((String)(" - " + HoverMaterialList.getTranslation(groupId).getString()))));
            }
        }
        return lines;
    }
}

