/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.material.generated;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.redpxnda.nucleus.util.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import net.fabricmc.api.EnvType;
import net.minecraft.class_1304;
import net.minecraft.class_1320;
import net.minecraft.class_1738;
import net.minecraft.class_1741;
import net.minecraft.class_1743;
import net.minecraft.class_1766;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1829;
import net.minecraft.class_1831;
import net.minecraft.class_1832;
import net.minecraft.class_1856;
import net.minecraft.class_2248;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_3481;
import net.minecraft.class_3489;
import net.minecraft.class_5134;
import net.minecraft.class_5253;
import net.minecraft.class_6862;
import net.minecraft.class_7923;
import net.minecraft.class_811;
import org.jetbrains.annotations.Nullable;
import smartin.miapi.Environment;
import smartin.miapi.Miapi;
import smartin.miapi.material.DelegatingMaterial;
import smartin.miapi.material.MaterialIcons;
import smartin.miapi.material.MaterialProperty;
import smartin.miapi.material.base.Material;
import smartin.miapi.material.generated.GeneratedMaterialManager;
import smartin.miapi.material.generated.GeneratedMaterialPropertyManager;
import smartin.miapi.material.generated.NamingUtil;
import smartin.miapi.material.generated.TierManager;
import smartin.miapi.material.palette.FallbackColorer;
import smartin.miapi.material.palette.GrayscalePaletteColorer;
import smartin.miapi.material.palette.MaterialRenderController;
import smartin.miapi.modules.ModuleInstance;
import smartin.miapi.modules.properties.TagProperty;
import smartin.miapi.modules.properties.attributes.AttributeUtil;
import smartin.miapi.modules.properties.util.ModuleProperty;

public class GeneratedMaterial
implements Material {
    class_1799 mainIngredient = class_1799.field_8037;
    class_1856 ingredient = class_1856.field_9017;
    class_2960 key = Miapi.id("empty_material");
    List<String> groups = new ArrayList<String>();
    List<String> textureKeys = new ArrayList<String>();
    Map<String, Double> stats = new HashMap<String, Double>();
    List<class_1738> armorItems = new ArrayList<class_1738>();
    class_6862<class_2248> incorrectForTool = class_3481.field_49930;
    GrayscalePaletteColorer palette;
    @Nullable
    MaterialIcons.MaterialIcon icon;
    final class_1832 toolMaterial;
    boolean isValid = false;
    class_1829 swordItem;
    List<class_1831> toolItems;
    Optional<class_2960> smithingParent = Optional.empty();
    class_2561 name = null;
    public Map<String, Map<ModuleProperty<?>, Object>> properties = new HashMap();
    SmithingMode smithingMode = SmithingMode.NONE;
    class_1799 smithingTemplate = class_1799.field_8037;
    public static Codec<GeneratedMaterial> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_1799.field_24671.fieldOf("main_ingredient").forGetter(m -> m.mainIngredient), (App)class_1856.field_46095.fieldOf("ingredient").forGetter(m -> m.ingredient), (App)class_1799.field_24671.fieldOf("sword").forGetter(m -> m.swordItem.method_7854()), (App)Codec.list((Codec)class_1799.field_24671).fieldOf("toolItems").forGetter(m -> m.toolItems.stream().map(class_1792::method_7854).toList()), (App)class_2960.field_25139.optionalFieldOf("smithing_key").forGetter(m -> m.smithingParent), (App)class_1799.field_24671.optionalFieldOf("smithing_template", (Object)class_1799.field_8037).forGetter(m -> m.swordItem.method_7854())).apply((Applicative)instance, (itemstack, additionalIngredient, swordItem, ingredient_toolItems, smithingKey, smithingItem) -> {
        GeneratedMaterial material = new GeneratedMaterial((class_1799)itemstack, (class_1856)additionalIngredient, ((class_1829)swordItem.method_7909()).method_8022(), ingredient_toolItems.stream().map(itemStack -> (class_1831)itemStack.method_7909()).toList());
        if (smithingKey != null && smithingKey.isPresent()) {
            material.setSmithingMaterial((class_2960)smithingKey.get(), class_1856.method_8101((class_1799[])new class_1799[]{smithingItem}));
        }
        return material;
    }));

    public GeneratedMaterial(class_1799 mainIngredient, class_1856 ingredient, class_1832 sourceTier, List<class_1831> toolItems) {
        this.key = Miapi.id("generated/" + mainIngredient.method_7922() + toolItems.getFirst().method_7876());
        this.toolMaterial = sourceTier;
        this.ingredient = ingredient;
        this.toolItems = toolItems;
        this.mainIngredient = mainIngredient;
        this.groups.add(this.key.toString());
        this.textureKeys = List.of("default");
        if (mainIngredient.method_7922().contains("ingot")) {
            this.groups.add("metal");
        }
        if (mainIngredient.method_7922().contains("stone")) {
            this.groups.add("stone");
        }
        if (mainIngredient.method_7922().contains("bone")) {
            this.groups.add("bone");
        }
        if (mainIngredient.method_31573(class_3489.field_15537)) {
            this.groups.add("wood");
        }
        if (this.groups.size() == 1) {
            this.groups.add("crystal");
        }
        if (Environment.isClient()) {
            // empty if block
        }
        this.stats.put("durability", Double.valueOf(this.toolMaterial.method_8025()));
        this.stats.put("mining_speed", Double.valueOf(this.toolMaterial.method_8027()));
        this.stats.put("enchantability", Double.valueOf(this.toolMaterial.method_8026()));
        this.isValid = this.assignStats(toolItems);
    }

    public boolean assignStats(List<class_1831> toolItems) {
        class_1792 class_17922;
        List<class_1792> toolMaterials = toolItems.stream().filter(material -> this.toolMaterial.equals((Object)material.method_8022())).collect(Collectors.toList());
        Optional<class_1792> swordItemOptional = toolMaterials.stream().filter(class_1829.class::isInstance).findFirst();
        Optional<class_1792> axeItemOptional = toolMaterials.stream().filter(class_1743.class::isInstance).findFirst();
        if (swordItemOptional.isPresent() && axeItemOptional.isPresent() && (class_17922 = swordItemOptional.get()) instanceof class_1829) {
            class_1829 foundSwordItem = (class_1829)class_17922;
            class_17922 = axeItemOptional.get();
            if (class_17922 instanceof class_1766) {
                class_1766 axeItem = (class_1766)class_17922;
                this.swordItem = foundSwordItem;
                this.key = Miapi.id("generated/" + this.mainIngredient.method_7922() + this.swordItem.method_7876());
                double swordAttackDmg = AttributeUtil.getActualValue(this.swordItem.method_7854(), class_1304.field_6173, (class_1320)class_5134.field_23721.comp_349(), 0.0);
                double axeAttackDmg = AttributeUtil.getActualValue(axeItem.method_7854(), class_1304.field_6173, (class_1320)class_5134.field_23721.comp_349(), 0.0);
                double calculatedDamage = Math.floor(Math.pow((swordAttackDmg - 3.4) * 2.3, 0.3333333333333333)) + 7.0;
                this.stats.put("hardness", swordAttackDmg);
                if (this.groups.contains("stone")) {
                    this.stats.put("density", swordAttackDmg / 1.5);
                } else if (this.groups.contains("crystal")) {
                    this.stats.put("density", swordAttackDmg / 2.5);
                } else {
                    this.stats.put("density", swordAttackDmg / 2.0);
                }
                if (Math.abs(calculatedDamage - axeAttackDmg) > 0.1) {
                    this.stats.put("axe_damage", calculatedDamage - axeAttackDmg);
                }
                if (this.groups.contains("crystal") || this.groups.contains("gemstone")) {
                    this.stats.put("flexibility", 0.0);
                } else {
                    this.stats.put("flexibility", Double.valueOf(this.toolMaterial.method_8027() / 4.0f));
                }
                this.stats.put("tier", Double.valueOf(TierManager.getEstimatedTier((class_6862<class_2248>)this.toolMaterial.method_58419())));
                this.armorItems = this.findRelatedArmorItems();
                if (this.armorItems.size() == 4) {
                    double totalArmor = (int)this.armorItems.stream().collect(Collectors.summarizingInt(class_1738::method_7687)).getSum();
                    double desiredHardness = (totalArmor + this.stats.get("flexibility") / 4.0 + this.stats.get("density") / 4.0 - 1.0) / 4.05;
                    double max = Math.max(totalArmor, desiredHardness);
                    if (!(Math.abs(totalArmor - desiredHardness) <= 0.15 * max)) {
                        Miapi.LOGGER.info("replacement hardness " + desiredHardness + " original " + String.valueOf(this.stats.get("hardness")));
                        this.stats.put("armor_hardness", desiredHardness);
                    }
                }
                this.properties = GeneratedMaterialPropertyManager.setup(this.getID(), this.swordItem, axeItem, toolMaterials, this.armorItems, Map.of());
                return true;
            }
        }
        return false;
    }

    @Override
    public Material getMaterial(ModuleInstance moduleInstance) {
        if (TagProperty.getTags(moduleInstance).contains("armor") && this.stats.containsKey("armor_hardness")) {
            return new DelegatingMaterial(this){

                @Override
                public double getDouble(String property) {
                    if (property.equals("hardness")) {
                        if (GeneratedMaterialManager.verboseLogging()) {
                            Miapi.LOGGER.info("returning hardness " + String.valueOf(GeneratedMaterial.this.stats.get("armor_hardness")));
                        }
                        return GeneratedMaterial.this.stats.get("armor_hardness");
                    }
                    if (GeneratedMaterial.this.stats.containsKey(property)) {
                        return GeneratedMaterial.this.stats.get(property);
                    }
                    return 0.0;
                }
            };
        }
        return this;
    }

    public List<class_1738> findRelatedArmorItems() {
        return class_7923.field_41178.method_10220().filter(class_1738.class::isInstance).map(r -> (class_1738)r).filter(armorItem -> {
            block3: {
                try {
                    if (((class_1741)armorItem.method_7686().comp_349()).comp_2301() != null) {
                        return ((class_1856)((class_1741)armorItem.method_7686().comp_349()).comp_2301().get()).method_8093(this.mainIngredient);
                    }
                }
                catch (RuntimeException e) {
                    if (!GeneratedMaterialManager.verboseLogging()) break block3;
                    Miapi.LOGGER.error("Error during armor test", (Throwable)e);
                }
            }
            return false;
        }).toList();
    }

    public class_1829 getSwordItem() {
        return this.swordItem;
    }

    public void setSmithingMaterial(class_2960 other, class_1856 ingredient) {
        this.smithingParent = Optional.of(other);
        Material otherMat = MaterialProperty.getMaterialFromIngredient(this.mainIngredient);
        if (GeneratedMaterialManager.verboseLogging()) {
            Miapi.LOGGER.info("other mat for smithing test " + String.valueOf(otherMat));
        }
        if (otherMat == null || this.equals(otherMat) || otherMat.getID().equals((Object)this.getID())) {
            this.smithingMode = SmithingMode.INGREDIENT;
            this.groups = new ArrayList<String>(this.groups);
            this.groups = List.of(this.getStringID(), "smithing");
        } else {
            this.smithingMode = SmithingMode.TEMPLATE;
            if (otherMat != null) {
                otherMat.addSmithingGroup();
            }
            if (!ingredient.method_8103() && ingredient.method_8105() != null && ingredient.method_8105()[0] != null && !ingredient.method_8105()[0].method_7960()) {
                this.smithingTemplate = ingredient.method_8105()[0];
            }
        }
    }

    @Override
    public void addSmithingGroup() {
        if (!this.groups.contains("smithing")) {
            this.groups = new ArrayList<String>(this.groups);
            this.groups.add("smithing");
        }
    }

    @Override
    public class_2561 getTranslation() {
        if (this.name == null) {
            this.name = class_2561.method_43470((String)NamingUtil.generateTranslation(this.toolItems, this.mainIngredient));
        }
        return this.name;
    }

    public boolean isValid() {
        return this.isValid;
    }

    @net.fabricmc.api.Environment(value=EnvType.CLIENT)
    public void setupClient() {
        this.palette = GrayscalePaletteColorer.createForGeneratedMaterial(this, this.mainIngredient);
        this.icon = new MaterialIcons.ItemMaterialIcon(this.mainIngredient, 18, null);
    }

    @Override
    @net.fabricmc.api.Environment(value=EnvType.CLIENT)
    public int renderIcon(class_332 drawContext, int x, int y) {
        if (this.icon == null) {
            return 0;
        }
        return this.icon.render(drawContext, x, y);
    }

    @Override
    public boolean hasIcon() {
        return true;
    }

    @Override
    public class_2960 getID() {
        return this.key;
    }

    @Override
    public List<String> getGroups() {
        return this.groups;
    }

    @Override
    @net.fabricmc.api.Environment(value=EnvType.CLIENT)
    public MaterialRenderController getRenderController(ModuleInstance context, class_811 mode) {
        if (this.palette == null) {
            return new FallbackColorer(this);
        }
        return this.palette;
    }

    @Override
    public Map<ModuleProperty<?>, Object> materialProperties(String key) {
        return this.properties.getOrDefault(key, Map.of());
    }

    @Override
    public List<String> getAllPropertyKeys() {
        return List.of();
    }

    @Override
    public double getDouble(String property) {
        if (this.stats.containsKey(property)) {
            return this.stats.get(property);
        }
        return 0.0;
    }

    @Override
    public String getData(String property) {
        return null;
    }

    @Override
    public List<String> getTextureKeys() {
        return this.textureKeys;
    }

    @Override
    public double getValueOfItem(class_1799 itemStack) {
        if (!this.smithingMode.equals((Object)SmithingMode.TEMPLATE)) {
            if (this.mainIngredient.method_7909().equals(itemStack.method_7909())) {
                return 1.0;
            }
            if (this.ingredient.method_8093(itemStack)) {
                return 1.0;
            }
        }
        return 0.0;
    }

    @Override
    public double getRepairValueOfItem(class_1799 itemStack) {
        if (this.mainIngredient.method_7909().equals(itemStack.method_7909())) {
            return 1.0;
        }
        if (this.ingredient.method_8093(itemStack)) {
            return 1.0;
        }
        return 0.0;
    }

    @Override
    @Nullable
    public Double getPriorityOfIngredientItem(class_1799 itemStack) {
        if (!this.smithingMode.equals((Object)SmithingMode.TEMPLATE)) {
            if (this.mainIngredient.method_7909().equals(itemStack.method_7909())) {
                return -10.0;
            }
            if (this.ingredient.method_8093(itemStack)) {
                return -1.0;
            }
        } else if (itemStack.method_7909().equals(this.smithingTemplate.method_7909())) {
            return 1.0;
        }
        return null;
    }

    @Override
    public class_6862<class_2248> getIncorrectBlocksForDrops() {
        return this.incorrectForTool;
    }

    @Override
    public JsonObject getDebugJson() {
        JsonObject object = new JsonObject();
        object.add("id", (JsonElement)new JsonPrimitive(this.getID().toString()));
        JsonArray jsonElements = new JsonArray();
        this.getTextureKeys().forEach(arg_0 -> ((JsonArray)jsonElements).add(arg_0));
        object.add("groups", (JsonElement)jsonElements);
        this.stats.forEach((arg_0, arg_1) -> ((JsonObject)object).addProperty(arg_0, arg_1));
        if (Environment.isClient()) {
            object.addProperty("fake_translation", this.getTranslation().getString());
            class_2960 itemId = class_7923.field_41178.method_10221((Object)this.mainIngredient.method_7909());
            String iconBuilder = "{\"type\": \"item\",\"item\": \"" + String.valueOf(itemId) + "\"}";
            object.add("icon", (JsonElement)Miapi.gson.fromJson(iconBuilder, JsonObject.class));
        }
        if (this.palette != null) {
            StringBuilder paletteBuilder = new StringBuilder();
            paletteBuilder.append("{");
            paletteBuilder.append("\"type\": \"").append("grayscale_map").append("\",");
            paletteBuilder.append("\"colors\": ");
            JsonObject innerPalette = new JsonObject();
            for (int i = 0; i < this.palette.getColors().length; ++i) {
                int abgr = this.palette.getColors()[i];
                innerPalette.addProperty(String.valueOf(i), new Color(class_5253.class_8045.method_48345((int)abgr), class_5253.class_8045.method_48346((int)abgr), class_5253.class_8045.method_48347((int)abgr), class_5253.class_8045.method_48342((int)abgr)).hex());
            }
            paletteBuilder.append(Miapi.gson.toJson((JsonElement)innerPalette));
            paletteBuilder.append("}");
            object.add("palette", (JsonElement)Miapi.gson.fromJson(paletteBuilder.toString(), JsonObject.class));
        }
        JsonArray ingredients = new JsonArray();
        JsonObject mainIngredientJson = new JsonObject();
        mainIngredientJson.add("item", (JsonElement)new JsonPrimitive(class_7923.field_41178.method_10221((Object)this.mainIngredient.method_7909()).toString()));
        mainIngredientJson.add("value", (JsonElement)new JsonPrimitive((Number)1.0));
        JsonObject otherIngredient = new JsonObject();
        otherIngredient.add("ingredient", (JsonElement)class_1856.field_46095.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)this.toolMaterial.method_8023()).getOrThrow());
        otherIngredient.add("value", (JsonElement)new JsonPrimitive((Number)1.0));
        ingredients.add((JsonElement)mainIngredientJson);
        ingredients.add((JsonElement)otherIngredient);
        object.add("items", (JsonElement)ingredients);
        return object;
    }

    public int hashCode() {
        return this.getID().hashCode();
    }

    static enum SmithingMode {
        NONE,
        TEMPLATE,
        INGREDIENT;

    }
}

