/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.material.generated;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.redpxnda.nucleus.util.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.fabricmc.api.EnvType;
import net.minecraft.class_1738;
import net.minecraft.class_1799;
import net.minecraft.class_1831;
import net.minecraft.class_2248;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_5253;
import net.minecraft.class_6862;
import net.minecraft.class_7923;
import net.minecraft.class_811;
import org.jetbrains.annotations.Nullable;
import smartin.miapi.Environment;
import smartin.miapi.Miapi;
import smartin.miapi.events.MiapiEvents;
import smartin.miapi.material.MaterialIcons;
import smartin.miapi.material.MaterialProperty;
import smartin.miapi.material.base.Material;
import smartin.miapi.material.palette.FallbackColorer;
import smartin.miapi.material.palette.GrayscalePaletteColorer;
import smartin.miapi.material.palette.MaterialRenderController;
import smartin.miapi.modules.ModuleInstance;
import smartin.miapi.modules.properties.util.ModuleProperty;

public class GeneratedMaterialFromCopy
implements Material {
    class_1799 mainIngredient;
    class_2960 key;
    List<String> groups = new ArrayList<String>();
    List<String> textureKeys;
    Map<String, Double> stats = new HashMap<String, Double>();
    class_6862<class_2248> incorrectForTool;
    GrayscalePaletteColorer palette;
    @Nullable
    MaterialIcons.MaterialIcon icon;
    Material source;
    public static Codec<GeneratedMaterialFromCopy> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_1799.field_24671.fieldOf("ingredient").forGetter(m -> m.mainIngredient), (App)class_2960.field_25139.fieldOf("material").forGetter(m -> m.source.getID())).apply((Applicative)instance, (itemstack, material) -> new GeneratedMaterialFromCopy((class_1799)itemstack, MaterialProperty.MATERIAL_REGISTRY.get((class_2960)material))));

    public GeneratedMaterialFromCopy(class_1799 mainIngredient, Material other) {
        String[] names = other.getID().toString().split(":")[1].split("/");
        this.key = names.length > 1 ? Miapi.id("generated_" + names[names.length - 2] + "/" + mainIngredient.method_7922()) : Miapi.id("generated_simple/" + mainIngredient.method_7922());
        this.source = other;
        this.mainIngredient = mainIngredient;
        this.groups.add(this.key.toString());
        this.groups.addAll(other.getGroups());
        this.textureKeys = List.of("default");
        this.stats.put("hardness", other.getDouble("hardness"));
        this.stats.put("density", other.getDouble("density"));
        this.stats.put("flexibility", other.getDouble("flexibility"));
        this.stats.put("durability", other.getDouble("durability"));
        this.stats.put("mining_speed", other.getDouble("mining_speed"));
        this.stats.put("axe_damage", other.getDouble("axe_damage"));
        this.stats.put("enchantability", other.getDouble("enchantability"));
        this.stats.put("armor_durability_offset", other.getDouble("armor_durability_offset"));
        this.incorrectForTool = other.getIncorrectBlocksForDrops();
        if (Environment.isClient()) {
            this.setupClient();
        }
        ((MiapiEvents.CreateMaterialModularConvertersEvent)MiapiEvents.GENERATE_MATERIAL_CONVERTERS.invoker()).generated(this, new ArrayList<class_1831>(), new ArrayList<class_1738>(), Environment.isClient());
    }

    @Override
    public class_2561 getTranslation() {
        class_2561 name = this.mainIngredient.method_7964();
        return name == null ? class_2561.method_43470((String)"Missing Name!") : name;
    }

    @net.fabricmc.api.Environment(value=EnvType.CLIENT)
    public void setupClient() {
        this.palette = GrayscalePaletteColorer.createForGeneratedMaterial(this, this.mainIngredient);
        this.icon = new MaterialIcons.ItemMaterialIcon(this.mainIngredient, 18, null);
    }

    @Override
    public boolean hasIcon() {
        return true;
    }

    @Override
    @net.fabricmc.api.Environment(value=EnvType.CLIENT)
    public int renderIcon(class_332 drawContext, int x, int y) {
        if (this.icon == null) {
            return 0;
        }
        return this.icon.render(drawContext, x, y);
    }

    @Override
    public void addSmithingGroup() {
        if (!this.groups.contains("smithing")) {
            this.groups = new ArrayList<String>(this.groups);
            this.groups.add("smithing");
        }
    }

    @Override
    public class_2960 getID() {
        return this.key;
    }

    @Override
    public List<String> getGroups() {
        return this.groups;
    }

    @Override
    @net.fabricmc.api.Environment(value=EnvType.CLIENT)
    public MaterialRenderController getRenderController(ModuleInstance context, class_811 mode) {
        if (this.palette == null) {
            return new FallbackColorer(this);
        }
        return this.palette;
    }

    @Override
    public Map<ModuleProperty<?>, Object> materialProperties(String key) {
        return this.source.materialProperties(key);
    }

    @Override
    public List<String> getAllPropertyKeys() {
        return this.source.getAllPropertyKeys();
    }

    @Override
    public double getDouble(String property) {
        if (this.stats.containsKey(property)) {
            return this.stats.get(property);
        }
        return 0.0;
    }

    @Override
    public String getData(String property) {
        return this.source.getData(property);
    }

    @Override
    public List<String> getTextureKeys() {
        return List.of("default");
    }

    @Override
    public double getValueOfItem(class_1799 itemStack) {
        if (itemStack.method_7909().equals(this.mainIngredient.method_7909())) {
            return 1.0;
        }
        return 0.0;
    }

    @Override
    @Nullable
    public Double getPriorityOfIngredientItem(class_1799 itemStack) {
        if (itemStack.method_7909().equals(this.mainIngredient.method_7909())) {
            return -1.0;
        }
        return null;
    }

    @Override
    public class_6862<class_2248> getIncorrectBlocksForDrops() {
        return this.incorrectForTool;
    }

    @Override
    public JsonObject getDebugJson() {
        JsonObject object = new JsonObject();
        object.add("key", (JsonElement)new JsonPrimitive(this.getID().toString()));
        JsonArray jsonElements = new JsonArray();
        this.getTextureKeys().forEach(arg_0 -> ((JsonArray)jsonElements).add(arg_0));
        object.add("groups", (JsonElement)jsonElements);
        this.stats.forEach((arg_0, arg_1) -> ((JsonObject)object).addProperty(arg_0, arg_1));
        if (Environment.isClient()) {
            object.addProperty("fake_translation", this.getTranslation().getString());
            class_2960 itemId = class_7923.field_41178.method_10221((Object)this.mainIngredient.method_7909());
            String iconBuilder = "{\"type\": \"item\",\"item\": \"" + String.valueOf(itemId) + "\"}";
            object.add("icon", (JsonElement)Miapi.gson.fromJson(iconBuilder, JsonObject.class));
        }
        if (this.palette != null) {
            StringBuilder paletteBuilder = new StringBuilder();
            paletteBuilder.append("{");
            paletteBuilder.append("\"type\": \"").append("grayscale_map").append("\",");
            paletteBuilder.append("\"colors\": ");
            JsonObject innerPalette = new JsonObject();
            for (int i = 0; i < this.palette.getColors().length; ++i) {
                int abgr = this.palette.getColors()[i];
                innerPalette.addProperty(String.valueOf(i), new Color(class_5253.class_8045.method_48345((int)abgr), class_5253.class_8045.method_48346((int)abgr), class_5253.class_8045.method_48347((int)abgr), class_5253.class_8045.method_48342((int)abgr)).hex());
            }
            paletteBuilder.append(Miapi.gson.toJson((JsonElement)innerPalette));
            paletteBuilder.append("}");
            object.add("palette", (JsonElement)Miapi.gson.fromJson(paletteBuilder.toString(), JsonObject.class));
        }
        JsonArray ingredients = new JsonArray();
        JsonObject mainIngredientJson = new JsonObject();
        mainIngredientJson.add("item", (JsonElement)new JsonPrimitive(class_7923.field_41178.method_10221((Object)this.mainIngredient.method_7909()).toString()));
        mainIngredientJson.add("value", (JsonElement)new JsonPrimitive((Number)1.0));
        JsonObject otherIngredient = new JsonObject();
        otherIngredient.add("value", (JsonElement)new JsonPrimitive((Number)1.0));
        ingredients.add((JsonElement)mainIngredientJson);
        ingredients.add((JsonElement)otherIngredient);
        object.add("items", (JsonElement)ingredients);
        return object;
    }

    public int hashCode() {
        return this.getID().hashCode();
    }
}

