/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.material.generated;

import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.minecraft.class_1743;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1829;
import net.minecraft.class_1831;
import net.minecraft.class_1832;
import net.minecraft.class_1856;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3489;
import net.minecraft.class_5455;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_9135;
import smartin.miapi.Environment;
import smartin.miapi.Miapi;
import smartin.miapi.config.MiapiConfig;
import smartin.miapi.datapack.ReloadEvents;
import smartin.miapi.events.MiapiEvents;
import smartin.miapi.material.MaterialProperty;
import smartin.miapi.material.base.Material;
import smartin.miapi.material.generated.GeneratedMaterial;
import smartin.miapi.material.generated.GeneratedMaterialFromCopy;
import smartin.miapi.material.generated.SmithingRecipeUtil;
import smartin.miapi.registries.RegistryInventory;

public class GeneratedMaterialManager {
    public static final List<GeneratedMaterial> generatedMaterials = new ArrayList<GeneratedMaterial>();
    public static final List<GeneratedMaterialFromCopy> basicGeneratedMaterials = new ArrayList<GeneratedMaterialFromCopy>();

    public static void setup() {
        ReloadEvents.MAIN.subscribe((isClient, registryAccess) -> {
            if (!isClient) {
                GeneratedMaterialManager.onReloadServer(registryAccess);
            } else {
                basicGeneratedMaterials.forEach(generatedMaterial -> MaterialProperty.MATERIAL_REGISTRY.register(generatedMaterial.getID(), (Material)generatedMaterial));
                SmithingRecipeUtil.setupSmithingRecipe(generatedMaterials, true, material -> MaterialProperty.MATERIAL_REGISTRY.register(material.getID(), (Material)material), registryAccess, null);
            }
        }, -1.0f);
        ReloadEvents.dataSyncerRegistry.register(Miapi.id("generated_materials"), (ReloadEvents.DataSyncer)new ReloadEvents.SimpleSyncer<List<GeneratedMaterial>>(class_9135.method_56368((Codec)Codec.list(GeneratedMaterial.CODEC))){

            @Override
            public List<GeneratedMaterial> getDataServer() {
                return generatedMaterials;
            }

            @Override
            public void interpretData(List<GeneratedMaterial> data) {
                if (GeneratedMaterialManager.verboseLogging()) {
                    Miapi.LOGGER.info("Client received " + data.size() + " complex materials");
                }
                for (GeneratedMaterial material : data) {
                    material.setupClient();
                    if (!GeneratedMaterialManager.verboseLogging()) continue;
                    Miapi.LOGGER.info("complex " + material.getTranslation().getString());
                }
                generatedMaterials.clear();
                generatedMaterials.addAll(data);
            }
        });
        ReloadEvents.dataSyncerRegistry.register(Miapi.id("generated_simple_materials"), (ReloadEvents.DataSyncer)new ReloadEvents.SimpleSyncer<List<GeneratedMaterialFromCopy>>(class_9135.method_56368((Codec)Codec.list(GeneratedMaterialFromCopy.CODEC))){

            @Override
            public List<GeneratedMaterialFromCopy> getDataServer() {
                return basicGeneratedMaterials;
            }

            @Override
            public void interpretData(List<GeneratedMaterialFromCopy> data) {
                if (GeneratedMaterialManager.verboseLogging()) {
                    Miapi.LOGGER.info("Client received " + data.size() + " wood/stone materials");
                }
                for (GeneratedMaterialFromCopy copy : data) {
                    copy.setupClient();
                    if (!GeneratedMaterialManager.verboseLogging()) continue;
                    Miapi.LOGGER.info("wood/stone " + copy.getTranslation().getString());
                }
                basicGeneratedMaterials.clear();
                basicGeneratedMaterials.addAll(data);
            }
        });
    }

    public static class_2378<class_1792> getRegistry() {
        if (Miapi.registryAccess == null) {
            return class_7923.field_41178;
        }
        return (class_2378)Miapi.registryAccess.method_33310(class_7924.field_41197).get();
    }

    public static void onReloadServer(class_5455 access) {
        try {
            if (GeneratedMaterialManager.verboseLogging()) {
                Miapi.LOGGER.info("MIAPI STARTED MATERIAL GENERATION");
            }
            generatedMaterials.clear();
            basicGeneratedMaterials.clear();
            if (!MiapiConfig.getServerConfig().generatedMaterials.generateMaterials) {
                return;
            }
            class_2378<class_1792> registiry = GeneratedMaterialManager.getRegistry();
            ArrayList<class_1831> toolItems = new ArrayList<class_1831>(registiry.method_10220().filter(class_1831.class::isInstance).map(class_1831.class::cast).filter(toolMaterial -> toolMaterial.method_8022().method_8023() != null && toolMaterial.method_8022().method_8023().method_8105() != null && toolMaterial.method_8022().method_8023().method_8105().length > 0).filter(toolMaterial -> !toolMaterial.method_8022().method_8023().method_8105()[0].method_31573(RegistryInventory.MIAPI_FORBIDDEN_TAG)).filter(toolMaterial -> Arrays.stream(toolMaterial.method_8022().method_8023().method_8105()).allMatch(itemStack -> MaterialProperty.getMaterialFromIngredient(itemStack) == null && !itemStack.method_7909().equals(class_1802.field_8077))).toList());
            HashMap<class_1832, List> tieredItem = new HashMap<class_1832, List>();
            toolItems.forEach(item -> tieredItem.computeIfAbsent(item.method_8022(), i -> new ArrayList()).add(item));
            HashMap<class_1832, List> insufficientItems = new HashMap<class_1832, List>();
            tieredItem.forEach((t, items) -> {
                boolean hasSword = items.stream().anyMatch(class_1829.class::isInstance);
                boolean hasAxe = items.stream().anyMatch(class_1743.class::isInstance);
                if (!hasSword || !hasAxe) {
                    insufficientItems.put((class_1832)t, (List)items);
                }
            });
            insufficientItems.forEach((t, items) -> tieredItem.remove(t));
            if (MiapiConfig.getServerConfig().generatedMaterials.generateOtherMaterials) {
                toolItems.stream().filter(GeneratedMaterialManager::isValidItem).map(class_1831::method_8022).collect(Collectors.toSet()).stream().limit(MiapiConfig.getServerConfig().generatedMaterials.maximumGeneratedMaterials).collect(Collectors.toSet()).forEach(toolMaterial -> {
                    try {
                        class_1799 mainIngredient = toolMaterial.method_8023().method_8105()[0];
                        if (GeneratedMaterialManager.verboseLogging()) {
                            Miapi.LOGGER.info("attempting material generation for " + mainIngredient.method_7964().getString());
                        }
                        if (GeneratedMaterialManager.isValidItem(mainIngredient.method_7909())) {
                            List<class_1831> tieredItems = toolItems.stream().filter(item -> toolMaterial.equals((Object)item.method_8022())).toList();
                            GeneratedMaterial generatedMaterial = new GeneratedMaterial(mainIngredient, toolMaterial.method_8023(), (class_1832)toolMaterial, tieredItems);
                            if (generatedMaterial.isValid()) {
                                if (GeneratedMaterialManager.verboseLogging()) {
                                    Miapi.LOGGER.info("Generated Material " + String.valueOf(generatedMaterial.getID()));
                                }
                                generatedMaterials.add(generatedMaterial);
                            }
                        }
                    }
                    catch (RuntimeException e) {
                        Miapi.LOGGER.error("could not generate Material for " + String.valueOf(toolMaterial.method_8023().method_8105()[0]), (Throwable)e);
                    }
                });
            }
            if (MiapiConfig.getServerConfig().generatedMaterials.generateWoodMaterials) {
                class_7923.field_41178.method_10220().filter(item -> item.method_7854().method_31573(class_3489.field_15537) && !item.method_7854().method_31573(RegistryInventory.MIAPI_FORBIDDEN_TAG)).limit(MiapiConfig.getServerConfig().generatedMaterials.maximumGeneratedMaterials).forEach(item -> {
                    try {
                        if (GeneratedMaterialManager.isValidItem(item)) {
                            Material old = MaterialProperty.getMaterialFromIngredient(item.method_7854());
                            Material baseWood = MaterialProperty.MATERIAL_REGISTRY.get(Miapi.id("wood/wood"));
                            if (old != null && baseWood != null && old == baseWood) {
                                GeneratedMaterialFromCopy generatedMaterial = new GeneratedMaterialFromCopy(item.method_7854(), old);
                                basicGeneratedMaterials.add(generatedMaterial);
                                if (GeneratedMaterialManager.verboseLogging()) {
                                    Miapi.LOGGER.info("Generated Wood Material " + String.valueOf(generatedMaterial.getID()));
                                }
                            }
                        }
                    }
                    catch (Exception e) {
                        Miapi.LOGGER.error("could not generate wood Material for " + item.method_7876(), (Throwable)e);
                    }
                });
            }
            if (MiapiConfig.getServerConfig().generatedMaterials.generateStoneMaterials) {
                class_7923.field_41178.method_10220().filter(item -> item.method_7854().method_31573(class_3489.field_23802) && !item.method_7854().method_31573(RegistryInventory.MIAPI_FORBIDDEN_TAG)).limit(MiapiConfig.getServerConfig().generatedMaterials.maximumGeneratedMaterials).forEach(item -> {
                    try {
                        if (GeneratedMaterialManager.isValidItem(item) && !item.equals(class_1802.field_20412)) {
                            Material old = MaterialProperty.getMaterialFromIngredient(item.method_7854());
                            Material baseStone = MaterialProperty.MATERIAL_REGISTRY.get(Miapi.id("stone/stone"));
                            if (old != null && baseStone != null && old == baseStone) {
                                GeneratedMaterialFromCopy generatedMaterial = new GeneratedMaterialFromCopy(item.method_7854(), old);
                                basicGeneratedMaterials.add(generatedMaterial);
                                if (GeneratedMaterialManager.verboseLogging()) {
                                    Miapi.LOGGER.info("Generated Stone Material " + String.valueOf(generatedMaterial.getID()));
                                }
                            }
                        }
                    }
                    catch (Exception e) {
                        Miapi.LOGGER.error("could not generate stone Material for " + item.method_7876(), (Throwable)e);
                    }
                });
            }
            SmithingRecipeUtil.setupSmithingRecipe(generatedMaterials, false, material -> {
                MaterialProperty.MATERIAL_REGISTRY.register(material.getID(), (Material)material);
                ((MiapiEvents.CreateMaterialModularConvertersEvent)MiapiEvents.GENERATE_MATERIAL_CONVERTERS.invoker()).generated((Material)material, material.toolItems, material.armorItems, Environment.isClient());
            }, access, null);
            if (GeneratedMaterialManager.verboseLogging()) {
                Miapi.LOGGER.info("MIAPI FINISHED MATERIAL GENERATION");
            }
        }
        catch (Exception e) {
            Miapi.LOGGER.error("MAJOR ISSUE DURING MATERIAL CREATION", (Throwable)e);
        }
    }

    public static boolean isSameTier(class_1832 first, class_1832 second) {
        if (first.equals((Object)second)) {
            return true;
        }
        try {
            if (!first.method_58419().equals((Object)second.method_58419())) {
                return false;
            }
        }
        catch (RuntimeException runtimeException) {
            return false;
        }
        try {
            if (!GeneratedMaterialManager.isSameIngredient(first.method_8023(), second.method_8023())) {
                return false;
            }
        }
        catch (RuntimeException runtimeException) {
            return false;
        }
        return true;
    }

    public static class_1832 selectBetterTier(class_1832 first, class_1832 second) {
        if (first.method_8028() == second.method_8028()) {
            return first.method_8027() > second.method_8027() ? first : second;
        }
        if (first.method_8028() > second.method_8028()) {
            return first;
        }
        return second;
    }

    public static boolean isSameIngredient(class_1856 first, class_1856 second) {
        Set secondItems = Arrays.stream(second.method_8105()).collect(Collectors.toSet());
        Set firstItems = Arrays.stream(first.method_8105()).collect(Collectors.toSet());
        if (secondItems.size() == firstItems.size()) {
            return firstItems.containsAll(secondItems);
        }
        return false;
    }

    public static boolean isValidItem(class_1792 item) {
        class_2960 identifier = class_7923.field_41178.method_10221((Object)item);
        Pattern pattern = Pattern.compile(MiapiConfig.getServerConfig().generatedMaterials.blockRegex);
        return !pattern.matcher(identifier.toString()).find() && !item.method_40131().method_40220(RegistryInventory.MIAPI_FORBIDDEN_TAG);
    }

    public static boolean verboseLogging() {
        return MiapiConfig.getServerConfig().other.verboseLogging;
    }
}

