/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.material.palette;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.redpxnda.nucleus.util.Color;
import io.netty.handler.codec.DecoderException;
import java.io.Closeable;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1011;
import net.minecraft.class_2960;
import net.minecraft.class_7764;
import smartin.miapi.Miapi;
import smartin.miapi.client.renderer.NativeImageGetter;
import smartin.miapi.material.base.Material;
import smartin.miapi.material.palette.MaterialRenderController;
import smartin.miapi.material.palette.MaterialRenderControllers;
import smartin.miapi.material.palette.SpriteColorer;
import smartin.miapi.material.palette.SpriteFromJson;

@Environment(value=EnvType.CLIENT)
public class MaskColorer
extends SpriteColorer {
    public static Map<String, Masker> maskerRegistry = new HashMap<String, Masker>();
    public static Map<class_2960, MapCodec<? extends Masker>> MASKER_REGISTRY = new HashMap<class_2960, MapCodec<? extends Masker>>();
    public Masker masker;
    public SpriteColorer base;
    public SpriteColorer layer;
    public JsonElement originalJson;

    public MaskColorer(Material material, SpriteColorer base, SpriteColorer layer, Masker masker) {
        super(material);
        this.base = base;
        this.layer = layer;
        this.masker = masker;
    }

    public static MaterialRenderController fromJson(Material material, JsonElement element) {
        try {
            JsonObject object = element.getAsJsonObject();
            JsonElement baseElement = object.get("base");
            MaterialRenderController baseColorer = MaterialRenderControllers.creators.get(baseElement.getAsJsonObject().get("type").getAsString()).createPalette(baseElement, material);
            JsonElement layerElement = object.get("layer");
            MaterialRenderController layerColorer = MaterialRenderControllers.creators.get(layerElement.getAsJsonObject().get("type").getAsString()).createPalette(layerElement, material);
            if (baseColorer instanceof SpriteColorer) {
                SpriteColorer baseSpriteColor = (SpriteColorer)baseColorer;
                if (layerColorer instanceof SpriteColorer) {
                    SpriteColorer layerSpriteColor = (SpriteColorer)layerColorer;
                    Masker masker = MaskColorer.getMaskerFromJson(object.get("mask"));
                    MaskColorer controller = new MaskColorer(material, baseSpriteColor, layerSpriteColor, masker);
                    controller.originalJson = element;
                    return controller;
                }
            }
            return baseColorer;
        }
        catch (Exception e) {
            Miapi.LOGGER.error("Could not setup MaskPalette for " + String.valueOf(material.getID()), (Throwable)e);
            return null;
        }
    }

    public static Masker getMaskerFromJson(JsonElement element) {
        JsonObject object = element.getAsJsonObject();
        String type = object.get("type").getAsString();
        class_2960 id = Miapi.id(type);
        return (Masker)((Pair)MASKER_REGISTRY.get(id).codec().decode((DynamicOps)JsonOps.INSTANCE, (Object)element).getOrThrow(s -> new DecoderException("could not decode mask " + s))).getFirst();
    }

    @Override
    public Color getAverageColor() {
        return this.masker.average(this.base.getAverageColor(), this.layer.getAverageColor());
    }

    @Override
    public class_1011 transform(class_7764 originalSprite) {
        return this.masker.mask(this.base.transform(originalSprite), this.layer.transform(originalSprite));
    }

    @Override
    public boolean doTick() {
        return this.base.doTick() || this.layer.doTick() || this.masker.isAnimated();
    }

    @Override
    public void close() throws IOException {
        this.masker.close();
        this.base.close();
        this.layer.close();
    }

    static {
        maskerRegistry.put("texture", new SpriteMasker(null, false));
        MASKER_REGISTRY.put(Miapi.id("texture"), SpriteMasker.MAP_CODEC);
    }

    public static interface Masker
    extends Closeable {
        public class_1011 mask(class_1011 var1, class_1011 var2);

        public Color average(Color var1, Color var2);

        public Masker fromJson(JsonElement var1);

        public boolean isAnimated();
    }

    public static class SpriteMasker
    implements Masker,
    Closeable {
        public static MapCodec<SpriteMasker> DIRECT_MAP_CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)SpriteFromJson.MAP_CODEC.forGetter(c -> c.maskingSprite), (App)Miapi.FIXED_BOOL_CODEC.optionalFieldOf("offset", (Object)false).forGetter(c -> c.offsetRandom)).apply((Applicative)instance, SpriteMasker::new));
        public static MapCodec<SpriteMasker> DEEP_MAP_CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)SpriteFromJson.CODEC.fieldOf("sprite").forGetter(c -> c.maskingSprite), (App)Miapi.FIXED_BOOL_CODEC.optionalFieldOf("offset", (Object)false).forGetter(c -> c.offsetRandom)).apply((Applicative)instance, SpriteMasker::new));
        public static MapCodec<SpriteMasker> MAP_CODEC = Miapi.withAlternative(DIRECT_MAP_CODEC, DEEP_MAP_CODEC);
        SpriteFromJson maskingSprite;
        boolean offsetRandom = false;
        public int offsetAble = 12;
        public class_1011 lastImage = null;

        public SpriteMasker(SpriteFromJson contents, boolean offsetRandom) {
            this.maskingSprite = contents;
            this.offsetRandom = offsetRandom;
        }

        @Override
        public class_1011 mask(class_1011 base, class_1011 other) {
            NativeImageGetter.ImageHolder nativeImage = this.maskingSprite.getNativeImage();
            if (this.lastImage == null) {
                this.lastImage = new class_1011(base.method_4307(), base.method_4323(), true);
                this.lastImage.method_4302();
            }
            if (this.lastImage != null && (this.lastImage.method_4323() != base.method_4323() || this.lastImage.method_4307() != base.method_4307())) {
                this.lastImage.close();
                this.lastImage = new class_1011(base.method_4307(), base.method_4323(), true);
                this.lastImage.method_4302();
            }
            int xOffset = this.offsetRandom ? Math.abs(this.offsetAble * 13 + this.offsetAble * 17) : 0;
            int yOffset = this.offsetRandom ? Math.abs(this.offsetAble * 7 + this.offsetAble * 31) : 0;
            for (int width = 0; width < base.method_4307(); ++width) {
                for (int height = 0; height < base.method_4323(); ++height) {
                    if (this.isAnimated()) {
                        int baseColor = base.method_4315(width, height);
                        int otherColor = other.method_4315(width, height);
                        int blendColor = this.offsetRandom ? nativeImage.getColor((width + xOffset) % nativeImage.getWidth(), (height + yOffset) % nativeImage.getHeight()) : nativeImage.getColor(width % nativeImage.getWidth(), height % nativeImage.getHeight());
                        this.lastImage.method_4305(width, height, this.blendAlt(baseColor, otherColor, blendColor));
                        continue;
                    }
                    this.blend(base, other, width, height, nativeImage.nativeImage, (width + xOffset) % nativeImage.getWidth(), (height + yOffset) % nativeImage.getHeight(), this.lastImage);
                }
            }
            if (this.maskingSprite != null) {
                this.maskingSprite.markUse();
            }
            return this.lastImage;
        }

        public void blend(class_1011 base, class_1011 other, int nativeX, int nativeY, class_1011 blend, int blendX, int blendY, class_1011 output) {
            int baseColor = base.method_4315(nativeX, nativeY);
            int baseRed = baseColor >> base.method_4318().method_35632() & 0xFF;
            int baseGreen = baseColor >> base.method_4318().method_35633() & 0xFF;
            int baseBlue = baseColor >> base.method_4318().method_35634() & 0xFF;
            int baseAlpha = baseColor >> base.method_4318().method_4332() & 0xFF;
            int otherColor = other.method_4315(nativeX, nativeY);
            int otherRed = otherColor >> other.method_4318().method_35632() & 0xFF;
            int otherGreen = otherColor >> other.method_4318().method_35633() & 0xFF;
            int otherBlue = otherColor >> other.method_4318().method_35634() & 0xFF;
            int otherAlpha = otherColor >> other.method_4318().method_4332() & 0xFF;
            int blendColor = blend.method_4315(blendX, blendY);
            int blendRed = blendColor >> blend.method_4318().method_35632() & 0xFF;
            int blendGreen = blendColor >> blend.method_4318().method_35633() & 0xFF;
            int blendBlue = blendColor >> blend.method_4318().method_35634() & 0xFF;
            int blendAlpha = blendColor >> blend.method_4318().method_4332() & 0xFF;
            if (blendAlpha == 0) {
                output.method_4305(nativeX, nativeY, base.method_4315(nativeX, nativeY));
                return;
            }
            int blendedRed = (blendRed * otherRed + (255 - blendRed) * baseRed) / 255;
            int blendedGreen = (blendGreen * otherGreen + (255 - blendGreen) * baseGreen) / 255;
            int blendedBlue = (blendBlue * otherBlue + (255 - blendBlue) * baseBlue) / 255;
            int blendedAlpha = (blendAlpha * otherAlpha + (255 - blendAlpha) * baseAlpha) / 255;
            int blendedColor = blendedRed << output.method_4318().method_35632() | blendedGreen << output.method_4318().method_35633() | blendedBlue << output.method_4318().method_35634() | blendedAlpha << output.method_4318().method_4332();
            output.method_4305(nativeX, nativeY, blendedColor);
        }

        public int blendAlt(int base, int other, int blend) {
            int baseRed = base >> 24 & 0xFF;
            int baseGreen = base >> 16 & 0xFF;
            int baseBlue = base >> 8 & 0xFF;
            int baseAlpha = base & 0xFF;
            int otherRed = other >> 24 & 0xFF;
            int otherGreen = other >> 16 & 0xFF;
            int otherBlue = other >> 8 & 0xFF;
            int otherAlpha = other & 0xFF;
            int blendRed = blend >> 24 & 0xFF;
            int blendGreen = blend >> 16 & 0xFF;
            int blendBlue = blend >> 8 & 0xFF;
            int blendAlpha = blend & 0xFF;
            int blendedRed = (blendRed * otherRed + (255 - blendRed) * baseRed) / 255;
            int blendedGreen = (blendGreen * otherGreen + (255 - blendGreen) * baseGreen) / 255;
            int blendedBlue = (blendBlue * otherBlue + (255 - blendBlue) * baseBlue) / 255;
            int blendedAlpha = (blendAlpha * otherAlpha + (255 - blendAlpha) * baseAlpha) / 255;
            return blendedRed << 24 | blendedGreen << 16 | blendedBlue << 8 | blendedAlpha;
        }

        @Override
        public Color average(Color base, Color other) {
            return base;
        }

        @Override
        public Masker fromJson(JsonElement element) {
            SpriteFromJson sprite = SpriteFromJson.getFromJson(element);
            boolean offset = element.getAsJsonObject().has("offset") && element.getAsJsonObject().get("offset").getAsBoolean();
            return new SpriteMasker(sprite, offset);
        }

        @Override
        public boolean isAnimated() {
            return this.maskingSprite.isAnimated();
        }

        @Override
        public void close() throws IOException {
            if (this.lastImage != null) {
                this.lastImage.close();
                this.lastImage = null;
            }
        }
    }
}

