/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.material.palette;

import java.util.Map;
import java.util.WeakHashMap;
import java.util.function.Consumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1011;
import net.minecraft.class_1058;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_7764;
import net.minecraft.class_7768;
import net.minecraft.class_811;
import net.minecraft.class_918;
import smartin.miapi.client.atlas.MaterialSpriteManager;
import smartin.miapi.client.renderer.RescaledVertexConsumer;
import smartin.miapi.material.base.Material;
import smartin.miapi.material.palette.MaterialRenderController;
import smartin.miapi.modules.ModuleInstance;

@Environment(value=EnvType.CLIENT)
public abstract class SpriteColorer
implements MaterialRenderController {
    public static Map<class_1058, RescaledVertexConsumer> lookupMap = new WeakHashMap<class_1058, RescaledVertexConsumer>();
    public Material material;

    public SpriteColorer(Material material) {
        this.material = material;
    }

    public MaterialRecoloredSpriteHolder createSpriteManager(class_7764 spriteContents) {
        return new MaterialRecoloredSpriteHolder(spriteContents);
    }

    public void tick(Consumer<class_1011> nativeImageConsumer, class_7764 spriteContents) {
        nativeImageConsumer.accept(this.transform(spriteContents));
    }

    public abstract class_1011 transform(class_7764 var1);

    public abstract boolean doTick();

    @Override
    @Environment(value=EnvType.CLIENT)
    public class_4588 getVertexConsumer(class_4597 vertexConsumers, class_1058 originalSprite, class_1799 stack, ModuleInstance moduleInstance, class_811 mode) {
        class_2960 replaceId = MaterialSpriteManager.getMaterialSprite(originalSprite, this.material, this);
        class_1921 atlasRenderLayer = class_1921.method_23689((class_2960)replaceId);
        class_4588 atlasConsumer = class_918.method_29711((class_4597)vertexConsumers, (class_1921)atlasRenderLayer, (boolean)true, (boolean)false);
        return SpriteColorer.getVertexConsumer(atlasConsumer, originalSprite);
    }

    public static RescaledVertexConsumer getVertexConsumer(class_4588 vertexConsumer, class_1058 sprite) {
        RescaledVertexConsumer rescaled = lookupMap.computeIfAbsent(sprite, s -> new RescaledVertexConsumer(vertexConsumer, sprite));
        rescaled.delegate = vertexConsumer;
        return rescaled;
    }

    public boolean isAnimatedSprite(class_7764 spriteContents) {
        return SpriteColorer.isAnimatedSpriteStatic(spriteContents);
    }

    public static boolean isAnimatedSpriteStatic(class_7764 spriteContents) {
        try (class_7768 animator = spriteContents.method_45818();){
            if (animator != null) {
                boolean bl = true;
                return bl;
            }
        }
        return false;
    }

    public class MaterialRecoloredSpriteHolder {
        class_7764 lastRecolouredSprite;
        boolean isAnimated;

        public MaterialRecoloredSpriteHolder(class_7764 modelSprite) {
            this.lastRecolouredSprite = modelSprite;
            this.isAnimated = SpriteColorer.this.isAnimatedSprite(modelSprite);
        }

        public boolean requireTick() {
            return this.isAnimated || SpriteColorer.this.doTick();
        }

        public Material getMaterial() {
            return SpriteColorer.this.material;
        }

        public class_1011 recolor() {
            return SpriteColorer.this.transform(this.lastRecolouredSprite);
        }

        public boolean equals(Object obj) {
            if (obj instanceof MaterialRecoloredSpriteHolder) {
                MaterialRecoloredSpriteHolder other = (MaterialRecoloredSpriteHolder)obj;
                return other.lastRecolouredSprite.equals(this.lastRecolouredSprite) && SpriteColorer.this.material.equals(other.getMaterial());
            }
            return super.equals(obj);
        }
    }
}

