/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.material.palette;

import com.google.gson.JsonElement;
import com.redpxnda.nucleus.util.Color;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1011;
import net.minecraft.class_3532;
import net.minecraft.class_5253;
import net.minecraft.class_7764;
import smartin.miapi.client.renderer.NativeImageGetter;
import smartin.miapi.material.base.Material;
import smartin.miapi.material.palette.SpriteFromJson;
import smartin.miapi.material.palette.SpritePixelReplacer;

@Environment(value=EnvType.CLIENT)
public class SpriteOverlayer
extends SpritePixelReplacer {
    public final Color averageColor;
    public final SpriteFromJson delegate;
    protected NativeImageGetter.ImageHolder overlayImage;

    public SpriteOverlayer(Material material, JsonElement json) {
        super(material);
        this.delegate = SpriteFromJson.getFromJson(json);
        this.averageColor = this.delegate.getAverageColor();
    }

    @Override
    public Color getAverageColor() {
        return this.averageColor;
    }

    @Override
    public int getReplacementColor(int x, int y, int previousAbgr) {
        int abgr = this.overlayImage.getColor(x % this.overlayImage.getWidth(), y % this.overlayImage.getHeight());
        int alpha = class_5253.class_8045.method_48342((int)abgr);
        if (alpha != 255) {
            float overlayA = (float)alpha / 255.0f;
            int overlayR = class_5253.class_8045.method_48345((int)abgr);
            int overlayG = class_5253.class_8045.method_48346((int)abgr);
            int overlayB = class_5253.class_8045.method_48347((int)abgr);
            float baseA = (float)class_5253.class_8045.method_48342((int)previousAbgr) / 255.0f;
            int baseR = class_5253.class_8045.method_48345((int)previousAbgr);
            int baseG = class_5253.class_8045.method_48346((int)previousAbgr);
            int baseB = class_5253.class_8045.method_48347((int)previousAbgr);
            int newR = class_3532.method_48781((float)overlayA, (int)baseR, (int)overlayR);
            int newG = class_3532.method_48781((float)overlayA, (int)baseG, (int)overlayG);
            int newB = class_3532.method_48781((float)overlayA, (int)baseB, (int)overlayB);
            int newA = (int)(class_3532.method_16439((float)baseA, (float)overlayA, (float)1.0f) * 255.0f);
            return class_5253.class_8045.method_48344((int)newA, (int)newB, (int)newG, (int)newR);
        }
        return abgr;
    }

    @Override
    public class_1011 transform(class_7764 sprite) {
        this.overlayImage = this.delegate.getNativeImage();
        this.delegate.markUse();
        class_1011 result = super.transform(sprite);
        this.overlayImage = null;
        return result;
    }

    @Override
    public boolean doTick() {
        return this.delegate.isAnimated();
    }
}

