/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.modules;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_2960;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import smartin.miapi.Environment;
import smartin.miapi.Miapi;
import smartin.miapi.modules.ModuleInstance;
import smartin.miapi.modules.properties.util.ModuleProperty;
import smartin.miapi.registries.RegistryInventory;

public class ModuleDataPropertiesManager {
    public static Map<ModuleProperty<?>, Object> getProperties(ModuleInstance moduleInstance) {
        try {
            JsonElement properties = moduleInstance.moduleData.get(Miapi.id("properties"));
            return ModuleDataPropertiesManager.resolvePropertiesFromJson(properties);
        }
        catch (RuntimeException e) {
            Miapi.LOGGER.warn("could not decode properties", (Throwable)e);
            return new HashMap();
        }
    }

    public static Map<ModuleProperty<?>, Object> resolvePropertiesFromJson(JsonElement properties) {
        JsonObject moduleJson;
        HashMap map = new HashMap();
        if (properties != null && (moduleJson = properties.getAsJsonObject()) != null) {
            moduleJson.entrySet().forEach(stringJsonElementEntry -> {
                ModuleProperty property = RegistryInventory.MODULE_PROPERTY_MIAPI_REGISTRY.get(Miapi.id((String)stringJsonElementEntry.getKey()));
                if (property != null) {
                    try {
                        if (property.load(Miapi.id("runtime_data"), (JsonElement)stringJsonElementEntry.getValue(), Environment.isClient())) {
                            map.put(property, property.decode((JsonElement)stringJsonElementEntry.getValue()));
                        }
                    }
                    catch (Exception e) {
                        Miapi.LOGGER.info("could not load property " + (String)stringJsonElementEntry.getKey(), (Throwable)e);
                    }
                }
            });
        }
        return map;
    }

    @NotNull
    public static JsonObject createJsonFromProperties(Map<ModuleProperty<?>, Object> propertyMap) {
        JsonObject object = new JsonObject();
        propertyMap.forEach((moduleProperty, element) -> {
            class_2960 key = RegistryInventory.MODULE_PROPERTY_MIAPI_REGISTRY.findKey((ModuleProperty)moduleProperty);
            assert (key != null);
            try {
                JsonElement encoded = ModuleDataPropertiesManager.encode(moduleProperty, element);
                if (encoded != null) {
                    if (encoded.isJsonPrimitive()) {
                        object.add(key.toString(), encoded);
                    } else {
                        object.add(key.toString(), encoded);
                    }
                } else {
                    Miapi.LOGGER.error("could not encode property " + String.valueOf(key));
                }
            }
            catch (RuntimeException e) {
                Miapi.LOGGER.error("could not encode property " + String.valueOf(key), (Throwable)e);
            }
        });
        return object;
    }

    public static <T> void setProperty(ModuleInstance moduleInstance, ModuleProperty<T> property, @Nullable T propertyData) {
        Map<ModuleProperty<?>, Object> map = ModuleDataPropertiesManager.getProperties(moduleInstance);
        if (propertyData == null) {
            map.remove(property);
        } else {
            map.put(property, propertyData);
        }
        ModuleDataPropertiesManager.setProperties(moduleInstance, map);
    }

    public static void setProperties(ModuleInstance moduleInstance, Map<ModuleProperty<?>, Object> propertyMap) {
        if (propertyMap.isEmpty()) {
            moduleInstance.moduleData.remove(Miapi.id("properties"));
            return;
        }
        JsonObject object = ModuleDataPropertiesManager.createJsonFromProperties(propertyMap);
        moduleInstance.moduleData.put(Miapi.id("properties"), (JsonElement)object);
    }

    private static <T> JsonElement encode(ModuleProperty<T> property, Object data) {
        return property.encode(data);
    }
}

