/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.modules.abilities;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.redpxnda.nucleus.codec.auto.AutoCodec;
import com.redpxnda.nucleus.codec.behavior.CodecBehavior;
import java.util.List;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1271;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1838;
import net.minecraft.class_1839;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2302;
import net.minecraft.class_2338;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import smartin.miapi.item.modular.StatResolver;
import smartin.miapi.modules.ModuleInstance;
import smartin.miapi.modules.abilities.util.ItemAbilityManager;
import smartin.miapi.modules.abilities.util.ItemUseDefaultCooldownAbility;
import smartin.miapi.modules.abilities.util.ItemUseMinHoldAbility;

public class AreaHarvestReplant
implements ItemUseDefaultCooldownAbility<AreaHarvestJson>,
ItemUseMinHoldAbility<AreaHarvestJson> {
    public static String KEY = "area_harvest_ability";
    public static Codec<AreaHarvestJson> CODEC = AutoCodec.of(AreaHarvestJson.class).codec();

    @Override
    public boolean allowedOnItem(class_1799 itemStack, class_1937 world, class_1657 player, class_1268 hand, ItemAbilityManager.AbilityHitContext abilityHitContext) {
        if (abilityHitContext.hitEntity() == null && abilityHitContext.hitResult() != null) {
            class_2680 state = abilityHitContext.hitResult().method_8045().method_8320(abilityHitContext.hitResult().method_8037());
            return this.isGrown(state);
        }
        return false;
    }

    public boolean isGrown(class_2680 state) {
        class_2248 class_22482 = state.method_26204();
        if (class_22482 instanceof class_2302) {
            class_2302 cropBlock = (class_2302)class_22482;
            return cropBlock.method_9825(state);
        }
        return false;
    }

    @Override
    public class_1839 getUseAction(class_1799 itemStack) {
        return class_1839.field_42717;
    }

    @Override
    public int getMaxUseTime(class_1799 itemStack, class_1309 entity) {
        return 10;
    }

    @Override
    public class_1271<class_1799> use(class_1937 world, class_1657 user, class_1268 hand) {
        return null;
    }

    @Override
    public class_1269 useOnBlock(class_1838 context) {
        class_1657 class_16572;
        class_1799 itemStack = context.method_8041();
        if (!context.method_8045().method_8608() && (class_16572 = context.method_8036()) instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)class_16572;
            int blocksHarvested = 0;
            int range = ((AreaHarvestJson)this.getSpecialContext((class_1799)itemStack)).range.evaluatedOutput;
            class_2680 state = context.method_8045().method_8320(context.method_8037());
            class_2338 origin = context.method_8037();
            if (this.isGrown(state)) {
                for (int x = -range; x <= range; ++x) {
                    for (int y = -range; y <= range; ++y) {
                        class_2248 class_22482;
                        class_2338 currentPos = origin.method_10069(x, 0, y);
                        class_2680 blockState = context.method_8045().method_8320(currentPos);
                        if (!this.isGrown(blockState) || !((class_22482 = blockState.method_26204()) instanceof class_2302)) continue;
                        class_2302 cropBlock = (class_2302)class_22482;
                        class_22482 = context.method_8045();
                        if (!(class_22482 instanceof class_3218)) continue;
                        class_3218 serverWorld = (class_3218)class_22482;
                        class_2586 blockEntity = blockState.method_31709() ? context.method_8045().method_8321(currentPos) : null;
                        List stacks = class_2248.method_9609((class_2680)blockState, (class_3218)serverWorld, (class_2338)currentPos, (class_2586)blockEntity, (class_1297)serverPlayer, (class_1799)class_1799.field_8037);
                        serverWorld.method_8501(currentPos, cropBlock.method_9828(0));
                        stacks.forEach(arg_0 -> ((class_3222)serverPlayer).method_5775(arg_0));
                        ++blocksHarvested;
                    }
                }
            }
            itemStack.method_7970(blocksHarvested, (class_1309)serverPlayer, this.getEquipmentSlot(context.method_20287()));
            return class_1269.method_29236((boolean)context.method_8045().method_8608());
        }
        return class_1269.field_5814;
    }

    @Override
    public <K> AreaHarvestJson decode(DynamicOps<K> ops, K prefix) {
        return (AreaHarvestJson)((Pair)CODEC.decode(ops, prefix).getOrThrow()).getFirst();
    }

    @Override
    public AreaHarvestJson initialize(AreaHarvestJson data, ModuleInstance moduleInstance) {
        return data.initialize(moduleInstance);
    }

    @Override
    public AreaHarvestJson getDefaultContext() {
        return null;
    }

    @Override
    public int getCooldown(class_1799 itemstack) {
        return ((AreaHarvestJson)this.getSpecialContext((class_1799)itemstack)).cooldown.evaluatedOutput;
    }

    @Override
    public int getMinHoldTime(class_1799 itemStack) {
        return ((AreaHarvestJson)this.getSpecialContext((class_1799)itemStack)).minUseTime.evaluatedOutput;
    }

    public static class AreaHarvestJson {
        @CodecBehavior.Optional
        @AutoCodec.Name(value="min_hold_time")
        public StatResolver.IntegerFromStat minUseTime = new StatResolver.IntegerFromStat(0);
        @CodecBehavior.Optional
        public StatResolver.IntegerFromStat cooldown = new StatResolver.IntegerFromStat(0);
        @CodecBehavior.Optional
        public StatResolver.IntegerFromStat range = new StatResolver.IntegerFromStat(1);

        public AreaHarvestJson initialize(ModuleInstance moduleInstance) {
            AreaHarvestJson init = new AreaHarvestJson();
            init.cooldown = this.cooldown;
            init.minUseTime = this.minUseTime;
            init.range = this.range;
            init.cooldown.evaluate(moduleInstance);
            init.minUseTime.evaluate(moduleInstance);
            init.range.evaluate(moduleInstance);
            return init;
        }
    }
}

