/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.modules.abilities;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.redpxnda.nucleus.codec.auto.AutoCodec;
import com.redpxnda.nucleus.codec.behavior.CodecBehavior;
import com.redpxnda.nucleus.pose.server.ServerPoseFacet;
import java.util.ArrayList;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_5134;
import net.minecraft.class_5250;
import net.minecraft.class_6880;
import smartin.miapi.Miapi;
import smartin.miapi.attributes.AttributeRegistry;
import smartin.miapi.item.modular.StatResolver;
import smartin.miapi.modules.ModuleInstance;
import smartin.miapi.modules.abilities.util.AbilityMangerProperty;
import smartin.miapi.modules.abilities.util.EntityAttributeAbility;
import smartin.miapi.modules.abilities.util.ItemAbilityManager;
import smartin.miapi.modules.properties.LoreProperty;
import smartin.miapi.modules.properties.util.DoubleOperationResolvable;

public class BlockAbility
extends EntityAttributeAbility<BlockAbilityJson> {
    public static Codec<BlockAbilityJson> CODEC = AutoCodec.of(BlockAbilityJson.class).codec();
    class_2960 id = Miapi.id("block_ability_temporary_attribute");

    public BlockAbility() {
        LoreProperty.bottomLoreSuppliers.add(itemStack -> {
            ArrayList<class_5250> texts = new ArrayList<class_5250>();
            if (AbilityMangerProperty.isPrimaryAbility(this, itemStack)) {
                class_5250 raw = class_2561.method_43471((String)"miapi.ability.block.lore");
                texts.add(raw);
            }
            return texts;
        });
    }

    @Override
    protected Multimap<class_6880<class_1320>, class_1322> getAttributes(class_1799 itemStack) {
        ArrayListMultimap multimap = ArrayListMultimap.create();
        BlockAbilityJson json = (BlockAbilityJson)this.getSpecialContext(itemStack);
        double value = json.blocking.getValue();
        value = BlockAbility.calculate(value);
        multimap.put((Object)class_5134.field_23719, (Object)new class_1322(this.id, -(value / 2.0) / 100.0, class_1322.class_1323.field_6331));
        multimap.put(AttributeRegistry.DAMAGE_RESISTANCE, (Object)new class_1322(this.id, value, class_1322.class_1323.field_6328));
        return multimap;
    }

    public static double calculate(double value) {
        return 160.0 / (1.0 + Math.exp(-value / 50.0)) - 80.0;
    }

    @Override
    public boolean allowedOnItem(class_1799 itemStack, class_1937 world, class_1657 player, class_1268 hand, ItemAbilityManager.AbilityHitContext abilityHitContext) {
        return true;
    }

    @Override
    public int getMaxUseTime(class_1799 itemStack, class_1309 entity) {
        return 72000;
    }

    @Override
    public class_1271<class_1799> use(class_1937 world, class_1657 user, class_1268 hand) {
        this.setAnimation(user, hand);
        return super.use(world, user, hand);
    }

    @Override
    public class_1799 finishUsing(class_1799 stack, class_1937 world, class_1309 user) {
        this.resetAnimation(user);
        return super.finishUsing(stack, world, user);
    }

    @Override
    public void onStoppedUsingAfter(class_1799 stack, class_1937 world, class_1309 user, int remainingUseTicks) {
        this.resetAnimation(user);
        super.onStoppedUsingAfter(stack, world, user, remainingUseTicks);
    }

    @Override
    public void onStoppedHolding(class_1799 stack, class_1937 world, class_1309 user) {
        this.resetAnimation(user);
        super.onStoppedHolding(stack, world, user);
    }

    @Override
    public BlockAbilityJson getDefaultContext() {
        return null;
    }

    public void setAnimation(class_1657 p, class_1268 hand) {
        class_3222 player;
        ServerPoseFacet facet;
        if (p instanceof class_3222 && (facet = (ServerPoseFacet)ServerPoseFacet.KEY.get((class_1297)(player = (class_3222)p))) != null) {
            facet.set("miapi:block", player, hand);
        }
    }

    public void resetAnimation(class_1309 entity) {
        class_3222 player;
        ServerPoseFacet facet;
        if (entity instanceof class_3222 && (facet = (ServerPoseFacet)ServerPoseFacet.KEY.get((class_1297)(player = (class_3222)entity))) != null) {
            facet.reset(player);
        }
    }

    @Override
    public int getCooldown(class_1799 itemstack) {
        return ((BlockAbilityJson)this.getSpecialContext((class_1799)itemstack)).cooldown.evaluatedOutput;
    }

    @Override
    public int getMinHoldTime(class_1799 itemStack) {
        return ((BlockAbilityJson)this.getSpecialContext((class_1799)itemStack)).minUseTime.evaluatedOutput;
    }

    @Override
    public <K> BlockAbilityJson decode(DynamicOps<K> ops, K prefix) {
        return (BlockAbilityJson)((Pair)CODEC.decode(ops, prefix).getOrThrow()).getFirst();
    }

    @Override
    public BlockAbilityJson initialize(BlockAbilityJson data, ModuleInstance moduleInstance) {
        return data.initialize(moduleInstance);
    }

    public static class BlockAbilityJson {
        @CodecBehavior.Optional
        @AutoCodec.Name(value="min_hold_time")
        public StatResolver.IntegerFromStat minUseTime = new StatResolver.IntegerFromStat(0);
        @CodecBehavior.Optional
        public StatResolver.IntegerFromStat cooldown = new StatResolver.IntegerFromStat(0);
        public DoubleOperationResolvable blocking = new DoubleOperationResolvable(10.0);

        public BlockAbilityJson initialize(ModuleInstance moduleInstance) {
            BlockAbilityJson init = new BlockAbilityJson();
            init.minUseTime = this.minUseTime;
            init.cooldown = this.cooldown;
            this.minUseTime.evaluate(moduleInstance);
            this.cooldown.evaluate(moduleInstance);
            init.blocking = this.blocking.initialize(moduleInstance);
            return init;
        }
    }
}

