/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.modules.abilities;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.redpxnda.nucleus.codec.auto.AutoCodec;
import com.redpxnda.nucleus.codec.behavior.CodecBehavior;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1293;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1839;
import net.minecraft.class_1937;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_4174;
import smartin.miapi.modules.ModuleInstance;
import smartin.miapi.modules.abilities.util.ItemAbilityManager;
import smartin.miapi.modules.abilities.util.ItemUseDefaultCooldownAbility;
import smartin.miapi.modules.abilities.util.ItemUseMinHoldAbility;
import smartin.miapi.modules.properties.util.DoubleOperationResolvable;
import smartin.miapi.modules.properties.util.MergeType;

public class EatAbility
implements ItemUseDefaultCooldownAbility<EatRawData>,
ItemUseMinHoldAbility<EatRawData> {
    public static final String KEY = "eat";

    @Override
    public boolean allowedOnItem(class_1799 itemStack, class_1937 world, class_1657 player, class_1268 hand, ItemAbilityManager.AbilityHitContext abilityHitContext) {
        EatRawData data = (EatRawData)this.getSpecialContext(itemStack);
        return data != null && (data.alwaysEdible || player.method_7344().method_7587());
    }

    @Override
    public class_1839 getUseAction(class_1799 itemStack) {
        return class_1839.field_8950;
    }

    @Override
    public int getMaxUseTime(class_1799 itemStack, class_1309 entity) {
        return ((EatRawData)this.getSpecialContext(itemStack)).eatTicks();
    }

    @Override
    public class_1271<class_1799> use(class_1937 world, class_1657 user, class_1268 hand) {
        if (user.method_7357().method_7904(user.method_5998(hand).method_7909())) {
            return class_1271.method_22430((Object)user.method_5998(hand));
        }
        user.method_6019(hand);
        return class_1271.method_22428((Object)user.method_5998(hand));
    }

    @Override
    public void usageTick(class_1937 world, class_1309 user, class_1799 stack, int remainingUseTicks) {
        if (remainingUseTicks <= 0) {
            user.method_6075();
            EatRawData context = (EatRawData)this.getSpecialContext(stack);
            boolean isClient = user.method_37908().field_9236;
            if (isClient) {
                user.method_37908().method_8486(user.method_23317(), user.method_23318(), user.method_23321(), user.method_18869(stack), class_3419.field_15254, 1.0f, 1.0f + (world.field_9229.method_43057() - world.field_9229.method_43057()) * 0.4f, true);
            }
            if (user instanceof class_1657) {
                class_1657 player = (class_1657)user;
                if (!isClient) {
                    player.method_7344().method_7585(context.getNutrition(), (float)context.getSaturation());
                    context.effects.forEach(possibleEffect -> {
                        if (user.method_37908().method_8409().method_43057() < possibleEffect.comp_2497()) {
                            player.method_6092(new class_1293(possibleEffect.comp_2496()));
                        }
                    });
                    if (player instanceof class_3222) {
                        class_3222 serverPlayerEntity = (class_3222)player;
                        if (context.consumeOnEat()) {
                            stack.method_7934(1);
                        } else {
                            stack.method_7970(context.durabilityDamage(), (class_1309)serverPlayerEntity, this.getEquipmentSlot(user.method_6058()));
                        }
                    }
                } else {
                    user.method_37908().method_8486(user.method_23317(), user.method_23318(), user.method_23321(), class_3417.field_19149, class_3419.field_15254, 0.5f, world.field_9229.method_43057() * 0.1f + 0.9f, true);
                }
            }
        }
    }

    @Override
    public <K> EatRawData decode(DynamicOps<K> ops, K prefix) {
        return (EatRawData)((Pair)EatRawData.codec.decode(ops, prefix).getOrThrow()).getFirst();
    }

    @Override
    public EatRawData getDefaultContext() {
        return null;
    }

    @Override
    public int getCooldown(class_1799 itemStack) {
        return ((EatRawData)this.getSpecialContext(itemStack)).getCooldown();
    }

    @Override
    public int getMinHoldTime(class_1799 itemStack) {
        return ((EatRawData)this.getSpecialContext(itemStack)).eatTicks();
    }

    public static class EatRawData {
        public static final Codec<EatRawData> codec = AutoCodec.of(EatRawData.class).codec();
        public DoubleOperationResolvable nutrition;
        public DoubleOperationResolvable saturation;
        public DoubleOperationResolvable eat_ticks = new DoubleOperationResolvable(32.0);
        public DoubleOperationResolvable cooldown = new DoubleOperationResolvable(0.0);
        @CodecBehavior.Optional
        public DoubleOperationResolvable durability = new DoubleOperationResolvable(0.0);
        @CodecBehavior.Optional
        public boolean alwaysEdible = false;
        @CodecBehavior.Override(value="effect_codec")
        public static Codec<List<class_4174.class_9423>> effect_codec = Codec.list((Codec)class_4174.class_9423.field_49996);
        @CodecBehavior.Optional
        public List<class_4174.class_9423> effects = new ArrayList<class_4174.class_9423>();

        public EatRawData initialize(ModuleInstance instance) {
            this.nutrition.initialize(instance);
            this.saturation.initialize(instance);
            this.durability.initialize(instance);
            return this;
        }

        public EatRawData merge(EatRawData merge, MergeType mergeType) {
            return EatRawData.merge(this, merge, mergeType);
        }

        public static EatRawData merge(EatRawData left, EatRawData right, MergeType mergeType) {
            EatRawData rawData = new EatRawData();
            rawData.nutrition = DoubleOperationResolvable.merge(left.nutrition, right.nutrition, mergeType);
            rawData.saturation = DoubleOperationResolvable.merge(left.saturation, right.saturation, mergeType);
            rawData.durability = DoubleOperationResolvable.merge(left.durability, right.durability, mergeType);
            if (MergeType.OVERWRITE.equals((Object)mergeType)) {
                rawData.effects = right.effects;
            } else {
                ArrayList<class_4174.class_9423> mergedEffects = new ArrayList<class_4174.class_9423>(left.effects);
                mergedEffects.addAll(right.effects);
                rawData.effects = mergedEffects;
            }
            rawData.alwaysEdible = left.alwaysEdible || right.alwaysEdible;
            return rawData;
        }

        int getNutrition() {
            return (int)this.nutrition.evaluate(0.0, 1.0);
        }

        int getCooldown() {
            return (int)this.cooldown.evaluate(0.0, 0.0);
        }

        double getSaturation() {
            return this.saturation.evaluate(0.0, 1.0);
        }

        int eatTicks() {
            return (int)this.eat_ticks.evaluate(0.0, 32.0);
        }

        int durabilityDamage() {
            return (int)this.eat_ticks.evaluate(0.0, 0.0);
        }

        boolean consumeOnEat() {
            return this.eat_ticks.evaluate(0.0) == null;
        }
    }
}

