/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.modules.abilities;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1839;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import smartin.miapi.modules.ModuleInstance;
import smartin.miapi.modules.abilities.util.ItemAbilityManager;
import smartin.miapi.modules.abilities.util.ItemUseDefaultCooldownAbility;
import smartin.miapi.modules.abilities.util.ItemUseMinHoldAbility;
import smartin.miapi.modules.properties.util.DoubleOperationResolvable;
import smartin.miapi.modules.properties.util.MergeType;

public class SonicBoomAbility
implements ItemUseDefaultCooldownAbility<SonicBoomContext>,
ItemUseMinHoldAbility<SonicBoomContext> {
    public static String KEY = "sonic_boom";

    @Override
    public int getCooldown(class_1799 itemStack) {
        return (int)((SonicBoomContext)this.getSpecialContext(itemStack)).cooldown().getValue();
    }

    @Override
    public int getMinHoldTime(class_1799 itemStack) {
        return (int)((SonicBoomContext)this.getSpecialContext(itemStack)).minHold().getValue();
    }

    @Override
    public boolean allowedOnItem(class_1799 itemStack, class_1937 world, class_1657 player, class_1268 hand, ItemAbilityManager.AbilityHitContext abilityHitContext) {
        return true;
    }

    @Override
    public class_1839 getUseAction(class_1799 itemStack) {
        return class_1839.field_27079;
    }

    @Override
    public int getMaxUseTime(class_1799 itemStack, class_1309 entity) {
        return 72000;
    }

    @Override
    public class_1271<class_1799> use(class_1937 world, class_1657 user, class_1268 hand) {
        if (user.method_7357().method_7904(user.method_5998(hand).method_7909())) {
            return class_1271.method_22430((Object)user.method_5998(hand));
        }
        user.method_6019(hand);
        return class_1271.method_22428((Object)user.method_5998(hand));
    }

    @Override
    public void onStoppedUsingAfter(class_1799 stack, class_1937 world, class_1309 user, int remainingUseTicks) {
        SonicBoomContext context = (SonicBoomContext)this.getSpecialContext(stack);
        if (user instanceof class_1657) {
            class_1657 player = (class_1657)user;
            if ((double)(this.getMaxUseTime(stack, user) - remainingUseTicks) >= context.minHold().getValue() && world instanceof class_3218) {
                class_3218 serverLevel = (class_3218)world;
                double range = context.maxRange().getValue();
                class_238 aabb = new class_238(player.method_23317() - range, player.method_23318() - range, player.method_23321() - range, player.method_23317() + range, player.method_23318() + range, player.method_23321() + range);
                List entities = world.method_8390(class_1309.class, aabb, entity -> entity != player && entity.method_5805());
                for (class_1309 target : entities) {
                    double damage = context.damage().getValue();
                    target.method_5643(player.method_48923().method_48821((class_1297)target), (float)damage);
                    serverLevel.method_14199((class_2394)class_2398.field_38908, target.method_23317(), target.method_23318(), target.method_23321(), 10, 0.5, 0.5, 0.5, 0.1);
                }
                player.method_5783(context.onBoom(), 1.0f, 1.0f);
                player.method_7357().method_7906(stack.method_7909(), (int)context.cooldown().getValue());
                player.method_6104(player.method_6058());
            }
        }
    }

    @Override
    public <K> SonicBoomContext decode(DynamicOps<K> ops, K prefix) {
        return (SonicBoomContext)((Pair)SonicBoomContext.CODEC.decode(ops, prefix).getOrThrow()).getFirst();
    }

    @Override
    public SonicBoomContext getDefaultContext() {
        return new SonicBoomContext(class_3417.field_38830, new DoubleOperationResolvable(15.0), new DoubleOperationResolvable(10.0), new DoubleOperationResolvable(20.0), new DoubleOperationResolvable(5.0));
    }

    @Override
    public SonicBoomContext initialize(SonicBoomContext json, ModuleInstance moduleInstance) {
        return json.initialize(moduleInstance);
    }

    @Override
    public SonicBoomContext merge(SonicBoomContext left, SonicBoomContext right, MergeType mergeType) {
        return SonicBoomContext.merge(left, right, mergeType);
    }

    public record SonicBoomContext(class_3414 onBoom, DoubleOperationResolvable minHold, DoubleOperationResolvable damage, DoubleOperationResolvable cooldown, DoubleOperationResolvable maxRange) {
        public static final Codec<SonicBoomContext> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_3414.field_41698.optionalFieldOf("on_boom", (Object)class_3417.field_38830).forGetter(SonicBoomContext::onBoom), (App)DoubleOperationResolvable.CODEC.optionalFieldOf("min_hold", (Object)new DoubleOperationResolvable(15.0)).forGetter(SonicBoomContext::minHold), (App)DoubleOperationResolvable.CODEC.optionalFieldOf("damage", (Object)new DoubleOperationResolvable(10.0)).forGetter(SonicBoomContext::damage), (App)DoubleOperationResolvable.CODEC.optionalFieldOf("cooldown", (Object)new DoubleOperationResolvable(20.0)).forGetter(SonicBoomContext::cooldown), (App)DoubleOperationResolvable.CODEC.optionalFieldOf("max_range", (Object)new DoubleOperationResolvable(5.0)).forGetter(SonicBoomContext::maxRange)).apply((Applicative)instance, SonicBoomContext::new));

        public SonicBoomContext initialize(ModuleInstance moduleInstance) {
            DoubleOperationResolvable initializedMinHold = this.minHold.initialize(moduleInstance);
            DoubleOperationResolvable initializedDamage = this.damage.initialize(moduleInstance);
            DoubleOperationResolvable initializedCooldown = this.cooldown.initialize(moduleInstance);
            DoubleOperationResolvable initializedMaxRange = this.maxRange.initialize(moduleInstance);
            return new SonicBoomContext(this.onBoom, initializedMinHold, initializedDamage, initializedCooldown, initializedMaxRange);
        }

        public static SonicBoomContext merge(SonicBoomContext left, SonicBoomContext right, MergeType mergeType) {
            class_3414 mergedOnBoom = MergeType.EXTEND.equals((Object)mergeType) && left.onBoom != null ? left.onBoom : right.onBoom;
            DoubleOperationResolvable mergedMinHold = left.minHold.merge(right.minHold, mergeType);
            DoubleOperationResolvable mergedDamage = left.damage.merge(right.damage, mergeType);
            DoubleOperationResolvable mergedCooldown = left.cooldown.merge(right.cooldown, mergeType);
            DoubleOperationResolvable mergedMaxRange = left.maxRange.merge(right.maxRange, mergeType);
            return new SonicBoomContext(mergedOnBoom, mergedMinHold, mergedDamage, mergedCooldown, mergedMaxRange);
        }
    }
}

