/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.modules.abilities.gun;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.redpxnda.nucleus.pose.server.ServerPoseFacet;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1839;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_7924;
import smartin.miapi.Miapi;
import smartin.miapi.modules.abilities.gun.GunContextProperty;
import smartin.miapi.modules.abilities.gun.GunMagazineComponent;
import smartin.miapi.modules.abilities.util.CodecAbility;
import smartin.miapi.modules.abilities.util.ItemAbilityManager;

public class ReloadSingleBulletAbility
implements CodecAbility<ReloadAbilityContext> {
    public static class_2960 KEY = Miapi.id("gun_reload_single");

    @Override
    public boolean allowedOnItem(class_1799 itemStack, class_1937 world, class_1657 player, class_1268 hand, ItemAbilityManager.AbilityHitContext abilityHitContext) {
        boolean hasSpace = (double)GunMagazineComponent.getBulletCount(itemStack) < GunContextProperty.getGunContext(itemStack).magazineSize().getValue();
        boolean hasAbility = this.getSpecialContext(itemStack) != null;
        return hasAbility && hasSpace;
    }

    @Override
    public class_1839 getUseAction(class_1799 itemStack) {
        return class_1839.field_8952;
    }

    @Override
    public int getMaxUseTime(class_1799 itemStack, class_1309 livingEntity) {
        return (int)Math.ceil(((ReloadAbilityContext)this.getSpecialContext((class_1799)itemStack)).reloadDelaySeconds * 20.0f);
    }

    @Override
    public class_1271<class_1799> use(class_1937 world, class_1657 player, class_1268 hand) {
        class_1799 gun = player.method_5998(hand);
        ReloadAbilityContext context = (ReloadAbilityContext)this.getSpecialContext(gun);
        if (context == null || (double)GunMagazineComponent.getBulletCount(gun) >= GunContextProperty.getGunContext(gun).magazineSize().getValue()) {
            return class_1271.method_22430((Object)gun);
        }
        player.method_6019(hand);
        return class_1271.method_22428((Object)gun);
    }

    @Override
    public void onStoppedUsing(class_1799 gun, class_1937 world, class_1309 entity, int timeCharged) {
        class_3414 event;
        if (!(entity instanceof class_1657)) {
            return;
        }
        class_1657 player = (class_1657)entity;
        ReloadAbilityContext context = (ReloadAbilityContext)this.getSpecialContext(gun);
        if (context == null) {
            return;
        }
        int chargeDuration = this.getMaxUseTime(gun, entity) - timeCharged;
        if (chargeDuration < this.getMaxUseTime(gun, entity)) {
            return;
        }
        Optional<class_1799> bullet = player.method_31548().field_7547.stream().filter(context.bulletFilter).findFirst();
        if (bullet.isEmpty()) {
            return;
        }
        bullet.get().method_7934(1);
        GunMagazineComponent.addBullet(gun, new class_1799((class_1935)bullet.get().method_7909()));
        if (context.reloadSound != null && (event = (class_3414)((class_2378)world.method_30349().method_33310(class_7924.field_41225).get()).method_10223(context.reloadSound)) != null) {
            world.method_43128(null, entity.method_23317(), entity.method_23318(), entity.method_23321(), event, entity.method_5634(), 1.0f, 1.0f);
        }
        if (context.reloadAnim != null) {
            this.setAnimation(player, class_1268.field_5808, context.reloadAnim);
            world.method_8503().execute(() -> this.resetAnimation((class_1309)player));
        }
    }

    private void setAnimation(class_1657 player, class_1268 hand, class_2960 location) {
        class_3222 serverPlayer;
        ServerPoseFacet facet;
        if (player instanceof class_3222 && (facet = (ServerPoseFacet)ServerPoseFacet.KEY.get((class_1297)(serverPlayer = (class_3222)player))) != null) {
            facet.set(location.toString(), serverPlayer, hand);
        }
    }

    private void resetAnimation(class_1309 entity) {
        class_3222 serverPlayer;
        ServerPoseFacet facet;
        if (entity instanceof class_3222 && (facet = (ServerPoseFacet)ServerPoseFacet.KEY.get((class_1297)(serverPlayer = (class_3222)entity))) != null) {
            facet.reset(serverPlayer);
        }
    }

    @Override
    public Codec<ReloadAbilityContext> getCodec() {
        return ReloadAbilityContext.CODEC;
    }

    public static class ReloadAbilityContext {
        public static final Codec<ReloadAbilityContext> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.FLOAT.fieldOf("reloadDelaySeconds").forGetter(context -> Float.valueOf(context.reloadDelaySeconds)), (App)class_2960.field_25139.optionalFieldOf("reloadAnim").forGetter(context -> Optional.ofNullable(context.reloadAnim)), (App)class_2960.field_25139.optionalFieldOf("reloadSound").forGetter(context -> Optional.ofNullable(context.reloadSound))).apply((Applicative)instance, ReloadAbilityContext::new));
        public final float reloadDelaySeconds;
        public final Predicate<class_1799> bulletFilter;
        public final class_2960 reloadAnim;
        public final class_2960 reloadSound;

        public ReloadAbilityContext(float reloadDelaySeconds, Optional<class_2960> reloadAnim, Optional<class_2960> reloadSound) {
            this.reloadDelaySeconds = reloadDelaySeconds;
            this.bulletFilter = i -> true;
            this.reloadAnim = reloadAnim.orElse(null);
            this.reloadSound = reloadSound.orElse(null);
        }
    }
}

