/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.modules.abilities.util;

import com.mojang.serialization.DynamicOps;
import dev.architectury.event.events.common.TickEvent;
import dev.architectury.platform.Platform;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.WeakHashMap;
import java.util.function.Supplier;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1271;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1838;
import net.minecraft.class_1839;
import net.minecraft.class_1937;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import org.jetbrains.annotations.Nullable;
import smartin.miapi.Miapi;
import smartin.miapi.modules.abilities.key.KeyBindAbilityManagerProperty;
import smartin.miapi.modules.abilities.key.KeyBindFacet;
import smartin.miapi.modules.abilities.util.AbilityMangerProperty;
import smartin.miapi.modules.abilities.util.ItemUseAbility;
import smartin.miapi.modules.abilities.util.ItemUseDefaultCooldownAbility;
import smartin.miapi.modules.cache.ModularItemCache;
import smartin.miapi.registries.MiapiRegistry;

public class ItemAbilityManager {
    private static final Map<class_1657, class_1799> playerActiveItems = new WeakHashMap<class_1657, class_1799>();
    private static final Map<class_1657, class_1799> playerActiveItemsClient = new WeakHashMap<class_1657, class_1799>();
    public static final MiapiRegistry<ItemUseAbility> useAbilityRegistry = MiapiRegistry.getInstance(ItemUseAbility.class);
    private static final AbilityHolder<?> emptyAbility = new AbilityHolder<Object>(new EmptyAbility(), new Object());
    private static final Map<class_1799, AbilityHolder<?>> abilityMap = Collections.synchronizedMap(new WeakHashMap());
    public static final Map<class_1657, class_2960> clientKeyBindID = new WeakHashMap<class_1657, class_2960>();
    public static final Map<class_1657, class_2960> serverKeyBindID = new WeakHashMap<class_1657, class_2960>();

    public static void setup() {
        TickEvent.PLAYER_PRE.register(playerEntity -> {
            Map<class_1657, class_1799> activeItems = playerActiveItems;
            if (playerEntity.method_37908().field_9236) {
                activeItems = playerActiveItemsClient;
            }
            class_1799 oldItem = activeItems.get(playerEntity);
            class_1799 playerItem = playerEntity.method_6030();
            if (playerItem != null && !playerItem.equals(oldItem)) {
                activeItems.put((class_1657)playerEntity, playerItem);
                if (oldItem != null) {
                    AbilityHolder<?> holder = ItemAbilityManager.getAbility(oldItem);
                    holder.ability().onStoppedHolding(oldItem, playerEntity.method_37908(), (class_1309)playerEntity);
                    abilityMap.remove(oldItem);
                }
            }
        });
        useAbilityRegistry.addCallback(ability -> ModularItemCache.setSupplier(AbilityMangerProperty.KEY + "_" + String.valueOf(useAbilityRegistry.findKey((ItemUseAbility)ability)), itemStack -> {
            Optional<AbilityHolder> optional = abilityMap.values().stream().filter(e -> e.ability().equals(ability)).findFirst();
            return optional.map(AbilityHolder::context).orElse(null);
        }));
        useAbilityRegistry.register(Miapi.id("empty"), emptyAbility.ability());
    }

    public static AbilityHolder<?> getEmpty() {
        return emptyAbility;
    }

    private static AbilityHolder<?> getAbility(class_1799 itemStack) {
        AbilityHolder<?> useAbility = abilityMap.get(itemStack);
        return useAbility == null ? emptyAbility : useAbility;
    }

    private static AbilityHolder<?> getAbility(class_1799 itemStack, class_1937 world, class_1657 player, class_1268 hand, AbilityHitContext abilityHitContext) {
        block5: {
            class_2960 keybindID;
            block4: {
                keybindID = null;
                keybindID = player.method_37908().field_9236 ? clientKeyBindID.get(player) : serverKeyBindID.get(player);
                if (keybindID != null) break block4;
                for (Map.Entry entry : ((Map)AbilityMangerProperty.property.getData(itemStack).orElse(new HashMap())).entrySet()) {
                    if (!((ItemUseAbility)entry.getKey()).allowedOnItem(itemStack, world, player, hand, abilityHitContext)) continue;
                    if (player instanceof class_3222) {
                        class_3222 serverPlayer = (class_3222)player;
                        KeyBindFacet.get(serverPlayer).reset(serverPlayer);
                    }
                    return ((ItemUseAbility)entry.getKey()).getAsHolder(entry.getValue());
                }
                break block5;
            }
            Map map = KeyBindAbilityManagerProperty.property.getData(itemStack).orElse(new HashMap());
            Map abilities = (Map)map.get(keybindID);
            if (abilities == null) break block5;
            for (Map.Entry entry : abilities.entrySet()) {
                class_3222 serverPlayer;
                if (!((ItemUseAbility)entry.getKey()).allowedOnItem(itemStack, world, player, hand, abilityHitContext)) continue;
                if (player instanceof class_3222 && KeyBindFacet.get(serverPlayer = (class_3222)player) != null) {
                    KeyBindFacet.get(serverPlayer).set(keybindID, serverPlayer);
                }
                return ((ItemUseAbility)entry.getKey()).getAsHolder(entry.getValue());
            }
        }
        return emptyAbility;
    }

    public static class_1839 getUseAction(class_1799 itemStack, Supplier<class_1839> getItem) {
        AbilityHolder<?> ability = ItemAbilityManager.getAbility(itemStack);
        if (emptyAbility.equals(ability)) {
            return getItem.get();
        }
        return ability.ability().getUseAction(itemStack);
    }

    public static int getMaxUseTime(class_1799 itemStack, class_1309 livingEntity, Supplier<Integer> getItem) {
        AbilityHolder<?> ability = ItemAbilityManager.getAbility(itemStack);
        if (emptyAbility.equals(ability)) {
            return getItem.get();
        }
        return ability.ability().getMaxUseTime(itemStack, livingEntity);
    }

    public static class_1271<class_1799> use(class_1937 world, class_1657 user, class_1268 hand, Supplier<class_1271<class_1799>> getItem) {
        class_1799 itemStack = user.method_5998(hand);
        AbilityHolder<?> ability = ItemAbilityManager.getAbility(itemStack, world, user, hand, new AbilityHitContext(){

            @Override
            @Nullable
            public class_1838 hitResult() {
                return null;
            }

            @Override
            @Nullable
            public class_1297 hitEntity() {
                return null;
            }
        });
        abilityMap.put(itemStack, ability);
        if (emptyAbility.equals(ability)) {
            return getItem.get();
        }
        return ability.ability().use(world, user, hand);
    }

    public static class_1799 finishUsing(class_1799 stack, class_1937 world, class_1309 user, Supplier<class_1799> getItem) {
        AbilityHolder<?> ability = ItemAbilityManager.getAbility(stack);
        if (emptyAbility.equals(ability)) {
            abilityMap.remove(stack);
            return getItem.get();
        }
        class_1799 itemStack = ability.ability().finishUsing(stack, world, user);
        abilityMap.remove(stack);
        return itemStack;
    }

    public static void onStoppedUsing(class_1799 stack, class_1937 world, class_1309 user, int remainingUseTicks, Runnable getItem) {
        AbilityHolder<?> ability = ItemAbilityManager.getAbility(stack);
        if (emptyAbility.equals(ability)) {
            getItem.run();
            return;
        }
        ability.ability().onStoppedUsing(stack, world, user, remainingUseTicks);
        ItemUseAbility<?> itemUseAbility = ability.ability();
        if (itemUseAbility instanceof ItemUseDefaultCooldownAbility) {
            ItemUseDefaultCooldownAbility itemUseDefaultCooldownAbility = (ItemUseDefaultCooldownAbility)itemUseAbility;
            itemUseDefaultCooldownAbility.afterStopAbility(stack, world, user, remainingUseTicks);
        }
        abilityMap.remove(stack);
    }

    public static void usageTick(class_1937 world, class_1309 user, class_1799 stack, int remainingUseTicks, Runnable getItem) {
        AbilityHolder<?> ability = ItemAbilityManager.getAbility(stack);
        if (emptyAbility.equals(ability)) {
            abilityMap.remove(stack);
            getItem.run();
            return;
        }
        ability.ability().usageTick(world, user, stack, remainingUseTicks);
    }

    public static boolean useOnRelease(class_1799 stack, Supplier<Boolean> getItem) {
        AbilityHolder<?> ability = ItemAbilityManager.getAbility(stack);
        if (emptyAbility.equals(ability)) {
            abilityMap.remove(stack);
            return getItem.get();
        }
        return ability.ability().useOnRelease(stack);
    }

    public static class_1269 useOnEntity(class_1799 stack, class_1657 user, final class_1309 entity, class_1268 hand, Supplier<class_1269> getItem) {
        AbilityHolder<?> ability = ItemAbilityManager.getAbility(stack, user.method_37908(), user, hand, new AbilityHitContext(){

            @Override
            @Nullable
            public class_1838 hitResult() {
                return null;
            }

            @Override
            @Nullable
            public class_1297 hitEntity() {
                return entity;
            }
        });
        if (emptyAbility.equals(ability)) {
            return getItem.get();
        }
        abilityMap.put(stack, ability);
        return ItemAbilityManager.getAbility(stack).ability().useOnEntity(stack, user, entity, hand);
    }

    public static class_1269 useOnBlock(final class_1838 context, Supplier<class_1269> getItem) {
        AbilityHolder<?> ability = ItemAbilityManager.getAbility(context.method_8041(), context.method_8045(), context.method_8036(), context.method_20287(), new AbilityHitContext(){

            @Override
            @Nullable
            public class_1838 hitResult() {
                return context;
            }

            @Override
            @Nullable
            public class_1297 hitEntity() {
                return null;
            }
        });
        if (emptyAbility.equals(ability)) {
            return getItem.get();
        }
        abilityMap.put(context.method_8041(), ability);
        if (Platform.isForgeLike()) {
            class_1269 result = ItemAbilityManager.getAbility(context.method_8041()).ability().useOnBlock(context);
            if (result.equals((Object)class_1269.field_5811)) {
                return getItem.get();
            }
            return result;
        }
        return ItemAbilityManager.getAbility(context.method_8041()).ability().useOnBlock(context);
    }

    public record AbilityHolder<T>(ItemUseAbility<T> ability, T context) {
        public AbilityHolder(Object context, ItemUseAbility<T> ability) {
            this(ability, ability.castTo(context));
        }
    }

    public static interface AbilityHitContext {
        @Nullable
        public class_1838 hitResult();

        @Nullable
        public class_1297 hitEntity();
    }

    static class EmptyAbility
    implements ItemUseAbility {
        EmptyAbility() {
        }

        @Override
        public boolean allowedOnItem(class_1799 itemStack, class_1937 world, class_1657 player, class_1268 hand, AbilityHitContext abilityHitContext) {
            return true;
        }

        @Override
        public class_1839 getUseAction(class_1799 itemStack) {
            return class_1839.field_8952;
        }

        @Override
        public int getMaxUseTime(class_1799 itemStack, class_1309 entity) {
            return 0;
        }

        @Override
        public class_1271<class_1799> use(class_1937 world, class_1657 user, class_1268 hand) {
            return class_1271.method_22430((Object)user.method_5998(hand));
        }

        public Object decode(DynamicOps ops, Object prefix) {
            return null;
        }

        public Object getDefaultContext() {
            return null;
        }
    }
}

