/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.modules.cache;

import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.class_1799;
import org.jetbrains.annotations.Nullable;
import smartin.miapi.datapack.ReloadEvents;
import smartin.miapi.item.modular.VisualModularItem;
import smartin.miapi.modules.ItemModule;
import smartin.miapi.modules.ModuleInstance;
import smartin.miapi.modules.cache.DataCache;

public class ModularItemCache {
    protected static Map<String, CacheObjectSupplier> supplierMap = new ConcurrentHashMap<String, CacheObjectSupplier>();
    public static Map<String, DataCache.ModuleCacheSupplier> MODULE_CACHE_SUPPLIER = new ConcurrentHashMap<String, DataCache.ModuleCacheSupplier>();
    public static WeakInstanceTracker<ModuleInstance> modules = new WeakInstanceTracker();

    public static void setSupplier(String key, CacheObjectSupplier supplier) {
        supplierMap.put(key, supplier);
    }

    @Nullable
    public static <T> T getRaw(class_1799 stack, String key) {
        return ModularItemCache.get(stack, key, null);
    }

    public static <T> T get(class_1799 stack, String key, T fallback) {
        return (T)ModularItemCache.get(stack, key, () -> fallback);
    }

    public static <T> T get(class_1799 stack, String key, Supplier<T> fallback) {
        ModuleInstance moduleInstance = ItemModule.getModules(stack);
        if (moduleInstance != null) {
            return moduleInstance.getFromCache(key, stack, supplierMap, fallback);
        }
        return fallback.get();
    }

    public static <T> T getVisualOnlyCache(class_1799 stack, String key, T fallback) {
        if (!ReloadEvents.isInReload() && !stack.method_7960() && stack.method_7909() instanceof VisualModularItem) {
            return (T)ModularItemCache.get(stack, key, () -> fallback);
        }
        return fallback;
    }

    public static void discardCache() {
        modules.getInstances().forEach(m -> {
            if (m != null) {
                m.clearCaches();
            }
        });
    }

    public static class WeakInstanceTracker<T> {
        private Object threadLock = new Object();
        private final Set<T> instances = Collections.newSetFromMap(new WeakHashMap());

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addInstance(T instance) {
            Object object = this.threadLock;
            synchronized (object) {
                this.instances.add(instance);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Set<T> getInstances() {
            Object object = this.threadLock;
            synchronized (object) {
                return new HashSet<T>(this.instances);
            }
        }
    }

    public static interface CacheObjectSupplier
    extends Function<class_1799, Object> {
        @Override
        public Object apply(class_1799 var1);
    }
}

